/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.model.AuthUserGender;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthTencentCloudRequest
extends BaseAuthRequest {
    public AuthTencentCloudRequest(AuthConfig config) {
        super(config, AuthSource.TENCENT_CLOUD);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getTencentCloudAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code);
        HttpResponse response = HttpRequest.get((String)accessTokenUrl).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.getIntValue("code") != 0) {
            throw new AuthException("Unable to get token from tencent cloud using code [" + code + "]: " + object.get((Object)"msg"));
        }
        return AuthToken.builder().accessToken(object.getString("access_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getTencentCloudUserInfoUrl(accessToken)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.getIntValue("code") != 0) {
            throw new AuthException(object.getString("msg"));
        }
        object = object.getJSONObject("data");
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("name")).avatar("https://dev.tencent.com/" + object.getString("avatar")).blog("https://dev.tencent.com/" + object.getString("path")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).gender(AuthUserGender.getRealGender(object.getString("sex"))).email(object.getString("email")).remark(object.getString("slogan")).token(authToken).source(AuthSource.TENCENT_CLOUD).build();
    }
}

