/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.model.AuthUserGender;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.GlobalAuthUtil;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthQqRequest
extends BaseAuthRequest {
    public AuthQqRequest(AuthConfig config) {
        super(config, AuthSource.QQ);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getQqAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code, this.config.getRedirectUri());
        HttpResponse response = HttpRequest.get((String)accessTokenUrl).execute();
        Map<String, String> accessTokenObject = GlobalAuthUtil.parseStringToMap(response.body());
        if (!accessTokenObject.containsKey("access_token")) {
            throw new AuthException("Unable to get token from qq using code [" + code + "]");
        }
        return AuthToken.builder().accessToken(accessTokenObject.get("access_token")).expireIn(Integer.valueOf(accessTokenObject.get("expires_in"))).refreshToken(accessTokenObject.get("refresh_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        String openId = this.getOpenId(accessToken);
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getQqUserInfoUrl(this.config.getClientId(), accessToken, openId)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.getIntValue("ret") != 0) {
            throw new AuthException(object.getString("msg"));
        }
        String avatar = object.getString("figureurl_qq_2");
        if (StringUtils.isEmpty(avatar)) {
            avatar = object.getString("figureurl_qq_1");
        }
        return AuthUser.builder().username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(avatar).location(object.getString("province") + "-" + object.getString("city")).uuid(openId).gender(AuthUserGender.getRealGender(object.getString("gender"))).token(authToken).source(AuthSource.QQ).build();
    }

    private String getOpenId(String accessToken) {
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getQqOpenidUrl("https://graph.qq.com/oauth2.0/me", accessToken)).execute();
        if (response.isOk()) {
            String body = response.body();
            String removePrefix = StrUtil.replace((CharSequence)body, (CharSequence)"callback(", (CharSequence)"");
            String removeSuffix = StrUtil.replace((CharSequence)removePrefix, (CharSequence)");", (CharSequence)"");
            String openId = StrUtil.trim((CharSequence)removeSuffix);
            JSONObject object = JSONObject.parseObject((String)openId);
            if (object.containsKey((Object)"openid")) {
                return object.getString("openid");
            }
            throw new AuthException("Invalid openId");
        }
        throw new AuthException("Invalid openId");
    }
}

