/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.model.AuthUserGender;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthOschinaRequest
extends BaseAuthRequest {
    public AuthOschinaRequest(AuthConfig config) {
        super(config, AuthSource.OSCHINA);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getOschinaAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code, this.config.getRedirectUri());
        HttpResponse response = HttpRequest.post((String)accessTokenUrl).execute();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response.body());
        if (accessTokenObject.containsKey((Object)"error")) {
            throw new AuthException("Unable to get token from oschina using code [" + code + "]");
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getOschinaUserInfoUrl(accessToken)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("name")).nickname(object.getString("name")).avatar(object.getString("avatar")).blog(object.getString("url")).location(object.getString("location")).gender(AuthUserGender.getRealGender(object.getString("gender"))).email(object.getString("email")).token(authToken).source(AuthSource.OSCHINA).build();
    }
}

