/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.request.ResponseStatus;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthLinkedinRequest
extends BaseAuthRequest {
    public AuthLinkedinRequest(AuthConfig config) {
        super(config, AuthSource.LINKEDIN);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getLinkedinAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code, this.config.getRedirectUri());
        return this.getToken(accessTokenUrl);
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        JSONArray displayImageElements;
        String accessToken = authToken.getAccessToken();
        HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)UrlBuilder.getLinkedinUserInfoUrl()).header("Host", "api.linkedin.com")).header("Connection", "Keep-Alive")).header("Authorization", "Bearer " + accessToken)).execute();
        JSONObject userInfoObject = JSONObject.parseObject((String)response.body());
        this.checkResponse(userInfoObject);
        String firstName = userInfoObject.containsKey((Object)"localizedFirstName") ? userInfoObject.getString("localizedFirstName") : this.getUserName(userInfoObject, "firstName");
        String lastName = userInfoObject.containsKey((Object)"localizedLastName") ? userInfoObject.getString("localizedLastName") : this.getUserName(userInfoObject, "lastName");
        String userName = firstName + " " + lastName;
        String avatar = null;
        JSONObject profilePictureObject = userInfoObject.getJSONObject("profilePicture");
        if (profilePictureObject.containsKey((Object)"displayImage~") && null != (displayImageElements = profilePictureObject.getJSONObject("displayImage~").getJSONArray("elements")) && displayImageElements.size() > 0) {
            JSONObject largestImageObj = displayImageElements.getJSONObject(displayImageElements.size() - 1);
            avatar = largestImageObj.getJSONArray("identifiers").getJSONObject(0).getString("identifier");
        }
        String email = this.getUserEmail(accessToken);
        return AuthUser.builder().uuid(userInfoObject.getString("id")).username(userName).nickname(userName).avatar(avatar).email(email).token(authToken).source(AuthSource.LINKEDIN).build();
    }

    private String getUserEmail(String accessToken) {
        String email = null;
        HttpResponse emailResponse = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)"https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))").header("Host", "api.linkedin.com")).header("Connection", "Keep-Alive")).header("Authorization", "Bearer " + accessToken)).execute();
        System.out.println(emailResponse.body());
        JSONObject emailObj = JSONObject.parseObject((String)emailResponse.body());
        if (emailObj.containsKey((Object)"elements")) {
            email = emailObj.getJSONArray("elements").getJSONObject(0).getJSONObject("handle~").getString("emailAddress");
        }
        return email;
    }

    private String getUserName(JSONObject userInfoObject, String nameKey) {
        JSONObject firstNameObj = userInfoObject.getJSONObject(nameKey);
        JSONObject localizedObj = firstNameObj.getJSONObject("localized");
        JSONObject preferredLocaleObj = firstNameObj.getJSONObject("preferredLocale");
        String firstName = localizedObj.getString(preferredLocaleObj.getString("language") + "_" + preferredLocaleObj.getString("country"));
        return firstName;
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        if (StringUtils.isEmpty(oldToken.getRefreshToken())) {
            throw new AuthException(ResponseStatus.UNSUPPORTED);
        }
        String refreshTokenUrl = UrlBuilder.getLinkedinRefreshUrl(this.config.getClientId(), this.config.getClientSecret(), oldToken.getRefreshToken());
        return AuthResponse.builder().code(ResponseStatus.SUCCESS.getCode()).data(this.getToken(refreshTokenUrl)).build();
    }

    private void checkResponse(JSONObject userInfoObject) {
        if (userInfoObject.containsKey((Object)"error")) {
            throw new AuthException(userInfoObject.getString("error_description"));
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpRequest.post((String)accessTokenUrl).header("Host", "www.linkedin.com")).header("Content-Type", "application/x-www-form-urlencoded")).execute();
        String accessTokenStr = response.body();
        JSONObject accessTokenObject = JSONObject.parseObject((String)accessTokenStr);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }
}

