/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.BaseAuthRequest;
import me.zhyd.oauth.request.ResponseStatus;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthDouyinRequest
extends BaseAuthRequest {
    public AuthDouyinRequest(AuthConfig config) {
        super(config, AuthSource.DOUYIN);
    }

    @Override
    protected AuthToken getAccessToken(String code) {
        String accessTokenUrl = UrlBuilder.getDouyinAccessTokenUrl(this.config.getClientId(), this.config.getClientSecret(), code);
        return this.getToken(accessTokenUrl);
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        String openId = authToken.getOpenId();
        HttpResponse response = HttpRequest.get((String)UrlBuilder.getDouyinUserInfoUrl(accessToken, openId)).execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        JSONObject userInfoObject = this.checkResponse(object);
        return AuthUser.builder().uuid(userInfoObject.getString("open_id")).username(userInfoObject.getString("nickname")).nickname(userInfoObject.getString("nickname")).avatar(userInfoObject.getString("avatar")).token(authToken).source(AuthSource.DOUYIN).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        String refreshTokenUrl = UrlBuilder.getDouyinRefreshUrl(this.config.getClientId(), oldToken.getRefreshToken());
        return AuthResponse.builder().code(ResponseStatus.SUCCESS.getCode()).data(this.getToken(refreshTokenUrl)).build();
    }

    private JSONObject checkResponse(JSONObject object) {
        String message = object.getString("message");
        JSONObject data = object.getJSONObject("data");
        int errorCode = data.getIntValue("error_code");
        if ("error".equals(message) || errorCode != 0) {
            throw new AuthException(errorCode, data.getString("description"));
        }
        return data;
    }

    private AuthToken getToken(String accessTokenUrl) {
        HttpResponse response = HttpRequest.post((String)accessTokenUrl).execute();
        String accessTokenStr = response.body();
        JSONObject object = JSONObject.parseObject((String)accessTokenStr);
        JSONObject accessTokenObject = this.checkResponse(object);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).openId(accessTokenObject.getString("open_id")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).scope(accessTokenObject.getString("scope")).build();
    }
}

