/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.config;

public class AuthConfig {
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private String alipayPublicKey;

    public static AuthConfigBuilder builder() {
        return new AuthConfigBuilder();
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setAlipayPublicKey(String alipayPublicKey) {
        this.alipayPublicKey = alipayPublicKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getAlipayPublicKey() {
        return this.alipayPublicKey;
    }

    public AuthConfig() {
    }

    public AuthConfig(String clientId, String clientSecret, String redirectUri, String alipayPublicKey) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.alipayPublicKey = alipayPublicKey;
    }

    public static class AuthConfigBuilder {
        private String clientId;
        private String clientSecret;
        private String redirectUri;
        private String alipayPublicKey;

        AuthConfigBuilder() {
        }

        public AuthConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AuthConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public AuthConfigBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthConfigBuilder alipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
            return this;
        }

        public AuthConfig build() {
            return new AuthConfig(this.clientId, this.clientSecret, this.redirectUri, this.alipayPublicKey);
        }

        public String toString() {
            return "AuthConfig.AuthConfigBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", redirectUri=" + this.redirectUri + ", alipayPublicKey=" + this.alipayPublicKey + ")";
        }
    }
}

