/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.authorization;

import java.util.HashMap;
import java.util.Map;
import me.zhyd.oauth.authorization.AlipayAuthorization;
import me.zhyd.oauth.authorization.Authorization;
import me.zhyd.oauth.authorization.BaiduAuthorization;
import me.zhyd.oauth.authorization.CodingAuthorization;
import me.zhyd.oauth.authorization.CsdnAuthorization;
import me.zhyd.oauth.authorization.DingTalkAuthorization;
import me.zhyd.oauth.authorization.DouyinAuthorization;
import me.zhyd.oauth.authorization.FacebookAuthorization;
import me.zhyd.oauth.authorization.GiteeAuthorization;
import me.zhyd.oauth.authorization.GithubAuthorization;
import me.zhyd.oauth.authorization.GoogleAuthorization;
import me.zhyd.oauth.authorization.LinkedinAuthorization;
import me.zhyd.oauth.authorization.OschinaAuthorization;
import me.zhyd.oauth.authorization.QqAuthorization;
import me.zhyd.oauth.authorization.TaobaoAuthorization;
import me.zhyd.oauth.authorization.TencentCloudAuthorization;
import me.zhyd.oauth.authorization.WeChatAuthorization;
import me.zhyd.oauth.authorization.WeiboAuthorization;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthSource;
import me.zhyd.oauth.request.ResponseStatus;

public class AuthorizationFactory {
    private static Map<String, Authorization> authorizationMap = new HashMap<String, Authorization>();
    private static boolean loader = false;

    private AuthorizationFactory() {
    }

    public static Authorization getAuthorize(AuthSource source) {
        if (null == source) {
            throw new AuthException(ResponseStatus.NO_AUTH_SOURCE);
        }
        AuthorizationFactory.registerAllAuthorize();
        Authorization authorization = authorizationMap.get(source.toString());
        if (null == authorization) {
            throw new AuthException(ResponseStatus.UNIDENTIFIED_PLATFORM);
        }
        return authorization;
    }

    private static void registerAllAuthorize() {
        if (loader) {
            return;
        }
        AuthorizationFactory.register(AuthSource.ALIPAY, new AlipayAuthorization());
        AuthorizationFactory.register(AuthSource.BAIDU, new BaiduAuthorization());
        AuthorizationFactory.register(AuthSource.CODING, new CodingAuthorization());
        AuthorizationFactory.register(AuthSource.CSDN, new CsdnAuthorization());
        AuthorizationFactory.register(AuthSource.DINGTALK, new DingTalkAuthorization());
        AuthorizationFactory.register(AuthSource.GITEE, new GiteeAuthorization());
        AuthorizationFactory.register(AuthSource.GITHUB, new GithubAuthorization());
        AuthorizationFactory.register(AuthSource.GOOGLE, new GoogleAuthorization());
        AuthorizationFactory.register(AuthSource.OSCHINA, new OschinaAuthorization());
        AuthorizationFactory.register(AuthSource.QQ, new QqAuthorization());
        AuthorizationFactory.register(AuthSource.TAOBAO, new TaobaoAuthorization());
        AuthorizationFactory.register(AuthSource.TENCENT_CLOUD, new TencentCloudAuthorization());
        AuthorizationFactory.register(AuthSource.WECHAT, new WeChatAuthorization());
        AuthorizationFactory.register(AuthSource.WEIBO, new WeiboAuthorization());
        AuthorizationFactory.register(AuthSource.FACEBOOK, new FacebookAuthorization());
        AuthorizationFactory.register(AuthSource.DOUYIN, new DouyinAuthorization());
        AuthorizationFactory.register(AuthSource.LINKEDIN, new LinkedinAuthorization());
        loader = true;
    }

    private static void register(AuthSource authSource, Authorization authorization) {
        authorizationMap.put(authSource.toString(), authorization);
    }
}

