/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.service;

import eleme.openapi.sdk.api.annotation.Service;
import eleme.openapi.sdk.api.base.BaseNopService;
import eleme.openapi.sdk.api.entity.ugc.OpenapiItemRate;
import eleme.openapi.sdk.api.entity.ugc.OpenapiOrderRate;
import eleme.openapi.sdk.api.enumeration.ugc.ReplyType;
import eleme.openapi.sdk.api.exception.ServiceException;
import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.response.Token;
import java.util.HashMap;
import java.util.List;

@Service(value="eleme.ugc")
public class UgcService
extends BaseNopService {
    public UgcService(Config config, Token token) {
        super(config, token, UgcService.class);
    }

    public OpenapiOrderRate getOrderRateByOrderId(String orderId) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        return (OpenapiOrderRate)this.call("eleme.ugc.getOrderRateByOrderId", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByOrderIds(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (List)this.call("eleme.ugc.getOrderRatesByOrderIds", params);
    }

    public List<OpenapiOrderRate> getUnreplyOrderRatesByOrderIds(List<String> orderIds) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        return (List)this.call("eleme.ugc.getUnreplyOrderRatesByOrderIds", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByShopId(String shopId, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getOrderRatesByShopId", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByShopIds(List<String> shopIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getOrderRatesByShopIds", params);
    }

    public List<OpenapiOrderRate> getUnreplyOrderRatesByShopIds(List<String> shopIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopIds", shopIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getUnreplyOrderRatesByShopIds", params);
    }

    public List<OpenapiOrderRate> getOrderRatesByShopAndRating(String shopId, int score, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shopId", shopId);
        params.put("score", score);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getOrderRatesByShopAndRating", params);
    }

    public List<OpenapiItemRate> getItemRatesByItemId(String itemId, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getItemRatesByItemId", params);
    }

    public List<OpenapiItemRate> getItemRatesByItemIds(List<String> itemIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getItemRatesByItemIds", params);
    }

    public List<OpenapiItemRate> getUnreplyItemRatesByItemIds(List<String> itemIds, String startTime, String endTime, int offset, int pageSize) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        params.put("offset", offset);
        params.put("pageSize", pageSize);
        return (List)this.call("eleme.ugc.getUnreplyItemRatesByItemIds", params);
    }

    public void replyRateByRateId(String rateId, ReplyType replyType, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateId", rateId);
        params.put("replyType", (Object)replyType);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByRateId", params);
    }

    public void replyRateByRateIds(List<String> rateIds, ReplyType replyType, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateIds", rateIds);
        params.put("replyType", (Object)replyType);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByRateIds", params);
    }

    public void replyRateByOrderId(String orderId, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", orderId);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByOrderId", params);
    }

    public void replyCommentByOrderIds(List<String> orderIds, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderIds", orderIds);
        params.put("reply", reply);
        this.call("eleme.ugc.replyCommentByOrderIds", params);
    }

    public void replyRatesByItemId(String itemId, String reply, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemId", itemId);
        params.put("reply", reply);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        this.call("eleme.ugc.replyRatesByItemId", params);
    }

    public void replyRatesByItemIds(List<String> itemIds, String reply, String startTime, String endTime) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("itemIds", itemIds);
        params.put("reply", reply);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        this.call("eleme.ugc.replyRatesByItemIds", params);
    }

    public void replyRateByRateIdAndShopId(String rateId, String shopId, ReplyType replyType, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateId", rateId);
        params.put("shopId", shopId);
        params.put("replyType", (Object)replyType);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByRateIdAndShopId", params);
    }

    public void replyRateByRateIdsAndShopId(List<String> rateIds, String shopId, ReplyType replyType, String reply) throws ServiceException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rateIds", rateIds);
        params.put("shopId", shopId);
        params.put("replyType", (Object)replyType);
        params.put("reply", reply);
        this.call("eleme.ugc.replyRateByRateIdsAndShopId", params);
    }
}

