/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.KeyValueAnnotation;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.TraceData;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Span;
import java.util.logging.Logger;

public class ServerRequestInterceptor {
    private static final Logger LOGGER = Logger.getLogger(ServerRequestInterceptor.class.getName());
    private final ServerTracer serverTracer;

    public ServerRequestInterceptor(ServerTracer serverTracer) {
        this.serverTracer = Util.checkNotNull(serverTracer, "Null serverTracer", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServerRequestAdapter adapter) {
        this.serverTracer.clearCurrentSpan();
        TraceData traceData = adapter.getTraceData();
        Boolean sample = traceData.getSample();
        if (sample != null && Boolean.FALSE.equals(sample)) {
            this.serverTracer.setStateNoTracing();
            LOGGER.fine("Received indication that we should NOT trace.");
        } else {
            boolean clientOriginatedTrace;
            boolean bl = clientOriginatedTrace = traceData.getSpanId() != null;
            if (clientOriginatedTrace) {
                LOGGER.fine("Received span information as part of request.");
                this.serverTracer.setStateCurrentTrace(traceData.getSpanId(), adapter.getSpanName());
            } else {
                LOGGER.fine("Received no span state.");
                this.serverTracer.setStateUnknown(adapter.getSpanName());
            }
            this.serverTracer.setServerReceived();
            if (clientOriginatedTrace) {
                Span span;
                Span span2 = span = this.serverTracer.spanAndEndpoint().span();
                synchronized (span2) {
                    span.setTimestamp(null);
                    span.startTick = null;
                }
            }
            for (KeyValueAnnotation annotation : adapter.requestAnnotations()) {
                this.serverTracer.submitBinaryAnnotation(annotation.getKey(), annotation.getValue());
            }
        }
    }
}

