/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.internal.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.Span;
import zipkin.reporter.Reporter;

public final class LoggingReporter
implements Reporter<Span> {
    final Logger logger;

    public LoggingReporter() {
        this("com.github.kristofa.brave.LoggingSpanCollector");
    }

    public LoggingReporter(String loggerName) {
        Util.checkNotBlank(loggerName, "Null or blank loggerName", new Object[0]);
        this.logger = Logger.getLogger(loggerName);
    }

    public void report(Span span) {
        Util.checkNotNull(span, "Null span", new Object[0]);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(span.toString());
        }
    }
}

