/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.AnnotationSubmitter;
import com.github.kristofa.brave.AutoValue_LocalTracer;
import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.ServerClientAndLocalSpanState;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.SpanId;
import com.github.kristofa.brave.internal.Nullable;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Span;
import java.util.Random;
import zipkin.reporter.Reporter;

public abstract class LocalTracer
extends AnnotationSubmitter {
    static Builder builder() {
        return new AutoValue_LocalTracer.Builder();
    }

    static Builder builder(LocalTracer source) {
        return new AutoValue_LocalTracer.Builder(source);
    }

    @Override
    abstract SpanAndEndpoint.LocalSpanAndEndpoint spanAndEndpoint();

    abstract Random randomGenerator();

    abstract Reporter<zipkin.Span> reporter();

    abstract boolean allowNestedLocalSpans();

    abstract Sampler traceSampler();

    @Override
    abstract AnnotationSubmitter.Clock clock();

    abstract boolean traceId128Bit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpanId startNewSpan(String component, String operation) {
        Span span;
        SpanId spanId = this.startNewSpan(component, operation, this.clock().currentTimeMicroseconds());
        if (spanId == null) {
            return null;
        }
        Span span2 = span = this.spanAndEndpoint().span();
        synchronized (span2) {
            span.startTick = System.nanoTime();
        }
        return spanId;
    }

    private SpanId getNewSpanId() {
        Span parentSpan = this.getNewSpanParent();
        long newSpanId = this.randomGenerator().nextLong();
        SpanId.Builder builder = SpanId.builder().spanId(newSpanId);
        if (parentSpan == null) {
            if (this.traceId128Bit()) {
                builder.traceIdHigh(this.randomGenerator().nextLong());
            }
            return builder.traceId(newSpanId).build();
        }
        return builder.traceIdHigh(parentSpan.getTrace_id_high()).traceId(parentSpan.getTrace_id()).parentId(parentSpan.getId()).build();
    }

    @Nullable
    Span getNewSpanParent() {
        ServerSpan currentServerSpan;
        ServerClientAndLocalSpanState state = this.spanAndEndpoint().state();
        Span parentSpan = null;
        if (this.allowNestedLocalSpans()) {
            parentSpan = state.getCurrentLocalSpan();
        }
        if (parentSpan == null && (currentServerSpan = state.getCurrentServerSpan()) != null) {
            parentSpan = currentServerSpan.getSpan();
        }
        return parentSpan;
    }

    public SpanId startNewSpan(String component, String operation, long timestamp) {
        Boolean sample = this.spanAndEndpoint().state().sample();
        if (Boolean.FALSE.equals(sample)) {
            this.spanAndEndpoint().state().setCurrentLocalSpan(null);
            return null;
        }
        SpanId newSpanId = this.getNewSpanId();
        if (sample == null && !this.traceSampler().isSampled(newSpanId.traceId)) {
            this.spanAndEndpoint().state().setCurrentLocalSpan(null);
            return null;
        }
        Span newSpan = newSpanId.toSpan();
        newSpan.setName(operation);
        newSpan.setTimestamp(timestamp);
        newSpan.addToBinary_annotations(BinaryAnnotation.create("lc", component, this.spanAndEndpoint().endpoint()));
        this.spanAndEndpoint().state().setCurrentLocalSpan(newSpan);
        return newSpanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishSpan() {
        Long startTick;
        long endTick = System.nanoTime();
        Span span = this.spanAndEndpoint().span();
        if (span == null) {
            return;
        }
        Span span2 = span;
        synchronized (span2) {
            startTick = span.startTick;
        }
        long duration = startTick != null ? Math.max(1L, (endTick - startTick) / 1000L) : Math.max(1L, this.clock().currentTimeMicroseconds() - span.getTimestamp());
        this.internalFinishSpan(span, duration);
    }

    public void finishSpan(long duration) {
        Span span = this.spanAndEndpoint().span();
        if (span == null) {
            return;
        }
        this.internalFinishSpan(span, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFinishSpan(Span span, long duration) {
        Span span2 = span;
        synchronized (span2) {
            span.setDuration(duration);
        }
        this.reporter().report((Object)span.toZipkin());
        this.spanAndEndpoint().state().setCurrentLocalSpan(null);
    }

    LocalTracer() {
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder spanAndEndpoint(SpanAndEndpoint.LocalSpanAndEndpoint var1);

        abstract Builder randomGenerator(Random var1);

        abstract Builder reporter(Reporter<zipkin.Span> var1);

        abstract Builder allowNestedLocalSpans(boolean var1);

        abstract Builder traceSampler(Sampler var1);

        abstract Builder clock(AnnotationSubmitter.Clock var1);

        abstract Builder traceId128Bit(boolean var1);

        abstract LocalTracer build();
    }
}

