/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.generator;

import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class GeneratorUtils {
    final String classHeader = this.loadResource("class_header") + "\n";
    final String proxyGenImports = this.loadResource("proxy_gen_import") + "\n";
    final String handlerGenImports = this.loadResource("handler_gen_import") + "\n";
    final String roger;
    final String handlerConstructorBody = this.loadResource("handler_constructor_body") + "\n";
    final String handlerCloseAccessed = this.loadResource("handler_close_accessed") + "\n";

    public GeneratorUtils() {
        this.roger = this.loadResource("roger") + "\n";
    }

    public void classHeader(PrintWriter w) {
        w.print(this.classHeader);
    }

    public void proxyGenImports(PrintWriter w) {
        w.print(this.proxyGenImports);
    }

    public void handlerGenImports(PrintWriter w) {
        w.print(this.handlerGenImports);
    }

    public void roger(PrintWriter w) {
        w.print(this.roger);
    }

    public void handlerConstructorBody(PrintWriter w) {
        w.print(this.handlerConstructorBody);
    }

    public void handleCloseAccessed(PrintWriter w) {
        w.print(this.handlerCloseAccessed);
    }

    public void writeImport(PrintWriter w, String i) {
        w.print("import " + i + ";\n");
    }

    public String loadResource(String resource) {
        return this.loadResource(resource, "vertx-service-proxy");
    }

    public String loadResource(String resource, String moduleName) {
        InputStream input = GeneratorUtils.class.getResourceAsStream("/META-INF/vertx/" + moduleName + "/" + resource + ".txt");
        try (Scanner scanner = new Scanner(input, StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    public boolean isResultHandler(ParamInfo param) {
        return param != null && param.getType().getKind() == ClassKind.HANDLER && ((ParameterizedTypeInfo)param.getType()).getArg(0).getKind() == ClassKind.ASYNC_RESULT;
    }
}

