/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module testmodel-js/data_object_tck */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JDataObjectTCK = Java.type('io.vertx.codegen.testmodel.DataObjectTCK');
var DataObjectWithMaps = Java.type('io.vertx.codegen.testmodel.DataObjectWithMaps');
var DataObjectWithRecursion = Java.type('io.vertx.codegen.testmodel.DataObjectWithRecursion');
var DataObjectWithOnlyJsonObjectConstructor = Java.type('io.vertx.codegen.testmodel.DataObjectWithOnlyJsonObjectConstructor');
var DataObjectWithMapAdders = Java.type('io.vertx.codegen.testmodel.DataObjectWithMapAdders');
var DataObjectWithListAdders = Java.type('io.vertx.codegen.testmodel.DataObjectWithListAdders');
var DataObjectWithLists = Java.type('io.vertx.codegen.testmodel.DataObjectWithLists');
var DataObjectWithNestedBuffer = Java.type('io.vertx.codegen.testmodel.DataObjectWithNestedBuffer');
var DataObjectWithValues = Java.type('io.vertx.codegen.testmodel.DataObjectWithValues');

/**
 todo:
 - Buffer support

 @class
*/
var DataObjectTCK = function(j_val) {

  var j_dataObjectTCK = j_val;
  var that = this;

  var __super_getDataObjectWithValues = this.getDataObjectWithValues;
  var __super_setDataObjectWithValues = this.setDataObjectWithValues;
  var __super_getDataObjectWithLists = this.getDataObjectWithLists;
  var __super_setDataObjectWithLists = this.setDataObjectWithLists;
  var __super_getDataObjectWithMaps = this.getDataObjectWithMaps;
  var __super_setDataObjectWithMaps = this.setDataObjectWithMaps;
  var __super_methodWithOnlyJsonObjectConstructorDataObject = this.methodWithOnlyJsonObjectConstructorDataObject;
  var __super_setDataObjectWithBuffer = this.setDataObjectWithBuffer;
  var __super_setDataObjectWithListAdders = this.setDataObjectWithListAdders;
  var __super_setDataObjectWithMapAdders = this.setDataObjectWithMapAdders;
  var __super_setDataObjectWithRecursion = this.setDataObjectWithRecursion;
  /**

   @public

   @return {Object}
   */
  this.getDataObjectWithValues =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnDataObject(j_dataObjectTCK["getDataObjectWithValues()"]()) ;
    } else if (typeof __super_getDataObjectWithValues != 'undefined') {
      return __super_getDataObjectWithValues.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.setDataObjectWithValues =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["setDataObjectWithValues(io.vertx.codegen.testmodel.DataObjectWithValues)"](__args[0]  != null ? new DataObjectWithValues(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_setDataObjectWithValues != 'undefined') {
      return __super_setDataObjectWithValues.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object}
   */
  this.getDataObjectWithLists =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnDataObject(j_dataObjectTCK["getDataObjectWithLists()"]()) ;
    } else if (typeof __super_getDataObjectWithLists != 'undefined') {
      return __super_getDataObjectWithLists.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.setDataObjectWithLists =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["setDataObjectWithLists(io.vertx.codegen.testmodel.DataObjectWithLists)"](__args[0]  != null ? new DataObjectWithLists(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_setDataObjectWithLists != 'undefined') {
      return __super_setDataObjectWithLists.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object}
   */
  this.getDataObjectWithMaps =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnDataObject(j_dataObjectTCK["getDataObjectWithMaps()"]()) ;
    } else if (typeof __super_getDataObjectWithMaps != 'undefined') {
      return __super_getDataObjectWithMaps.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.setDataObjectWithMaps =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["setDataObjectWithMaps(io.vertx.codegen.testmodel.DataObjectWithMaps)"](__args[0]  != null ? new DataObjectWithMaps(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_setDataObjectWithMaps != 'undefined') {
      return __super_setDataObjectWithMaps.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.methodWithOnlyJsonObjectConstructorDataObject =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["methodWithOnlyJsonObjectConstructorDataObject(io.vertx.codegen.testmodel.DataObjectWithOnlyJsonObjectConstructor)"](__args[0]  != null ? new DataObjectWithOnlyJsonObjectConstructor(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_methodWithOnlyJsonObjectConstructorDataObject != 'undefined') {
      return __super_methodWithOnlyJsonObjectConstructorDataObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.setDataObjectWithBuffer =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["setDataObjectWithBuffer(io.vertx.codegen.testmodel.DataObjectWithNestedBuffer)"](__args[0]  != null ? new DataObjectWithNestedBuffer(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_setDataObjectWithBuffer != 'undefined') {
      return __super_setDataObjectWithBuffer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.setDataObjectWithListAdders =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["setDataObjectWithListAdders(io.vertx.codegen.testmodel.DataObjectWithListAdders)"](__args[0]  != null ? new DataObjectWithListAdders(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_setDataObjectWithListAdders != 'undefined') {
      return __super_setDataObjectWithListAdders.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.setDataObjectWithMapAdders =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["setDataObjectWithMapAdders(io.vertx.codegen.testmodel.DataObjectWithMapAdders)"](__args[0]  != null ? new DataObjectWithMapAdders(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_setDataObjectWithMapAdders != 'undefined') {
      return __super_setDataObjectWithMapAdders.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param dataObject {Object} 
   */
  this.setDataObjectWithRecursion =  function(dataObject) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_dataObjectTCK["setDataObjectWithRecursion(io.vertx.codegen.testmodel.DataObjectWithRecursion)"](__args[0]  != null ? new DataObjectWithRecursion(new JsonObject(Java.asJSONCompatible(__args[0]))) : null);
    } else if (typeof __super_setDataObjectWithRecursion != 'undefined') {
      return __super_setDataObjectWithRecursion.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_dataObjectTCK;
};

DataObjectTCK._jclass = utils.getJavaClass("io.vertx.codegen.testmodel.DataObjectTCK");
DataObjectTCK._jtype = {accept: function(obj) {
    return DataObjectTCK._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(DataObjectTCK.prototype, {});
    DataObjectTCK.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
DataObjectTCK._create = function(jdel) {var obj = Object.create(DataObjectTCK.prototype, {});
  DataObjectTCK.apply(obj, arguments);
  return obj;
}
module.exports = DataObjectTCK;