/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.server.events;

import io.reactivex.netty.channel.events.ConnectionEventListener;
import io.reactivex.netty.channel.events.ConnectionEventPublisher;
import io.reactivex.netty.events.EventListener;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.events.ListenersHolder;
import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.tcp.server.events.SafeTcpServerEventListener;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventListener;
import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.subscriptions.CompositeSubscription;

public final class TcpServerEventPublisher
extends TcpServerEventListener
implements EventSource<TcpServerEventListener>,
EventPublisher {
    private static final Action1<TcpServerEventListener> NEW_CLIENT_ACTION = new Action1<TcpServerEventListener>(){

        public void call(TcpServerEventListener l) {
            l.onNewClientConnected();
        }
    };
    private static final Action3<TcpServerEventListener, Long, TimeUnit> HANDLE_START_ACTION = new Action3<TcpServerEventListener, Long, TimeUnit>(){

        public void call(TcpServerEventListener l, Long duration, TimeUnit timeUnit) {
            l.onConnectionHandlingStart(duration, timeUnit);
        }
    };
    private static final Action3<TcpServerEventListener, Long, TimeUnit> HANDLE_SUCCESS_ACTION = new Action3<TcpServerEventListener, Long, TimeUnit>(){

        public void call(TcpServerEventListener l, Long duration, TimeUnit timeUnit) {
            l.onConnectionHandlingSuccess(duration, timeUnit);
        }
    };
    private static final Action4<TcpServerEventListener, Long, TimeUnit, Throwable> HANDLE_FAILED_ACTION = new Action4<TcpServerEventListener, Long, TimeUnit, Throwable>(){

        public void call(TcpServerEventListener l, Long duration, TimeUnit timeUnit, Throwable t) {
            l.onConnectionHandlingFailed(duration, timeUnit, t);
        }
    };
    private final ListenersHolder<TcpServerEventListener> listeners;
    private final ConnectionEventPublisher<TcpServerEventListener> connDelegate;

    public TcpServerEventPublisher() {
        this.listeners = new ListenersHolder();
        this.connDelegate = new ConnectionEventPublisher();
    }

    private TcpServerEventPublisher(TcpServerEventPublisher toCopy) {
        this.listeners = toCopy.listeners.copy();
        this.connDelegate = toCopy.connDelegate.copy();
    }

    @Override
    public void onNewClientConnected() {
        this.listeners.invokeListeners(NEW_CLIENT_ACTION);
    }

    @Override
    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(HANDLE_START_ACTION, duration, timeUnit);
    }

    @Override
    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(HANDLE_SUCCESS_ACTION, duration, timeUnit);
    }

    @Override
    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(HANDLE_FAILED_ACTION, duration, timeUnit, throwable);
    }

    public void onByteRead(long bytesRead) {
        this.connDelegate.onByteRead(bytesRead);
    }

    public void onByteWritten(long bytesWritten) {
        this.connDelegate.onByteWritten(bytesWritten);
    }

    public void onFlushStart() {
        this.connDelegate.onFlushStart();
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.connDelegate.onFlushComplete(duration, timeUnit);
    }

    public void onWriteStart() {
        this.connDelegate.onWriteStart();
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.connDelegate.onWriteSuccess(duration, timeUnit);
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    public void onConnectionCloseStart() {
        this.connDelegate.onConnectionCloseStart();
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.connDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    public void onCustomEvent(Object event) {
        this.connDelegate.onCustomEvent(event);
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        this.connDelegate.onCustomEvent(event, duration, timeUnit);
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.connDelegate.onCustomEvent(event, duration, timeUnit, throwable);
    }

    public void onCustomEvent(Object event, Throwable throwable) {
        this.connDelegate.onCustomEvent(event, throwable);
    }

    public boolean publishingEnabled() {
        return this.listeners.publishingEnabled();
    }

    public Subscription subscribe(TcpServerEventListener listener) {
        if (!SafeEventListener.class.isAssignableFrom(((Object)((Object)listener)).getClass())) {
            listener = new SafeTcpServerEventListener(listener);
        }
        CompositeSubscription cs = new CompositeSubscription();
        cs.add(this.listeners.subscribe((EventListener)listener));
        cs.add(this.connDelegate.subscribe((ConnectionEventListener)listener));
        return cs;
    }

    public TcpServerEventPublisher copy() {
        return new TcpServerEventPublisher(this);
    }

    ListenersHolder<TcpServerEventListener> getListeners() {
        return this.listeners;
    }

    ConnectionEventPublisher<TcpServerEventListener> getConnDelegate() {
        return this.connDelegate;
    }
}

