/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.SubSequence;

public class RepeatedCharSequence
implements CharSequence {
    public static RepeatedCharSequence NULL = new RepeatedCharSequence(SubSequence.NULL, 0, 0);
    private final CharSequence myChars;
    private final int myStartIndex;
    private final int myEndIndex;
    private int myHash;

    private RepeatedCharSequence(CharSequence chars, int startIndex, int endIndex) {
        this.myChars = chars;
        this.myStartIndex = startIndex;
        this.myEndIndex = endIndex;
    }

    @Override
    public int length() {
        return this.myEndIndex - this.myStartIndex;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.myEndIndex - this.myStartIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.myChars.charAt((this.myStartIndex + index) % this.myChars.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start >= 0 && start <= end && end <= this.myEndIndex - this.myStartIndex) {
            return start == end ? NULL : (start == this.myStartIndex && end == this.myEndIndex ? this : new RepeatedCharSequence(this.myChars, this.myStartIndex + start, this.myStartIndex + end));
        }
        throw new IllegalArgumentException("subSequence($startIndex, $endIndex) in RepeatedCharSequence('', " + this.myStartIndex + ", " + this.myEndIndex + ")");
    }

    public RepeatedCharSequence repeat(int count) {
        int endIndex = this.myStartIndex + (this.myEndIndex - this.myStartIndex) * count;
        return this.myStartIndex >= this.myEndIndex ? NULL : (this.myEndIndex == endIndex ? this : new RepeatedCharSequence(this.myChars, this.myStartIndex, endIndex));
    }

    public int hashCode() {
        int h = this.myHash;
        if (h == 0 && this.length() > 0) {
            for (int i = 0; i < this.length(); ++i) {
                h = 31 * h + this.charAt(i);
            }
            this.myHash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this, 0, this.length());
        return sb.toString();
    }

    public static RepeatedCharSequence of(char c, int count) {
        return new RepeatedCharSequence(String.valueOf(c), 0, count);
    }

    public static RepeatedCharSequence of(CharSequence chars, int count) {
        return new RepeatedCharSequence(chars, 0, chars.length() * count);
    }

    public static RepeatedCharSequence of(CharSequence chars, int start, int end) {
        return new RepeatedCharSequence(chars, start, end);
    }
}

