/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.ConnectionCloseHandlerNotifier;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.SelectionKeyActionAttachment;
import com.sun.grizzly.util.SelectionKeyAttachment;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSelectionKeyHandler
implements SelectionKeyHandler,
ConnectionCloseHandlerNotifier {
    protected Logger logger = Controller.logger();
    private Collection<ConnectionCloseHandler> cchSet = new CopyOnWriteArraySet<ConnectionCloseHandler>();
    protected SelectorHandler selectorHandler;

    public BaseSelectionKeyHandler() {
    }

    public BaseSelectionKeyHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    @Override
    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public void process(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SelectionKeyActionAttachment) {
            ((SelectionKeyActionAttachment)attachment).process(key);
        }
    }

    @Override
    public void postProcess(SelectionKey key) {
        Object attachment = key.attachment();
        if (attachment instanceof SelectionKeyActionAttachment) {
            ((SelectionKeyActionAttachment)attachment).postProcess(key);
        }
    }

    @Override
    public void register(SelectionKey key, long currentTime) {
        throw new UnsupportedOperationException(this.getClass().getName() + " use of this API not allowed.");
    }

    @Override
    public void register(SelectionKey key, int selectionKeyOps) {
        this.doRegisterKey(key, selectionKeyOps);
    }

    protected void doRegisterKey(SelectionKey key, int selectionKeyOps) {
        if (key.isValid()) {
            key.interestOps(key.interestOps() | selectionKeyOps);
        }
    }

    @Override
    public void register(SelectableChannel channel, int selectionKeyOps) throws ClosedChannelException {
        if (!channel.isOpen()) {
            return;
        }
        Selector selector = this.selectorHandler.getSelector();
        channel.register(selector, selectionKeyOps);
    }

    @Override
    public void register(SelectableChannel channel, int selectionKeyOps, Object attachment) throws ClosedChannelException {
        if (!channel.isOpen()) {
            return;
        }
        Selector selector = this.selectorHandler.getSelector();
        channel.register(selector, selectionKeyOps, attachment);
    }

    @Override
    public void register(Iterator<SelectionKey> keyIterator, int selectionKeyOps) {
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            keyIterator.remove();
            this.doRegisterKey(key, selectionKeyOps);
        }
    }

    @Override
    public void expire(SelectionKey key, long currentTime) {
    }

    @Override
    public void expire(Iterator<SelectionKey> keyIterator) {
    }

    @Override
    public void cancel(SelectionKey key) {
        if (key != null) {
            this.doAfterKeyCancel(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAfterKeyCancel(SelectionKey key) {
        try {
            if (this.selectorHandler != null) {
                this.selectorHandler.closeChannel(key.channel());
            } else {
                this.closeChannel(key.channel());
            }
        }
        finally {
            this.notifyLocallyClose(key);
            Object attachment = key.attach(null);
            if (attachment instanceof SelectionKeyAttachment) {
                ((SelectionKeyAttachment)attachment).release(key);
            }
        }
    }

    public void notifyRemotlyClose(SelectionKey key) {
        for (ConnectionCloseHandler handler : this.cchSet) {
            handler.remotelyClosed(key);
        }
    }

    public void notifyLocallyClose(SelectionKey key) {
        for (ConnectionCloseHandler handler : this.cchSet) {
            handler.locallyClosed(key);
        }
    }

    @Override
    public void close(SelectionKey key) {
        this.doAfterKeyCancel(key);
    }

    private void closeChannel(SelectableChannel channel) {
        try {
            if (channel instanceof SocketChannel) {
                Socket socket = ((SocketChannel)channel).socket();
                try {
                    if (!socket.isInputShutdown()) {
                        socket.shutdownInput();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
                }
                try {
                    if (!socket.isOutputShutdown()) {
                        socket.shutdownOutput();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
                }
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
                }
            }
            channel.close();
        }
        catch (IOException ex) {
            Logger.getLogger(BaseSelectionKeyHandler.class.getName()).log(Level.FINE, null, ex);
        }
    }

    public void setConnectionCloseHandler(ConnectionCloseHandler cch) {
        this.cchSet.add(cch);
    }

    public void removeConnectionCloseHandler(ConnectionCloseHandler cch) {
        this.cchSet.remove(cch);
    }

    public void copyTo(Copyable copy) {
        BaseSelectionKeyHandler copyHandler = (BaseSelectionKeyHandler)copy;
        copyHandler.selectorHandler = this.selectorHandler;
        copyHandler.cchSet = this.cchSet;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

