/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.DeleteBucketRequest;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.GetObjectMetadataRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.util.List;

public class Demo {
    public static void main(String[] args) throws Exception {
        String appid = "100000";
        String secret_id = "xxxxxxxxxxxxxxxx";
        String secret_key = "yyyyyyyyyyyy";
        BasicCOSCredentials cred = new BasicCOSCredentials(appid, secret_id, secret_key);
        ClientConfig clientConfig = new ClientConfig(new Region("cn-north"));
        COSClient cosClient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket1511";
        CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
        createBucketRequest.setCannedAcl(CannedAccessControlList.PublicReadWrite);
        Bucket created_bucket = cosClient.createBucket(createBucketRequest);
        File localFile = new File("src/test/resources/len5M.txt");
        String key = "/upload_single_demo.txt";
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        File downFile = new File("src/test/resources/len5M_down.txt");
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        ObjectMetadata downObjectMeta = cosClient.getObject(getObjectRequest, downFile);
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(bucketName, key);
        ObjectMetadata statObjectMeta = cosClient.getObjectMetadata(getObjectMetadataRequest);
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, key);
        cosClient.deleteObject(deleteObjectRequest);
        TransferManager transferManager = new TransferManager(cosClient);
        localFile = new File("src/test/resources/len30M.txt");
        key = "/upload_transfer_manager_demo.txt";
        Upload upload = transferManager.upload(bucketName, key, localFile);
        upload.waitForCompletion();
        transferManager.shutdownNow();
        ObjectListing objectListing = cosClient.listObjects(bucketName);
        List<COSObjectSummary> objectListSummary = objectListing.getObjectSummaries();
        deleteObjectRequest = new DeleteObjectRequest(bucketName, key);
        cosClient.deleteObject(deleteObjectRequest);
        DeleteBucketRequest deleteBucketRequest = new DeleteBucketRequest(bucketName);
        cosClient.deleteBucket(deleteBucketRequest);
        cosClient.shutdown();
    }
}

