package com.ptteng.util.httpUtils.httpResponseUtiils;

import com.ptteng.util.ParametersUtil;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * create_at:MaZheng
 * create_by:${date} ${time}
 */
public class PostResponseUtil {
    private static final Logger log = Logger.getLogger(PostResponseUtil.class);

    /**
     * 处理创建im即时通讯账号请求响应数据
     * @param response
     * @return
     * @throws Exception
     */
    public static Map<String,String> handleResponseOfCreateImAccountRequest(CloseableHttpResponse response) throws Exception{

        log.info("response is=="+response);
        Map<String,String> result = new HashMap<>(2);

        String values = EntityUtils.toString(response.getEntity(),"utf-8");
        log.info("response values is=="+values);

        String code = null;
        String message = null;
        String accid = null;
        String token = null;
        Pattern p = Pattern.compile(".*code\\\":(\\d{3,10}).*");
        Matcher m = p.matcher(values);
        if (m.find()) {
            code = m.group(1);
            log.info("code is=="+code);
        }
        if (null!=code&&!code.equals("200")) {
            p = Pattern.compile(".*desc\\\":\\\"(.*)\\\",.*");
            m = p.matcher(values);
            if (m.find()) {
                message = m.group(1);
                log.info("message"+message);
            }
        }else if (null!=code){
           log.info("code is=="+code);
           p = Pattern.compile(".*accid\\\":\\\"(.*)\\\",.*");
           m = p.matcher(values);
           if (m.find()) {
               accid = m.group(1);
           }

           p = Pattern.compile(".*token\\\":\\\"(.*)\\\",\\\"accid.*");
           m = p.matcher(values);
           if (m.find()) {
               token = m.group(1);
           }
        }


        result.put("code",code);
        result.put("message",message);
        result.put("accid",accid);
        result.put("token",token);

        return result;
    }


    public static boolean handleResponseOfUpdateInfoRequest(CloseableHttpResponse response) throws Exception{
        log.info("response is=="+response);
        Map<String,String> result = new HashMap<>(2);

        String values = EntityUtils.toString(response.getEntity(),"utf-8");
        log.info("response values is=="+values);

        Pattern p = Pattern.compile(".*code\\\":(\\d{3,10}).*");
        Matcher m = p.matcher(values);
        String code = null;
        String message = null;

        if (m.find()) {
            code = m.group(1);
            log.info("code is=="+code);
        }

        if (null==code) {
            log.info("code is null,pls check the im chat service Of wang yi");
            throw new Exception("can not get code,pls check the im chat service Of wang yi");
        }

        if (code.equals("200")) {
            return true;
        }else {
            p = Pattern.compile(".*desc\\\":\\\"(.*)\\\",.*");
            m = p.matcher(values);
            if (m.find()) {
                message = m.group(1);
                log.info("message"+message);
            }

            return false;
        }
    }
}
