package com.ptteng.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.List;

/**
 * Created by asus on 2016/8/13.
 */
public class XmlUtil {

    private static final Log log = LogFactory.getLog("wx");

    public String xml(String xml) {
        String result = "";

        try {
            Document document = null;

            document = DocumentHelper.parseText(xml);
            log.info(document.toString());

            Element root = document.getRootElement();
            log.info("root : " + root.toString());
            List<Element> childElements = root.elements();
            log.info(childElements);
            Element return_code = root.element("return_code");
            log.info("return_code : " + return_code);
            Element result_code = root.element("result_code");
            log.info("result_code : " + result_code);
            Element prepay_id = null;
            if (return_code.getText().equals("SUCCESS") && result_code.getText().equals("SUCCESS")) {

                prepay_id = root.element("prepay_id");
                log.info("prepay_id is : " + prepay_id.getText());
                result = prepay_id.getText();
            }
        } catch (Exception e) {
            log.error(e);
        }

        return result;
    }

    public static void main(String[] a) {

        String xmlString = "<xml><return_code><![CDATA[SUCCESS]]></return_code>\n"
                + "<return_msg><![CDATA[OK]]></return_msg>\n" + "<appid><![CDATA[wx53bc3d04623a459f]]></appid>\n"
                + "<mch_id><![CDATA[1368482702]]></mch_id>\n" + "<nonce_str><![CDATA[zJWkoX682AmfQU2t]]></nonce_str>\n"
                + "<sign><![CDATA[A32C5C66FE881DD580B3DB77BEAF7CAF]]></sign>\n"
                + "<result_code><![CDATA[SUCCESS]]></result_code>\n"
                + "<prepay_id><![CDATA[wx201608131132482983a5c25c0082107177]]></prepay_id>\n"
                + "<trade_type><![CDATA[JSAPI]]></trade_type>\n" + "</xml>";

        XmlUtil xml = new XmlUtil();
        String result = xml.xml(xmlString);

        log.info(result);
    }
}
