package com.ptteng.util;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.controller.SubjectPracticeController;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;

import java.util.*;

public class ListUtil {
    public ListUtil() {
    }

    public static <T> Map<Long, T> convert2Map(List<Long> keys, List<T> values) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(values)) {
            return new HashMap();
        } else {
            Map<Long, T> map = new HashMap();
            Iterator iterator1 = keys.iterator();
            Iterator iterator2 = values.iterator();

            while (iterator1.hasNext()) {
                Long id = (Long) iterator1.next();
                if (iterator2.hasNext()) {
                    T name = (T) iterator2.next();
                    map.put(id, name);
                }
            }
            return map;
        }
    }

    /**
     * 从list中取出部分元素,组成新的list返回,可制定顺序或反序
     */
    public static <T> List<T> getElementsFromList(List<T> list, Integer index, Integer size, Integer mode) {
        if (mode == SubjectPracticeController.MODE_FORWARD) {
            return getElementsFromListInvertedSequence(list, index, size);
        } else {
            return getElementsFromListSequence(list, index, size);
        }
    }

    /**
     *  从list中顺序取出部分元素,组成新的list返回
     */
    public static <T> List<T> getElementsFromListSequence(List<T> list, Integer begin, Integer size) {
        List<T> resultList = new ArrayList<>();

        for (int i = begin; i < begin + size; i++) {
            if (i < list.size()) {
                resultList.add(list.get(i));
            }
        }
        return resultList;
    }

    /**
     *  从list中逆序取出部分元素,组成新的list返回
     */
    public static <T> List<T> getElementsFromListInvertedSequence(List<T> list, Integer last, Integer size) {
        List<T> resultList = new ArrayList<>();

        for (int i = last; i > last - size; i--) {
            if (i >= 0) {
                resultList.add(list.get(i));
            }
        }

        return resultList;
    }

    /**
     *  从原list中去除子list
     * */
    public static <T> List<T> eliminateSublist(List<T> sublist, List<T> originalList) {
        List<T> resultList = originalList;

        for (int i = 0; i < sublist.size(); i++) {
            if (resultList.contains(sublist.get(i))) {
                resultList.remove(sublist.get(i));
            }
        }
        return resultList;
    }

    /**
     *  获取某对象List中的某个字段的最大值
     *
     * */

    public static Integer getMaxValueFromObjectListByField(List objectList, Class clz, String field)
            throws NoSuchFieldException, IllegalAccessException {
        List<Integer> fieldList = MyListUtil.getFieldValueListFromModelList(objectList, false,
                clz.getDeclaredField(field));

        Integer maxValue = 0;
        for (int i = 0; i < fieldList.size(); i++) {
            if (maxValue < fieldList.get(i)) {
                maxValue = fieldList.get(i);
            }
        }

        return maxValue;
    }
}
