package com.ptteng.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.util.notice.NoticeUtil;
import com.ptteng.util.Calculation;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.TimeUtil;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.service.ImAccountService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.MyMathUtil;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.apache.commons.collections.CollectionUtils;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigDecimal;

/**
 * Created by wutao on 2018/1/25.
 */
@Controller
public class practiceCarController {
    private static final Log log = LogFactory.getLog(practiceCarController.class);

    @Autowired
    private CoachService coachService;
    @Autowired
    private StudentsService studentsService;
    @Autowired
    private CoachAppointTimeService coachAppointTimeService;
    @Autowired
    private AdvanceTimeService advanceTimeService;
    @Autowired
    private ConstantService constantService;
    @Autowired
    private CoachClassRelationService coachClassRelationService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private AppointOrderService appointOrderService;
    @Autowired
    private CoachFreeService coachFreeService;
    @Autowired
    private ImAccountService imAccountService;
    @Autowired
    private NoticeUtil coachAndroidPushServiceImpl;
    @Autowired
    private NoticeUtil coachIosPushServiceImpl;

    /**
     * 搜索教练
     * @param request
     * @param response
     * @param model
     * @param mobile
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/search", method = RequestMethod.GET)
    public String getCoachList(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mobile,
            Integer page, Integer size) throws Exception {
        log.info("mobile is " + mobile + " page is " + page + " size is " + size);
        if (DataUtils.isNullOrEmpty(mobile)) {
            log.info("mobile is null");
            model.addAttribute("code", -5022);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Students students = (Students) request.getAttribute("user");
        log.info("students is "+students);
        Integer certification = students.getCertification();
        if (certification.equals(Coach.CERTIFICATION_ON)) {
            log.info("students is Certification_ON");
            model.addAttribute("code", -22000);
            return "/common/failure";
        }
        try {
            Map<String, Object> map = DynamicUtil.getCoachList(mobile, null, students.getCityId(),
                    Coach.CERTIFICATION_OFF);
            log.info("map is "+map);
            List<Long> ids = coachService.getIdsByDynamicCondition(Coach.class, map, start, size);
            log.info("ids is "+ids);
            List<Coach> coachList=new ArrayList<>();
            if(CollectionUtils.isNotEmpty(ids)){
                coachList = coachService.getObjectsByIds(ids);
            }
            log.info("coachList.size is "+coachList.size());
            Integer total = coachService.getIdsByDynamicCondition(Coach.class, map, 0, Integer.MAX_VALUE).size();

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("coachList", coachList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachListJson";
    }

    /**
     * 班型id搜索教练
     * @param request
     * @param response
     * @param model
     * @param classId
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/class/search", method = RequestMethod.GET)
    public String getCoachList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long schoolId , Long classId,
            Integer page, Integer size) throws Exception {
        log.info("classId is " + classId);
        if (DataUtils.isNullOrEmpty(classId)) {
            log.info("mobile is null");
            model.addAttribute("code", -22006);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }


        try {
            Students students = (Students) request.getAttribute("user");
            if(DataUtils.isNullOrEmpty(students.getSchoolId())){
                log.info("students.getSchoolId is null");
                model.addAttribute("code", -22033);
                return "/common/failure";
            }

            List<Long> ids = coachClassRelationService.getCoachClassRelationIdsByClassId(classId, 0, Integer.MAX_VALUE);
            log.info("ids is "+ids);

            List<CoachClassRelation> coachClassRelationList=new ArrayList<>();
            if(CollectionUtils.isNotEmpty(ids)){
                coachClassRelationList = coachClassRelationService.getObjectsByIds(ids);
            }
            List<Coach> coachList = new ArrayList<>();
            List<Long> coachIds= MyListUtil.getDistinctList(CoachClassRelation.class.getDeclaredField("coachId"),coachClassRelationList);
            coachList=coachService.getObjectsByIds(coachIds);

            List<Coach> newCoachList = new ArrayList<>();
            List<Coach> endCoachList = new ArrayList<>();
            for (Coach coach : coachList){
                if(coach.getSchoolId().equals(students.getSchoolId())&&coach.getStatus()==Coach.STATUS_ON){
                    newCoachList.add(coach);
                }else {
                    log.info("coach school id is : " + coach.getSchoolId() + " coach id is " + coach.getId());
                    log.info("coach is not belong shhoolId :" + schoolId);
                }
            }
            Integer total = newCoachList.size();
            log.info("start is "+start+"start+size is "+(start+size));
            for(int i=start;i<(start+size);i++){
                if(i<=(newCoachList.size()-1)){
                    endCoachList.add(newCoachList.get(i));
                }
            }
            log.info("endCoachList is "+endCoachList.size());

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("coachList", endCoachList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachListJson";
    }

    /**
     *关注教练
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/attention/{id}", method = RequestMethod.POST)
    public String attentionCoach(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer subject) throws Exception {
        log.info("id is " + id + " type is " + subject);
        Students students = (Students) request.getAttribute("user");
        log.info("students is " + students);


        try {
            Coach coach = coachService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(coach)){
                log.info("coach  is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
            Integer certification = coach.getCertification();
            if (certification.equals(Coach.CERTIFICATION_ON)) {
                log.info("coach  is Certification_ON");
                model.addAttribute("code", -22003);
                return "/common/failure";
            }
            if (subject.equals(AdvanceTime.TWO_SUBJECT)
                    && DataUtils.isNotNullOrEmpty(students.getSectionTwoCoachId())) {
                students.setSectionTwoCoach(null);
                students.setSectionTwoCoachId(null);
            } else if (subject.equals(AdvanceTime.TWO_SUBJECT)
                    && DataUtils.isNullOrEmpty(students.getSectionTwoCoachId())) {
                if (DataUtils.isNullOrEmpty(coach.getName())) {
                    students.setSectionTwoCoach(coach.getNick());
                } else {
                    students.setSectionTwoCoach(coach.getName());
                }
                students.setSectionTwoCoachId(coach.getId().toString());
            }
            if (subject.equals(AdvanceTime.THREE_SUBJECT)
                    && DataUtils.isNotNullOrEmpty(students.getSectionThreeCoachId())) {
                students.setSectionThreeCoach(null);
                students.setSectionThreeCoachId(null);
            } else if (subject.equals(AdvanceTime.THREE_SUBJECT)
                    && DataUtils.isNullOrEmpty(students.getSectionThreeCoachId())) {
                if (DataUtils.isNullOrEmpty(coach.getName())) {
                    students.setSectionThreeCoach(coach.getNick());
                } else {
                    students.setSectionThreeCoach(coach.getName());
                }
                students.setSectionThreeCoachId(coach.getId().toString());
            }

            studentsService.update(students);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * 搜索教练约车时段
     * @param request
     * @param response
     * @param model
     * @param subject
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/arrange/{id}", method = RequestMethod.GET)
    public String getCoachArrange(HttpServletRequest request, HttpServletResponse response, ModelMap model, int subject,
            int type, Long time,@PathVariable Long id) throws Exception {
        log.info("type is " + type + " subject is " + subject);
        if (DataUtils.isNullOrEmpty(subject)) {
            log.info("subject is null");
            model.addAttribute("code", -22005);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("type is null");
            model.addAttribute("code", -22004);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(time)) {
            log.info("time is null");
            model.addAttribute("code", -22011);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(id)) {
            log.info("id is null");
            model.addAttribute("code", -22007);
            return "/common/failure";
        }

        try {
            Long coachId=id;
            log.info("coachId is " + coachId);
            Coach coach = coachService.getObjectById(coachId);
            if (DataUtils.isNullOrEmpty(coach)) {
                log.info("coach is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
            if (coach.getStatus()==Coach.STATUS_OFF){
                log.info("coach is freeze");
                model.addAttribute("code", -22036);
                return "/common/failure";
            }

            log.info("coach is "+coach);
            Integer subjectId = subject;
            List<Long> coachAppointTimeIds = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndTypeAndCoachId(
                    CoachAppointTime.COACHADVANCETIME_STATUS_NO, type, coachId, 0, Integer.MAX_VALUE);
            log.info("coachAppointTimeIds is "+coachAppointTimeIds);
            List<AdvanceTime> timeList = new ArrayList<>();
            List<AdvanceTime> advanceTimeList = new ArrayList<>();
            CoachAppointTime coachAppointTime = new CoachAppointTime();
            if (CollectionUtils.isEmpty(coachAppointTimeIds)) {
                List<Long> ids = coachAppointTimeService.getCoachAppointTimeIdsByStatusAndCityIdAndType(
                        CoachAppointTime.COACHADVANCETIME_STATUS_YES, coach.getCityId(), type, 0, Integer.MAX_VALUE);
                log.info("ids is "+ids);
                List<CoachAppointTime> coachAppointTimeList=new ArrayList<>();
                if(CollectionUtils.isNotEmpty(ids)){
                    coachAppointTimeList = coachAppointTimeService.getObjectsByIds(ids);
                }
                if (CollectionUtils.isNotEmpty(ids)) {
                    coachAppointTime = coachAppointTimeList.get(0);
                    log.info("coachAppointTime is "+coachAppointTime);
                    Map<String, Object> map = DynamicUtil.getAppointTimeList(coachAppointTime.getId(),
                            AdvanceTime.ADVANCE_TIME_STATUS_ON);
                    log.info("map is "+map);
                    List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
                            Integer.MAX_VALUE);
                    log.info("advanceTimeIds is "+advanceTimeIds);
                    if(CollectionUtils.isNotEmpty(advanceTimeIds)){
                        advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
                    }
                }
            } else {
                List<CoachAppointTime> coachAppointTimeList = coachAppointTimeService
                        .getObjectsByIds(coachAppointTimeIds);
                coachAppointTime = coachAppointTimeList.get(0);
                log.info("coachAppointTime is "+coachAppointTime);
                Map<String, Object> map = DynamicUtil.getAppointTimeList(coachAppointTime.getId(),
                        AdvanceTime.ADVANCE_TIME_STATUS_ON);
                log.info("map is "+map);
                List<Long> advanceTimeIds = advanceTimeService.getIdsByDynamicCondition(AdvanceTime.class, map, 0,
                        Integer.MAX_VALUE);
                log.info("advanceTimeIds is "+advanceTimeIds);
                if(CollectionUtils.isNotEmpty(advanceTimeIds)){
                    advanceTimeList = advanceTimeService.getObjectsByIds(advanceTimeIds);
                }
            }

            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);

            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, time, null,
                    null, coachId, null, subjectId, null, null, null, null);
            log.info("map is "+map);
            List<Long> appointOrderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            List<AppointOrder> appointOrderList=new ArrayList<>();
            log.info("appointOrderIds is "+appointOrderIds);
            if(CollectionUtils.isNotEmpty(appointOrderIds)){
                appointOrderList=appointOrderService.getObjectsByIds(appointOrderIds);
            }
            for (int i = 0; i < advanceTimeList.size(); i++) {
                AdvanceTime advanceTime = advanceTimeList.get(i);
                log.info("advanceTime is "+advanceTime);
                int num=0;
                for(int a =0;a<appointOrderList.size();a++){
                    if(advanceTime.getStartTime().equals(appointOrderList.get(a).getTimeStart())&&advanceTime.getEndTime().equals(appointOrderList.get(a).getTimeEnd())){
                        num++;
                    }
                }
                log.info("length is   " + appointOrderIds.size());
                advanceTime.setArrangeNum(Long.valueOf(num));
                if (subjectId.equals(advanceTime.getSubject())) {
                    timeList.add(advanceTime);
                    log.info("advanceTime =========" + advanceTime);
                }
            }
            String advanceTime = null;
            Integer appointFrequency = null;
            Integer rest = null;
            if (subjectId.equals(AdvanceTime.TWO_SUBJECT)) {
                advanceTime = coachAppointTime.getTwoAdvanceTime();
                appointFrequency = coachAppointTime.getTwoAppointFrequency();
            }
            if (subjectId.equals(AdvanceTime.THREE_SUBJECT)) {
                advanceTime = coachAppointTime.getThreeAdvanceTime();
                appointFrequency = coachAppointTime.getThreeAppointFrequency();
            }
            Map<String, Object> coachFreeMap = DynamicUtil.getCoachFreeList(coachId, time);
            log.info("coachFreeMap is "+coachFreeMap);
            List<Long> ids = coachFreeService.getIdsByDynamicCondition(CoachFree.class, coachFreeMap, 0, Integer.MAX_VALUE);
            log.info("ids is "+ids);
            if (CollectionUtils.isEmpty(ids)) {
                rest = coachAppointTime.getTwoRest();
            } else {
                List<CoachFree> coachFreeList = coachFreeService.getObjectsByIds(ids);
                CoachFree coachFree = coachFreeList.get(0);
                rest = coachFree.getStatus();
            }

            log.info("timeList is " + timeList);
            log.info("advanceTime is " + advanceTime);
            log.info("appointFrequency is " + appointFrequency);
            log.info("rest is " + rest);

            model.addAttribute("code", 0);
            model.addAttribute("timeList", timeList);
            model.addAttribute("advanceTime", advanceTime);
            model.addAttribute("appointFrequency", appointFrequency);
            model.addAttribute("rest", rest);
            model.addAttribute("coachAppointTime", coachAppointTime);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachArrangeDetailJson";
    }

    /**
     * 获取教练详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/{id}", method = RequestMethod.GET)
    public String getCoach(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {
        log.info(" id is " + id);
        try {
            Coach coach = coachService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(coach)) {
                log.info("coach is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
//            if (coach.getStatus()==Coach.STATUS_OFF){
//                log.info("coach is freeze");
//                model.addAttribute("code", -22036);
//                return "/common/failure";
//            }

            //获取教练的Im即时通讯账号密码
            List<Long> imAccountIds = imAccountService.getIdByBelongIdAndBelongType(ImChatUtil.COACH,id);
            log.info("imAccountIds is=="+imAccountIds);

            ImAccount imAccount = null;
            if (null!=imAccountIds&&1==imAccountIds.size()) {
                imAccount = imAccountService.getObjectById(imAccountIds.get(0));
            }else {
                log.info("The imAccountIds is null or size is not 1");
            }


            model.addAttribute("code", 0);
            model.addAttribute("coach", coach);
            model.addAttribute("imAccount",imAccount);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/coachDetailJson";
    }

    /**
     * 获取常量
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/constant", method = RequestMethod.GET)
    public String getConstant(HttpServletRequest request, HttpServletResponse response, ModelMap model)
            throws Exception {

        Students students = (Students) request.getAttribute("user");
        log.info("students  is " + students);
        try {
            Constant constant = new Constant();
            List<Long> ids = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                    Constant.CONSTANT_CITY_ID_TYPE, students.getCityId(), 0, Integer.MAX_VALUE);
            log.info("ids is "+ids);
            if (CollectionUtils.isEmpty(ids)) {
                constant.setEvaluate(Constant.EVALUATE_NO);
            } else {
                List<Constant> list = constantService.getObjectsByIds(ids);
                constant = list.get(0);
                log.info("constant is "+constant);
            }
            School school = new School();
            if (DataUtils.isNullOrEmpty(students.getSchoolId())) {
                constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY));
                constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START));
                constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END));
            } else {
                List<Long> constantIds = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                        Constant.CONSTANT_SCHOOL_ID_TYPE, students.getSchoolId(), 0, Integer.MAX_VALUE);
                log.info("constantIds is "+constantIds);

                if (CollectionUtils.isEmpty(constantIds)) {
                    constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY));
                    constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START));
                    constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END));
                } else {
                    List<Constant> constantList = constantService.getObjectsByIds(constantIds);
                    Constant constantData = constantList.get(0);
                    log.info("constantData is "+constantData);
                    if(DataUtils.isNotNullOrEmpty(constantData.getDay())){
                        constant.setDay(constantData.getDay());
                    }else {
                        constant.setDay(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_DAY));
                    }
                    if(DataUtils.isNotNullOrEmpty(constantData.getTimeStart())){
                        constant.setTimeStart(constantData.getTimeStart());
                    }else {
                        constant.setTimeStart(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_START));
                    }
                    if(DataUtils.isNotNullOrEmpty(constantData.getTimeEnd())){
                        constant.setTimeEnd(constantData.getTimeEnd());
                    }else {
                        constant.setTimeEnd(Long.valueOf(Constant.NO_SCHOOL_ID_APPOINT_END));
                    }
                }
                school = schoolService.getObjectById(students.getSchoolId());
                log.info("school is " + school);
            }
            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null,
                    students.getId(), null, null, null, null, null);
            log.info("map is "+map);
            List<Long> orderMaxIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            log.info("orderMaxIds is "+orderMaxIds);

            model.addAttribute("code", 0);
            model.addAttribute("constant", constant);
            model.addAttribute("school", school);
            model.addAttribute("length", orderMaxIds.size());

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/constantDetailJson";
    }

    /**
     * 约车
     * @param request
     * @param response
     * @param model
     * @param arrangeId
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/arrange", method = RequestMethod.POST)
    public String arrange(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long arrangeId,
            Long time,Long coachId) throws Exception {
        log.info("arrangeId is " + arrangeId + " time is " + time);
        //判断参数是否为空
        if (DataUtils.isNullOrEmpty(arrangeId)) {
            log.info("arrangeId is null");
            model.addAttribute("code", -22008);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(time)) {
            log.info("time is null");
            model.addAttribute("code", -22010);
            return "/common/failure";
        }


        try {
            AdvanceTime advanceTime = advanceTimeService.getObjectById(arrangeId);
            if(DataUtils.isNullOrEmpty(advanceTime)){
                log.info("advanceTime is null");
                model.addAttribute("code", -22027);
                return "/common/failure";
            }
            log.info("advanceTime is "+advanceTime);
            CoachAppointTime coachAppointTime = coachAppointTimeService.getObjectById(advanceTime.getCoachTimeId());
            if(DataUtils.isNullOrEmpty(coachAppointTime)){
                log.info("coachAppointTime is null");
                model.addAttribute("code", -22028);
                return "/common/failure";
            }
            log.info("coachAppointTime is "+coachAppointTime);
            Long todayTime = TimeUtil.getTimesTodayMorningInMillis();
            Long nowTime = System.currentTimeMillis();
            log.info("nowTime is " + nowTime);
            log.info("todayTime is " + todayTime);
            Students students = (Students) request.getAttribute("user");
            Long practiceTime = time + advanceTime.getStartTime();
            log.info("practiceTime is "+practiceTime);
            //判断教练是否休息
            Map<String, Object> coachFreeMap = DynamicUtil.getCoachFreeList(coachId, time);
            log.info("coachFreeMap is "+coachFreeMap);
            List<Long> coachFreeIds = coachFreeService.getIdsByDynamicCondition(CoachFree.class, coachFreeMap, 0,
                    Integer.MAX_VALUE);
            log.info("coachFreeIds is "+coachFreeIds);
            if (CollectionUtils.isEmpty(coachFreeIds)) {
                if (Integer.valueOf(coachAppointTime.getTwoRest()).equals(CoachAppointTime.COACH_REST_YES)) {
                    log.info("coach is rest");
                    model.addAttribute("code", -22024);
                    return "/common/failure";
                }
            } else {
                List<CoachFree> coachFreeList = coachFreeService.getObjectsByIds(coachFreeIds);
                CoachFree coachFree = coachFreeList.get(0);
                log.info("coachFree is "+coachFree);
                if (Integer.valueOf(coachFree.getStatus()).equals(CoachFree.STATUS_ON)) {
                    log.info("coach is rest");
                    model.addAttribute("code", -22024);
                    return "/common/failure";
                }
            }

            if (Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                //判断是否是练车前x小时
                log.info("coachAppointTime.getTwoAdvanceTime() is "+coachAppointTime.getTwoAdvanceTime());
                BigDecimal getTwoAdvanceTime =new BigDecimal(coachAppointTime.getTwoAdvanceTime()).setScale(2, BigDecimal.ROUND_HALF_UP);
                log.info("getTwoAdvanceTime is "+getTwoAdvanceTime);
                BigDecimal oneHourTime =new BigDecimal(Constant.ONE_HOUR).setScale(2, BigDecimal.ROUND_HALF_UP);
                log.info("oneHourTime is "+oneHourTime);
                double twoAdvanceTime=Calculation.mul(getTwoAdvanceTime.doubleValue(),oneHourTime.doubleValue());
                log.info("twoAdvanceTime is "+twoAdvanceTime);

                Long timeDifference = nowTime - (practiceTime - (long)twoAdvanceTime);
                log.info("timeDifference is"+timeDifference);
                if (timeDifference > 0) {
                    log.info("advanceTime is out");
                    model.addAttribute("code", -22025);
                    return "/common/failure";
                }
            }
            //判断是否强制评价
            List<Long> constantIds = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                    Constant.CONSTANT_CITY_ID_TYPE, students.getCityId(), 0, Integer.MAX_VALUE);
            log.info("constantIds is "+constantIds);
            if (CollectionUtils.isNotEmpty(constantIds)) {
                List<Constant> constantList = constantService.getObjectsByIds(constantIds);
                Constant constant = constantList.get(0);
                log.info("constant is "+constant);
                Integer evaluate = constant.getEvaluate();
                List<String> typeList = new ArrayList<>();
                typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
                if (evaluate.equals(Constant.EVALUATE_YES)) {
                    Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, coachId,
                            students.getId(), null, null, null, null, null);
                    log.info("map is " + map);
                    List<Long> evaluateIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                            Integer.MAX_VALUE);
                    log.info("evaluateIds is "+evaluateIds);
                    if (CollectionUtils.isNotEmpty(evaluateIds)) {
                        log.info(" evaluate order is no null");
                        model.addAttribute("code", -22012);
                        return "/common/failure";
                    }
                }
            }

            log.info("nowTime-todayTime ====" + (nowTime - todayTime));
            //判断是否在可预约时间内
            if (DataUtils.isNullOrEmpty(students.getSchoolId())) {
                if ((nowTime - todayTime) < Constant.NO_SCHOOL_ID_APPOINT_START
                        || (nowTime - todayTime) > Constant.NO_SCHOOL_ID_APPOINT_END) {
                    log.info(" time  is out");
                    model.addAttribute("code", -22015);
                    return "/common/failure";
                }
            } else {

                List<Long> constantTimeIds = constantService.getConstantIdsByTypeAndTargetIdOrderByCreateBy(
                        Constant.CONSTANT_SCHOOL_ID_TYPE, students.getSchoolId(), 0, Integer.MAX_VALUE);
                log.info("constantTimeIds is "+constantTimeIds);
                if(CollectionUtils.isEmpty(constantTimeIds)){
                    if ((nowTime - todayTime) < Constant.NO_SCHOOL_ID_APPOINT_START || (nowTime - todayTime) > Constant.NO_SCHOOL_ID_APPOINT_END) {
                        log.info(" time  is out");
                        model.addAttribute("code", -22015);
                        return "/common/failure";
                    }
                    if ((time - todayTime) > (Constant.NO_SCHOOL_ID_APPOINT_DAY *Constant.ONE_DAY)) {
                        log.info(" time  is out");
                        model.addAttribute("code", -22015);
                        return "/common/failure";
                    }
                }else {
                    List<Constant> constantList=constantService.getObjectsByIds(constantTimeIds);
                    Constant constant = constantList.get(0);
                    log.info("constant is "+constant);
                    if(DataUtils.isNotNullOrEmpty(constant.getTimeEnd())&&DataUtils.isNotNullOrEmpty(constant.getTimeEnd())){
                        if ((nowTime - todayTime) < constant.getTimeStart() || (nowTime - todayTime) > constant.getTimeEnd()) {
                            log.info(" time  is out");
                            model.addAttribute("code", -22015);
                            return "/common/failure";
                        }
                    }else {
                        if ((nowTime - todayTime) < Constant.NO_SCHOOL_ID_APPOINT_START
                                || (nowTime - todayTime) > Constant.NO_SCHOOL_ID_APPOINT_END) {
                            log.info(" time  is out");
                            model.addAttribute("code", -22015);
                            return "/common/failure";
                        }
                    }
                    if(DataUtils.isNotNullOrEmpty(constant.getDay())){
                        if ((time - todayTime) > (constant.getDay() * Constant.ONE_DAY)) {
                            log.info(" time  is out");
                            model.addAttribute("code", -22015);
                            return "/common/failure";
                        }
                    }else {
                        if ((time - todayTime) > (Constant.NO_SCHOOL_ID_APPOINT_DAY * Constant.ONE_DAY)) {
                            log.info(" time  is out");
                            model.addAttribute("code", -22015);
                            return "/common/failure";
                        }
                    }
                }
            }

            //判断区域时间是否存在
            log.info("advanceTime is " + advanceTime);
            if (DataUtils.isNullOrEmpty(advanceTime)) {
                log.info("advanceTime is null");
                model.addAttribute("code", -22009);
                return "/common/failure";
            }
            //判断是否达到可预约人数
            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
            typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
//            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, time, advanceTime.getStartTime(),
//                    advanceTime.getEndTime(), coachId, null, advanceTime.getSubject(), null, null,
//                    null, null);
//            log.info("map is "+map);
//            List<Long> orderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
//                    Integer.MAX_VALUE);
//            log.info("orderIds is "+orderIds);
//            Integer orderIdsSize = orderIds.size();



            //判断是否已预约
            Map<String, Object> userMap = DynamicUtil.getAppointOrderList(typeList, time, advanceTime.getStartTime(),
                    advanceTime.getEndTime(), coachId, students.getId(), advanceTime.getSubject(),
                    null, null, null, null);
            log.info("userMap is "+userMap);
            List<Long> userOrderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, userMap, 0,
                    Integer.MAX_VALUE);
            log.info("userOrderIds is "+userOrderIds);
            if (CollectionUtils.isNotEmpty(userOrderIds)) {
                log.info("order is already exist");
                model.addAttribute("code", -22014);
                return "/common/failure";
            }
            //判断是否超过可约次数
            List<String> soldTypeList = new ArrayList<>();
            soldTypeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
            soldTypeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
            soldTypeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
            soldTypeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
            soldTypeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
            soldTypeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);

            Map<String,Object> coachStudentArrangeMap=DynamicUtil.getAppointOrderList(soldTypeList, time, null,
                    null, coachId, students.getId(), advanceTime.getSubject(),
                    null, null, null, null);
            log.info("coachArrangeMap is "+coachStudentArrangeMap);
            Map<String,Object> studentArrangeMap=DynamicUtil.getAppointOrderList(soldTypeList, null, null,
                    null, null, students.getId(), advanceTime.getSubject(),
                    todayTime, todayTime+Constant.ONE_DAY, null, null);
            log.info("studentArrangeMap is "+studentArrangeMap);
            List<Long> coachStudentArrangeIds=appointOrderService.getIdsByDynamicCondition(AppointOrder.class,coachStudentArrangeMap,0,Integer.MAX_VALUE);
            log.info("coachStudentArrangeIds is "+coachStudentArrangeIds);
            List<Long> studentArrangeIds=appointOrderService.getIdsByDynamicCondition(AppointOrder.class,studentArrangeMap,0,Integer.MAX_VALUE);
            log.info("studentArrangeIds is "+studentArrangeIds);
            //判断教练的约车次数
            if(Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.TWO_SUBJECT)){
                if (coachStudentArrangeIds.size()>=coachAppointTime.getTwoAppointFrequency()) {
                    log.info("appoint is already exist");
                    model.addAttribute("code", -22029);
                    return "/common/failure";
                }
            }else {
                if (coachStudentArrangeIds.size()>=coachAppointTime.getThreeAppointFrequency()) {
                    log.info("appoint is already exist");
                    model.addAttribute("code", -22029);
                    return "/common/failure";
                }
            }
            //判断学员的约车次数
            if(DataUtils.isNotNullOrEmpty(students.getResidualNum())){
                if (studentArrangeIds.size()>=students.getResidualNum()) {
                    log.info("appoint is already exist");
                    model.addAttribute("code", -22030);
                    return "/common/failure";
                }
            }else {
                if (studentArrangeIds.size()>=1) {
                    log.info("appoint is already exist");
                    model.addAttribute("code", -22030);
                    return "/common/failure";
                }
            }


            //判断区域时间是否重叠
            Map<String,Object> studentAllArrangeMap=DynamicUtil.getAppointOrderList(soldTypeList, time, null,
                    null, null, students.getId(), null,
                    null, null, null, null);
            List<Long> studentAllArrangeIds=appointOrderService.getIdsByDynamicCondition(AppointOrder.class,studentAllArrangeMap,0,Integer.MAX_VALUE);
            List<AppointOrder> studentAllArrangeList=appointOrderService.getObjectsByIds(studentAllArrangeIds);
            for(int i=0;i<studentAllArrangeList.size();i++){
                AppointOrder appointOrder=studentAllArrangeList.get(i);
                if((advanceTime.getStartTime()>appointOrder.getTimeStart()&&advanceTime.getStartTime()<appointOrder.getTimeEnd())||
                        (advanceTime.getEndTime()>appointOrder.getTimeStart()&&advanceTime.getEndTime()<appointOrder.getTimeEnd())){
                    log.info("time is overlay");
                    model.addAttribute("code", -22031);
                    return "/common/failure";
                }
            }

            //验证导入学员无法约车
            if((Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON))){
                if(DataUtils.isNullOrEmpty(students.getClassId())){
                    log.info("getClassId is null");
                    model.addAttribute("code", -22034);
                    return "/common/failure";
                }
            }

            //验证学时是否超出
            BigDecimal aaa = new BigDecimal((advanceTime.getEndTime() - advanceTime.getStartTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal bbb = new BigDecimal((Constant.ONE_HOUR * advanceTime.getNum())).setScale(2, BigDecimal.ROUND_HALF_UP);

            double studyTime = Calculation.div(aaa.doubleValue(), bbb.doubleValue());

            log.info("studyTime is "+studyTime);

            if(DataUtils.isNotNullOrEmpty(students.getClassId())) {
                if (Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                    BigDecimal sectionTwoNumerator;
                    if(DataUtils.isNotNullOrEmpty(students.getSectionTwoNumerator())){
                        sectionTwoNumerator = new BigDecimal(students.getSectionTwoNumerator()).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionTwoNumerator is "+sectionTwoNumerator);
                    }else {
                        sectionTwoNumerator = new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionTwoNumerator is "+sectionTwoNumerator);
                    }
                    BigDecimal sectionTwoDenominator;
                    if(DataUtils.isNotNullOrEmpty(students.getSectionTwoDenominator())){
                        sectionTwoDenominator = new BigDecimal(students.getSectionTwoDenominator()).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionTwoDenominator is "+sectionTwoDenominator);
                    }else {
                        sectionTwoDenominator = new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionTwoDenominator is "+sectionTwoDenominator);
                    }
                    double newStudyTime = Calculation.add(studyTime, sectionTwoNumerator.doubleValue());
                    double differenceTime = Calculation.sub(newStudyTime, sectionTwoDenominator.doubleValue());
                    if (differenceTime > 0) {
                        log.info("studyTime is already exist");
                        model.addAttribute("code", -22023);
                        return "/common/failure";
                    }
                    students.setSectionTwoNumerator(Double.toString(newStudyTime));
                }
                if (Integer.valueOf(advanceTime.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                    log.info("getSectionThreeNumerator is " + students);
                    BigDecimal sectionThreeNumerator;
                    if(DataUtils.isNotNullOrEmpty(students.getSectionThreeNumerator())){
                        sectionThreeNumerator = new BigDecimal(students.getSectionThreeNumerator()).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionThreeNumerator is "+sectionThreeNumerator);
                    }else {
                        sectionThreeNumerator = new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionThreeNumerator is "+sectionThreeNumerator);
                    }
                    BigDecimal sectionThreeDenominator;
                    if(DataUtils.isNotNullOrEmpty(students.getSectionThreeDenominator())){
                        sectionThreeDenominator = new BigDecimal(students.getSectionThreeDenominator()).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionThreeDenominator is "+sectionThreeDenominator);
                    }else {
                        sectionThreeDenominator = new BigDecimal(0).setScale(2, BigDecimal.ROUND_HALF_UP);
                        log.info("sectionThreeDenominator is "+sectionThreeDenominator);
                    }
                    double newStudyTime = Calculation.add(studyTime, sectionThreeNumerator.doubleValue());
                    double differenceTime = Calculation.sub(newStudyTime, sectionThreeDenominator.doubleValue());
                    if (differenceTime > 0) {
                        log.info("studyTime is already exist");
                        model.addAttribute("code", -22023);
                        return "/common/failure";
                    }
                    students.setSectionThreeNumerator(Double.toString(newStudyTime));
                }
            }
            Coach coach=coachService.getObjectById(coachId);
            if(DataUtils.isNullOrEmpty(coach)){
                log.info("coach is null");
                model.addAttribute("code", -22001);
                return "/common/failure";
            }
            log.info("coach is "+coach);



            AppointOrder appointOrder = new AppointOrder();
            appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED);
            appointOrder.setTime(time);
            appointOrder.setCoach(coachId);
            if(DataUtils.isNullOrEmpty(coach.getName())){
                appointOrder.setCoachName(coach.getNick());
            }else {
                appointOrder.setCoachName(coach.getName());
            }
            appointOrder.setCoachMobile(coach.getMobile());
            appointOrder.setStudent(students.getId());
            appointOrder.setStudentName(students.getName());
            appointOrder.setStudentMobile(students.getMobile());
            appointOrder.setTimeStart(advanceTime.getStartTime());
            appointOrder.setTimeEnd(advanceTime.getEndTime());
            appointOrder.setSubject(advanceTime.getSubject());
            appointOrder.setAdvanceId(arrangeId);
            appointOrder.setStudyTime(Double.toString(studyTime));
            appointOrder.setCityId(students.getCityId());
            appointOrder.setSchoolId(students.getSchoolId());
            log.info("appointOrder is " + appointOrder);

            //同步锁查订单、插入订单
            if(!getOrderCount(time,advanceTime,coachId,typeList,appointOrder,model)){
                log.info("params error");
                return "/common/failure";
            }
//            appointOrderService.insert(appointOrder);
            studentsService.update(students);
            String message = "您的学员已于" + dateTime() +
                    "发起预约练车订单。请及时处理。";
            otherAppUser(response, coach.getPlatform(), coach.getDeviceToken(), null, message);
            log.info("push param platform , deviceToken is " + coach.getPlatform()+" ," +coach.getDeviceToken());
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(),t);
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    //约单同步锁
    private synchronized boolean getOrderCount(Long time,AdvanceTime advanceTime,Long coachId,List<String> typeList,AppointOrder appointOrder,ModelMap model) throws Exception{
           Integer orderIdsSize = 0;
           Long startTime = System.currentTimeMillis();
           try {
               Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, time, advanceTime.getStartTime(),
                       advanceTime.getEndTime(), coachId, null, advanceTime.getSubject(), null, null,
                       null, null);
               log.info("map is "+map);
               List<Long> orderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                       Integer.MAX_VALUE);
               log.info("orderIds is "+orderIds);

               orderIdsSize = orderIds.size();
               if ((orderIdsSize >= advanceTime.getNum())) {
                   log.info("num is enough");
                   model.addAttribute("code", -22013);
                    return false;
               }
               appointOrderService.insert(appointOrder);
               log.info("getOrderCount consumption time = "+(System.currentTimeMillis()-startTime));
               return true;
           } catch (Throwable t) {
               t.printStackTrace();
               log.error(t.getMessage(), t);
               model.addAttribute("code", -10000);
               return false;
           }
    }








    /**
     *我的订单
     * @param request
     * @param response
     * @param model
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/car/order/list", method = RequestMethod.GET)
    public String getCarOrderList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer type, Integer page, Integer size) throws Exception {

        log.info("type is " + type);
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("type is null");
            model.addAttribute("code", -22016);
            return "/common/failure";
        }
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            List<String> typeList = new ArrayList<>();

            switch (type){
                case AppointOrder.ORDER_TYPE_PENDING:
                    typeList.add(AppointOrder.STUDENT_PENDING_COACH_CANCEL_INQUIRE);
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
                    break;
                case AppointOrder.ORDER_TYPE_PROCESSING:
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_INQUIRE);
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED_INQUIRE);
                    typeList.add(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL_INQUIRE);
                    break;
                case AppointOrder.ORDER_TYPE_COMPLETED:
                    typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_NO_INQUIRE);
                    typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
                    break;
                case AppointOrder.ORDER_TYPE_SOLD:
                    typeList.add(AppointOrder.ORDER_SOLD_INQUIRE);
                    break;
                default:
                    break;
            }

            Students students = (Students) request.getAttribute("user");
            log.info("students is "+students);
            Map<String, Object> map = DynamicUtil.getAppointOrderList(typeList, null, null, null, null,
                    students.getId(), null, null, null, null, null);
            log.info("map is "+map);
            List<Long> orderMaxIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            log.info("orderMaxIds is "+orderMaxIds);
            Integer total=null;
            List<AppointOrder> appointOrderList=new ArrayList<>();
            Long nowTime = System.currentTimeMillis();
            if(type.equals(AppointOrder.ORDER_TYPE_COMPLETED)||type.equals(AppointOrder.ORDER_TYPE_SOLD)){
                List<Long> orderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, start, size);
                log.info("orderIds is "+orderIds);
                total = orderMaxIds.size();
                if(CollectionUtils.isNotEmpty(orderIds)){
                    appointOrderList = appointOrderService.getObjectsByIds(orderIds);
                }
            }else {
                List<AppointOrder> appointOrderAllList =appointOrderService.getObjectsByIds(orderMaxIds);
                List<AppointOrder> appointOrderNewList=new ArrayList<>();
                for (int i=0;i<appointOrderAllList.size();i++){
                    AppointOrder appointOrder=appointOrderAllList.get(i);
                    if(type.equals(AppointOrder.ORDER_TYPE_PENDING)&&
                            ((appointOrder.getTime()+appointOrder.getTimeStart())>nowTime)){
                        appointOrderNewList.add(appointOrder);
                    }
                    if(type.equals(AppointOrder.ORDER_TYPE_PROCESSING)&&
                            ((appointOrder.getTime()+appointOrder.getTimeStart())<nowTime)){
                        appointOrderNewList.add(appointOrder);
                    }
                }
                total =appointOrderNewList.size();
                for(int i=0;i<appointOrderNewList.size();i++){
                    AppointOrder appointOrder=appointOrderNewList.get(i);
                    if(i>=start||i<(start+size)){
                        appointOrderList.add(appointOrder);
                    }

                }
            }


            if((page-1)*size < total){
                model.addAttribute("appointOrderList", appointOrderList);
            }else{
                model.addAttribute("appointOrderList", "");
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/carOrderList";
    }

    /**
     *取消订单
     * @param request
     * @param response
     * @param model
     * @param id
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/car/order/cancel/{id}", method = RequestMethod.PUT)
    public String carOrderCancel(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer type, String cancel) throws Exception {
        log.info("type is " + type + " id is " + id);
        if (DataUtils.isNullOrEmpty(type)) {
            log.info("type is null");
            model.addAttribute("code", -22017);
            return "/common/failure";
        }
        Students students = (Students) request.getAttribute("user");
        try {
            AppointOrder appointOrder = appointOrderService.getObjectById(id);
            Long nowTime = System.currentTimeMillis();
            Coach coach = coachService.getObjectById(appointOrder.getCoach());
            if(nowTime>=(appointOrder.getTimeStart()+appointOrder.getTime())){
                log.info("type is null");
                model.addAttribute("code", -22032);
                return "/common/failure";
            }

            if(DataUtils.isNullOrEmpty(appointOrder)){
                log.info("appointOrder is null");
                model.addAttribute("code", -22034);
                return "/common/failure";
            }
            log.info("appointOrder is "+appointOrder);
            Integer orderType = appointOrder.getType();
            log.info("orderType is "+orderType+"  type  is "+type);
            if (orderType.equals(AppointOrder.STUDENT_PENDING_COACH_CANCEL)) {//学员待处理，教练取消
                if (type.equals(AppointOrder.ORDER_AGREE_YES)) {//学员同意取消
                    appointOrder.setType(AppointOrder.ORDER_SOLD);
                    appointOrder.setCancelTime(System.currentTimeMillis());
                    if((Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON))){
                        if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                            BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionTwoNumerator())
                                    - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                            students.setSectionTwoNumerator(time.toString());
                        }
                        if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                            BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator())
                                    - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                            students.setSectionThreeNumerator(time.toString());
                        }
                    }

                } else {//学员拒绝取消
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED);
                    appointOrder.setCancel(null);
                    String message = "您的学员在" + dateTime() +
                            "拒绝取消练车订单。请及时处理。";
                    otherAppUser(response, coach.getPlatform(), coach.getDeviceToken(), null, message);
                }
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED)) {//学员进行中，教练未确认
                if (type.equals(AppointOrder.ORDER_AGREE_YES)) {//教练同意订单
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED);
                } else if (type.equals(AppointOrder.ORDER_AGREE_NO)) {//教练拒绝订单
                    appointOrder.setType(AppointOrder.STUDENT_PENDING_COACH_CANCEL);
                    if(DataUtils.isNullOrEmpty(cancel)){
                        log.info("appointOrder is null");
                        model.addAttribute("code", -22019);
                        return "/common/failure";
                    }
                    appointOrder.setCancel(cancel);
                } else {//学员直接取消订单
                    if((Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON))) {
                        if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                            BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionTwoNumerator())
                                    - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                            students.setSectionTwoNumerator(time.toString());
                        }
                        if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                            BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator())
                                    - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                            students.setSectionThreeNumerator(time.toString());
                        }
                    }
                    appointOrder.setType(AppointOrder.ORDER_SOLD);
                    appointOrder.setCancelTime(System.currentTimeMillis());
                }
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED)) {//学员进行中，教练已确认
                appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL);//学员取消订单
                if(DataUtils.isNullOrEmpty(cancel)){
                    log.info("appointOrder is null");
                    model.addAttribute("code", -22019);
                    return "/common/failure";
                }
                appointOrder.setCancel(cancel);
            } else if (orderType.equals(AppointOrder.STUDENT_PROCESSING_COACH_UNCOMFIRMED_ORDER_CANCEL)) {//学员进行中，取消订单，教练未确认，
                if (type.equals(AppointOrder.ORDER_AGREE_YES)) {//教练同意取消
                    if((Integer.valueOf(students.getCertification()).equals(Coach.CERTIFICATION_ON))) {
                        if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.TWO_SUBJECT)) {
                            BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionTwoNumerator())
                                    - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                            students.setSectionTwoNumerator(time.toString());
                        }
                        if (Integer.valueOf(appointOrder.getSubject()).equals(AdvanceTime.THREE_SUBJECT)) {
                            BigDecimal time = new BigDecimal(Double.valueOf(students.getSectionThreeNumerator())
                                    - Double.valueOf(appointOrder.getStudyTime())).setScale(2, BigDecimal.ROUND_HALF_UP);
                            students.setSectionThreeNumerator(time.toString());
                        }
                    }
                    appointOrder.setType(AppointOrder.ORDER_SOLD);
                    appointOrder.setCancelTime(System.currentTimeMillis());
                } else {//教练拒绝取消
                    appointOrder.setType(AppointOrder.STUDENT_PROCESSING_COACH_COMFIRMED);
                    appointOrder.setCancel(null);
                }
            } else {
                log.info("order is over");
                model.addAttribute("code", -22018);
                return "/common/failure";
            }

            appointOrderService.update(appointOrder);
            studentsService.update(students);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     *评价订单
     * @param request
     * @param response
     * @param model
     * @param id
     * @param score
     * @param content
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/car/order/evaluate/{id}", method = RequestMethod.PUT)
    public String carOrderEvaluate(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, String score, String content) throws Exception {
        log.info("content is " + content + " id is " + id + " score is " + score);
        if (DataUtils.isNullOrEmpty(content)) {
            log.info("content is null");
            model.addAttribute("code", -22035);
            return "/common/failure";
        }
        if (DataUtils.isNullOrEmpty(score)) {
            log.info("score is null");
            model.addAttribute("code", -22020);
            return "/common/failure";
        }
        Students students = (Students) request.getAttribute("user");


        try {
            AppointOrder appointOrder = appointOrderService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(appointOrder)){
                log.info("appointOrder is null");
                model.addAttribute("code", -22026);
                return "/common/failure";
            }
            log.info("appointOrder is "+appointOrder);
            Long studentId = students.getId();
            if (!studentId.equals(appointOrder.getStudent())) {
                log.info("studentId is error");
                model.addAttribute("code", -22022);
                return "/common/failure";
            }
            Integer type = appointOrder.getType();
            log.info("type is "+type);
            if (type.equals(AppointOrder.ORDER_COMPLETED_EVALUATED_NO)) {
                appointOrder.setComment(content);
                appointOrder.setScore(score);
                appointOrder.setType(AppointOrder.ORDER_COMPLETED_EVALUATED_YES);
                appointOrderService.update(appointOrder);
            } else {
                log.info("type is error");
                model.addAttribute("code", -22021);
                return "/common/failure";
            }
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     *评价列表
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/coach/evaluate/list/{id}", method = RequestMethod.GET)
    public String getCarOrderEvaluateList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id, Integer page, Integer size) throws Exception {
        log.info(" id is " + id);
        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            List<String> typeList = new ArrayList<>();
            typeList.add(AppointOrder.ORDER_COMPLETED_EVALUATED_YES_INQUIRE);
            Map<String, Object> map = DynamicUtil.getAppointOrderListByUpdate(typeList,  id);
            log.info("map is " + map);
            List<Long> orderMaxIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, 0,
                    Integer.MAX_VALUE);
            List<Long> orderIds = appointOrderService.getIdsByDynamicCondition(AppointOrder.class, map, start, size);
            log.info("orderIds is " + orderIds);
            Integer total = orderMaxIds.size();
            List<AppointOrder> appointOrderList=new ArrayList<>();
            if(CollectionUtils.isNotEmpty(orderIds)){
                appointOrderList = appointOrderService.getObjectsByIds(orderIds);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("appointOrderList", appointOrderList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/yi-nucleus-service/practiceCarController/json/CarOrderEvaluateList";
    }

    public String dateTime() {
        Long time = System.currentTimeMillis();
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(time);
        return date;
    }

    private boolean otherAppUser(HttpServletResponse response, String platForm, String deviceToken, String token,String message) throws IOException {
        try {

            Long startAt = null;
            Long endAt = System.currentTimeMillis() + ( 6* 24 * 60 * 60 * 1000);
            log.info(" startAt = " + startAt);

            String result = "";
            log.info("message : " + message);
            if ("android".equals(platForm)) {
                log.info(" android ");
                result = coachAndroidPushServiceImpl.pushMessaeForList("android", "notification", "unicast",
                        deviceToken.toString(), "学员约单通知", "学员约单通知", message, "go_app", "", "", "",
                        "", startAt, "", "true", endAt, "易教练APP通知");
                log.info(" anResult = " + result);
            } else if ("ios".equals(platForm)) {
                log.info(" ios ");
                result = coachIosPushServiceImpl.pushMessaeForList("ios", "notification", "unicast",
                        deviceToken.toString(), "学员约单通知", "学员约单通知", message, "go_app", "", "", "",
                        "", startAt, "", "true", endAt, "易教练APP通知");
                log.info(" iosResult = " + result);
            } else {
                log.info("user platform : " + platForm);
            }

            if (DataUtils.isNotNullOrEmpty(result)) {
                JSONObject jsonObject = JSONObject.fromObject(result);
                if ("SUCCESS".equals((String) jsonObject.get("ret"))) {
                    log.info(" push success ");
                } else {
                    log.info("fail" + jsonObject.get("data"));
                    JSONObject data = JSONObject.fromObject(jsonObject.get("data").toString());
                    log.info(" data = " + data);
                    log.info(" errorCode = " + data.get("error_code"));
                }
            } else {
                log.info("user no device before");
            }

        } catch (Throwable t) {
            log.error("user logout error  ");
            t.printStackTrace();

        }
        return false;
    }


}
