package com.ptteng.controller;

import cn.jpush.api.report.UsersResult;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.model.DisplayMessage;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Coach;
import com.ptteng.yi.nucleus.model.DrivingClass;
import com.ptteng.yi.nucleus.model.Order;
import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.pub.model.Message;
import com.ptteng.yi.pub.model.UserMessage;
import com.ptteng.yi.pub.service.MessageService;
import com.ptteng.yi.pub.service.UserMessageService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

@Controller
public class UserMessageController {
    private final static Log log = LogFactory.getLog(UserMessageController.class);
    @Autowired
    UserMessageService userMessageService;
    @Autowired
    MessageService messageService;

    /**
     * create_by:qingshan
     * create_at:2018.1.26
     * 查看消息列表接口
     * @param messageType
     * @param targetReceive
     * @param page
     * @param size
     * @return array
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message/list ", method = RequestMethod.GET)
    public String getMessageList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer messageType, Integer targetReceive, Integer page, Integer size) throws Exception {
        log.info("params === messageType=" + messageType + "targetReceive" + targetReceive + "page" + page + "size"
                + size);
        //        处理page,size
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
//        验参
        int paramsCode = ParamsUtil.checkParamsOfGetUserMessageList(messageType, targetReceive, page, size);
        if (paramsCode != 0) {
                model.addAttribute("code", paramsCode);
                return "/common/failure";
        }
            try {
                List<UserMessage> userMessages = new ArrayList<>();
                ArrayList arrayList = new ArrayList();
                List<Long> messageIds = new ArrayList<>();
                List<Message> messages = new ArrayList<>();
                List<DisplayMessage> displayMessageList=new ArrayList<>();
                int numberOfUnread = 0;
                log.info("==========获取用户ID==========");
                Students student = (Students) request.getAttribute("user");
                Long uid = student.getId();
                log.info("获取的studentId =" + uid);
                //                查找符合要求的消息
                //                status为0的话可以选出所有消息
                Map<String, Object> params = DynamicUtil.getUserMessageList(messageType, targetReceive, uid, 0);
                List<Long> ids = userMessageService.getIdsByDynamicCondition(UserMessage.class, params, start, size);
                Integer total = userMessageService
                        .getIdsByDynamicCondition(UserMessage.class, params, 0, Integer.MAX_VALUE).size();
                log.info("the number of all userMessage is" + total);
                userMessages = userMessageService.getObjectsByIds(ids);
                //                查出每条userMessage对应的message
                for (UserMessage userMessage : userMessages) {
                    Long message_id = userMessage.getMessage_id();
                    messageIds.add(message_id);
                }
                messages = messageService.getObjectsByIds(messageIds);
                log.info("messageIds is" + messageIds);
                int i = 0;
                if (userMessages != null) {
                    for (UserMessage userMessage : userMessages) {
                        DisplayMessage displayMessage=new DisplayMessage();
                        displayMessage.setUserMessageId(userMessage.getId());
                        displayMessage.setMessageId(userMessage.getMessage_id());
                        displayMessage.setPushAt(messages.get(i).getPush_at());
                        displayMessage.setContent(messages.get(i).getContent());
                        displayMessage.setStatus(messages.get(i).getStatus());
                        displayMessage.setProgress(userMessage.getProgress());
                        displayMessage.setExamSubject(messages.get(i).getExamSubject());
                        displayMessage.setExamTime(messages.get(i).getExamTime());
                        if (userMessage.getStatus() == UserMessage.UNREADED_MESSAGE) {
                            numberOfUnread++;
                        }
                        displayMessageList.add(displayMessage);
                        i++;
                    }
                }
                log.info("the userMessages is" + arrayList);
                model.addAttribute("total", total);
                model.addAttribute("numberOfUnread", numberOfUnread);
                model.addAttribute("list", displayMessageList);
                model.addAttribute("code", 0);
            } catch (Exception e) {
                model.addAttribute("code", -100000);
                log.error("trzy catch a exception !,see==" + e);
            }

        return "/yi-pub-service/userMessage/json/userMessageList";
    }

    /**
     * create_by:qingshan
     * create_at:2018.1.26
     * 修改消息状态接口
     * @param messageType
     * @param targetReceive
     * @return array
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/message ", method = RequestMethod.PUT)
    public String updateUserMessagesStatus(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer messageType, Integer targetReceive) throws Exception {
        log.info("params === messageType=" + messageType + "targetReceive" + targetReceive);
        int paramsCode = ParamsUtil.checkParamsOfUpdateUserMessagesStatus(messageType, targetReceive);
        if (paramsCode != 0) {
                model.addAttribute("code", paramsCode);
                return "/common/failure";
        }
            try {
                List<UserMessage> unReadedUserMessages = new ArrayList<>();
                log.info("==========获取用户ID==========");
                Students student = (Students) request.getAttribute("user");
                Long uid = student.getId();
                log.info("获取的studentId =" + uid);
                //                查找符合要求的消息
                Map<String, Object> params = DynamicUtil.getUserMessageList(messageType, targetReceive, uid, 2);
                List<Long> ids = userMessageService.getIdsByDynamicCondition(UserMessage.class, params, 0,
                        Integer.MAX_VALUE);
                log.info("all unReadUserMessages is" + ids);
                //                验空
                if (ids != null) {
                    unReadedUserMessages = userMessageService.getObjectsByIds(ids);
                    for (UserMessage userMessage : unReadedUserMessages) {
                        userMessage.setStatus(UserMessage.READED_MESSAGE);
                    }
                    userMessageService.updateList(unReadedUserMessages);
                }
                model.addAttribute("code", 0);
                log.info("update userMessages status success!");

            } catch (Exception e) {
                e.printStackTrace();
                model.addAttribute("code", -100000);
            }

        return "/common/success";
    }

    /**
     * create_by:qingshan
     * create_at:2018.1.29
     * 查看消息未读条数接口
     * @param messageType
     * @param targetReceive
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/message/unread ", method = RequestMethod.GET)
    public String getNumberOfUnreadMessage(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer messageType, Integer targetReceive) throws Exception {
        log.info("params === messageType=" + messageType + "targetReceive" + targetReceive);
        int paramsCode = ParamsUtil.checkParamsOfUpdateUserMessagesStatus(messageType, targetReceive);
        if (paramsCode != 0) {
                model.addAttribute("code", paramsCode);
                return "/common/failure";
        }
        int numberOfUnread = 0;
        try {
                List<UserMessage> unReadedUserMessages = new ArrayList<>();
                Students student = (Students) request.getAttribute("user");
                Long uid = student.getId();
                log.info("获取的studentId =" + uid);
                //                查找符合要求的消息
                Map<String, Object> params = DynamicUtil.getUserMessageList(messageType, targetReceive, uid, UserMessage.UNREADED_MESSAGE);
                List<Long> ids = userMessageService.getIdsByDynamicCondition(UserMessage.class, params, 0,
                        Integer.MAX_VALUE);
                log.info("all unReadUserMessages is" + ids);
                numberOfUnread = ids.size();
                log.info("numberOfUnread=" + numberOfUnread);
                model.addAttribute("numberOfUnread", numberOfUnread);
                model.addAttribute("code", 0);
                log.info("update userMessages status success!");
        } catch (Exception e) {
            e.printStackTrace();
            model.addAttribute("code", -100000);
        }
        return "/yi-pub-service/userMessage/json/userMessageUnreadNum";
    }
}
