package com.ptteng.controller;

import java.util.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.model.StudentPracticeKey;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ListUtil;
import com.ptteng.util.ParamsUtil;
import com.ptteng.yi.nucleus.model.Note;
import com.ptteng.yi.nucleus.service.NoteService;
import com.ptteng.yi.nucleus.service.StudentFavoriteRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.SubjectPractice;
import com.ptteng.yi.nucleus.service.SubjectPracticeService;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *  科目一和科目四练习相关
 *
 * @author zhangxin
 * @Date 2018/01/09
 */
@Controller
public class SubjectPracticeController {
    private static final Log log = LogFactory.getLog(SubjectPracticeController.class);
    /**
     * 顺序练习
     */
    public static final int PRACTICE_SEQUENCE = 0;
    /**
     * 未做题目
     */
    public static final int PRACTICE_NOT_DONE = 1;
    /**
     * 错题
     */
    public static final int PRACTICE_WRONG = 2;
    /**
     * 收藏题目
     */
    public static final int PRACTICE_FAVORITE = 3;
    /**
     * 随机练习
     */
    public static final int PRACTICE_RANDOM = 4;
    /**
     * 模拟考试题目
     */
    public static final int PRACTICE_MOCK = 5;
    /**
     * 专项练习
     */
    public static final int PRACTICE_SPECIAL = 6;

    /**
     *  第一道题目
     * */
    public static final int FIRST_PRACTICE = 0;
    /**
     *  向后获取数据
     * */
    public static final int MODE_BACKWARD = 1;
    /**
     *  向前获取数据
     * */
    public static final int MODE_FORWARD = 0;

    @Resource
    private SubjectPracticeService subjectPracticeService;

    @Resource
    private NoteService noteService;

    @Resource
    private StudentFavoriteRelationService studentFavoriteRelationService;

    /**
     * 获取顺序/未做题目/错题/收藏题目练习列表接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/u/practice/portion/list", method = RequestMethod.GET)
    public String getPortionOfPractices(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long studentId, Long practiceId, Integer subjectType, Integer type, Integer size, Integer mode)
            throws Exception {
        log.info("Interface GET /a/u/practice/portion/list, Method getPortionOfPractices() parameters : "
                + "studentId: " + studentId + ", practiceId: " + practiceId + ", subjectType: " + subjectType
                + ", type: " + type + ", mode: " + mode);
        int actualSize = ParamsUtil.calculateActualSize(size);
        log.info("size: " + actualSize);

        int validateResult = ParamsUtil.checkParamsOfGetPortionOfPractices(studentId, practiceId, subjectType, type,
                mode);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            List<Long> practiceIdListTotal = new ArrayList<>();
            log.info("Key parameter: parameter type is : " + type);
            switch (type) {
            case PRACTICE_SEQUENCE:
                practiceIdListTotal = subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, 0,
                        Integer.MAX_VALUE);
                break;
            case PRACTICE_NOT_DONE:
                practiceIdListTotal = subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, 0,
                        Integer.MAX_VALUE);
                List<Long> hasDoneIdList = noteService.getPracticeIdsByStudentIdAndSubjectType(studentId, subjectType,
                        0, Integer.MAX_VALUE);
                practiceIdListTotal = ListUtil.eliminateSublist(hasDoneIdList, practiceIdListTotal);
                break;
            case PRACTICE_WRONG:
                practiceIdListTotal = noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId,
                        subjectType, Note.RESULT_WRONG, 0, Integer.MAX_VALUE);
                break;
            case PRACTICE_FAVORITE:
                practiceIdListTotal = studentFavoriteRelationService.getTargetIdsByStudentIdAndTargetType(studentId,
                        subjectType, 0, Integer.MAX_VALUE);
                break;
            default:
                break;
            }
            log.info("get practice id list total, list size is : " + practiceIdListTotal.size());

            if ((practiceId != FIRST_PRACTICE) && (!practiceIdListTotal.contains(practiceId))) {
                log.info("Error value of practiceId, practiceId is: " + practiceId);
                model.addAttribute("code", -1001);
                return "/common/failure";
            }
            if (practiceId == FIRST_PRACTICE) {
                practiceId = practiceIdListTotal.get(0);
                mode = MODE_BACKWARD;
            }

            List<Long> resultIdList = ListUtil.getElementsFromList(practiceIdListTotal,
                    practiceIdListTotal.indexOf(practiceId), actualSize, mode);
            log.info("get result id list, list size is : " + resultIdList.size());

            List<SubjectPractice> subjectPracticeList = null;
            if (CollectionUtils.isNotEmpty(resultIdList)) {
                subjectPracticeList = subjectPracticeService.getObjectsByIds(resultIdList);
                log.info("get practice list data, list size is : " + subjectPracticeList.size());
            }

            model.addAttribute("code", 0);
            model.addAttribute("size", actualSize);
            model.addAttribute("total", practiceIdListTotal.size());
            model.addAttribute("subjectPracticeList", subjectPracticeList);
            return "/yi-nucleus-service/subjectPractice/json/subjectPracticeListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getPortionOfPractices() failed, studentId: " + studentId + ", practiceId: " + practiceId
                    + ", subjectType: " + subjectType + ", type: " + type + ", mode: " + mode);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 获取练习题目ID列表接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/practice/key/list", method = RequestMethod.GET)
    public String getPracticeIdList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long studentId, Integer subjectType, Integer type, String special) throws Exception {
        log.info("Interface GET /a/u/practice/key/list, Method getPracticeIdList() parameters: studentId: " + studentId
                + ", subjectType: " + subjectType + ", type: " + type + ", special: " + special);

        int validateResult = ParamsUtil.checkParamsOfGetPracticeIdList(studentId, subjectType, type, special);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            log.info("Key parameter: parameter type is : " + type);
            //获取该学员的做对的题目idList, 以及做错的题目IdList
            List<Long> rightPracticeIds = new ArrayList<>();
            List<Long> wrongPracticeIds = new ArrayList<>();
            if ((type != PRACTICE_NOT_DONE) && (type != PRACTICE_MOCK)) {
                rightPracticeIds = noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType,
                        Note.RESULT_RIGHT, 0, Integer.MAX_VALUE);
                wrongPracticeIds = noteService.getPracticeIdsByStudentIdAndSubjectTypeAndResult(studentId, subjectType,
                        Note.RESULT_WRONG, 0, Integer.MAX_VALUE);
                log.info("get right practice id list, size is : " + rightPracticeIds.size()
                        + ", get wrong practice id list, size is: " + wrongPracticeIds.size());
            }

            List<Long> practiceIdList = new ArrayList<>();
            switch (type) {
            case PRACTICE_SEQUENCE:
                practiceIdList = subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, 0,
                        Integer.MAX_VALUE);
                break;
            case PRACTICE_NOT_DONE:
                practiceIdList = subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, 0,
                        Integer.MAX_VALUE);
                List<Long> hasDoneIdList = noteService.getPracticeIdsByStudentIdAndSubjectType(studentId, subjectType,
                        0, Integer.MAX_VALUE);
                practiceIdList = ListUtil.eliminateSublist(hasDoneIdList, practiceIdList);
                break;
            case PRACTICE_WRONG:
                practiceIdList = wrongPracticeIds;
                break;
            case PRACTICE_FAVORITE:
                practiceIdList = studentFavoriteRelationService.getTargetIdsByStudentIdAndTargetType(studentId,
                        subjectType, 0, Integer.MAX_VALUE);
                break;
            case PRACTICE_RANDOM:
                List<Long> practiceTotal = subjectPracticeService.getSubjectPracticeIdsBySubjectType(subjectType, 0,
                        Integer.MAX_VALUE);
                List<Long> hasNotDone = ListUtil.eliminateSublist(wrongPracticeIds, practiceTotal);
                hasNotDone = ListUtil.eliminateSublist(rightPracticeIds, hasNotDone);

                practiceIdList = hasNotDone;
                Collections.shuffle(practiceIdList);
                Collections.shuffle(wrongPracticeIds);
                Collections.shuffle(rightPracticeIds);
                practiceIdList.addAll(wrongPracticeIds);
                practiceIdList.addAll(rightPracticeIds);
                break;
            case PRACTICE_MOCK:
                practiceIdList = subjectPracticeService.getMockExamPracticeIdsBySubjectType(subjectType);
                break;
            case PRACTICE_SPECIAL:
                Map<String, Object> querySpecialPracticeIdsMap = DynamicUtil.getSpecialPracticeParams(subjectType,
                        special, false);
                practiceIdList = subjectPracticeService.getIdsByDynamicCondition(SubjectPractice.class,
                        querySpecialPracticeIdsMap, 0, Integer.MAX_VALUE);
                break;
            default:
                break;
            }
            log.info("get practice Id list , list size is : " + practiceIdList.size());

            List<Long> favoritePracticeIdList = studentFavoriteRelationService
                    .getTargetIdsByStudentIdAndTargetType(studentId, subjectType, 0, Integer.MAX_VALUE);
            log.info("get favorite practice id list, list size is : " + favoritePracticeIdList.size());

            List<StudentPracticeKey> resultList = StudentPracticeKey.generateStudentPracticeKeyList(practiceIdList,
                    rightPracticeIds, wrongPracticeIds, favoritePracticeIdList, type);
            log.info("get resultList, list size is : " + resultList.size());

            model.addAttribute("code", 0);
            model.addAttribute("studentPracticeKeyList", resultList);
            model.addAttribute("total", practiceIdList.size());
            return "/yi-nucleus-service/subjectPractice/json/subjectPracticeIdList";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getPracticeIdList() failed, parameters: subjectType: " + subjectType + ", type: " + type
                    + ", special: " + special);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 根据IDList获取练习试题列表接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/practice/list", method = RequestMethod.GET)
    public String getPracticesByIdList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer subjectType, @RequestParam Long[] idList) throws Exception {
        log.info("Interface GET /a/u/practice/list, Method getPracticesByIdList() parameters: subjectType: "
                + subjectType + ", idList: " + Arrays.toString(idList));

        int validateResult = ParamsUtil.checkParamsOfGetPracticesByIdList(idList, subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            List<SubjectPractice> subjectPracticeList = subjectPracticeService.getObjectsByIds(Arrays.asList(idList));
            log.info("get subjectPractice list , list size is : " + subjectPracticeList.size());

            model.addAttribute("code", 0);
            model.addAttribute("subjectPracticeList", subjectPracticeList);
            model.addAttribute("total", subjectPracticeList.size());
            return "/yi-nucleus-service/subjectPractice/json/subjectPracticeListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getPracticesByIdList() failed, parameters: subjectType: " + subjectType + ", idList: "
                    + Arrays.toString(idList));
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }
}
