package com.ptteng.controller;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.SubjectOperation;
import com.ptteng.yi.nucleus.service.SubjectOperationService;

/**
 *  驾驶技巧和考试资讯相关
 *
 * @author zhangxin
 * @Date 2018/01/09
 */
@Controller
public class SubjectOperationController {
    private static final Log log = LogFactory.getLog(SubjectOperationController.class);

    @Resource
    private SubjectOperationService subjectOperationService;

    /**
     * 获取科目考试资讯/驾驶技巧列表
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @RequestMapping(value = "/a/subject/content/list", method = RequestMethod.GET)
    public String getSubjectOperationList(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer subjectType) throws Exception {

        log.info("Interface GET /a/subject/content/list, Method getSubjectOperationList() parameter: subjectType: "
                + subjectType);

        if (DataUtils.isNullOrEmpty(subjectType)) {
            log.info("Parameter subjectType can not be null");
            model.addAttribute("code", -1000);
            return "/common/failure";
        }
        if (!subjectType.equals(SubjectOperation.SUBJECT_TWO) && !subjectType.equals(SubjectOperation.SUBJECT_THREE)) {
            log.info("Error value of parameter subjectType, subjectType is : " + subjectType);
            model.addAttribute("code", -1001);
            return "/common/failure";
        }

        try {
            List<SubjectOperation> subjectOperationList = subjectOperationService
                    .getSubjectOperationListBySubjectTypeAndStatusOrderBySortAndCreateAt(subjectType,
                            SubjectOperation.ON_LINE, 0, Integer.MAX_VALUE);
            log.info("get subjectOperation data list, list size is :" + subjectOperationList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", subjectOperationList.size());
            model.addAttribute("subjectOperationList", subjectOperationList);
            return "/yi-nucleus-service/subjectOperation/json/subjectOperationListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSubjectOperationList() failed, parameter: subjectType: " + subjectType);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 获取科目内容考试资讯/驾驶技巧详情
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/subject/content/{id}", method = RequestMethod.GET)
    public String getSubjectOperationDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {
        log.info("Interface GET /a/subject/content/{id}, Method getSubjectOperationDetail() parameter: id: " + id);

        try {
            SubjectOperation subjectOperation = subjectOperationService.getObjectById(id);
            log.info("get subjectOperation data success, subjectOperation id is : " + subjectOperation.getId());

            model.addAttribute("code", 0);
            model.addAttribute("subjectOperation", subjectOperation);
            return "/yi-nucleus-service/subjectOperation/json/subjectOperationDetailJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getSubjectOperationDetail() failed, parameter: id: " + id);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }
}
