package com.ptteng.controller;

import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.util.ParamsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.SubjectExam;
import com.ptteng.yi.nucleus.service.SubjectExamService;

/**
 * 考试相关接口
 *
 * @author zhangxin
 * @Date 2018/01/09
 */
@Controller
public class SubjectExamController {
    private static final Log log = LogFactory.getLog(SubjectExamController.class);

    @Resource
    private SubjectExamService subjectExamService;

    /**
     * 查看模拟考试结果列表接口
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/mocks/list", method = RequestMethod.GET)
    public String getMockExamResult(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long studentId, Integer subjectType, Integer page, Integer size) throws Exception {

        log.info("Interface GET /a/u/mocks/list, Method getMockExamResult() parameters: studentId: " + studentId
                + ", subjectType: " + subjectType);
        int actualSize = ParamsUtil.calculateActualSize(size);
        int startPosition = ParamsUtil.calculateStartPosition(page, actualSize);
        log.info("page: " + startPosition + ", size: " + actualSize);

        int validate = ParamsUtil.checkParamsOfStudentIdAndSubjectType(studentId, subjectType);
        if (validate != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validate);
            return "/common/failure";
        }

        try {
            List<SubjectExam> mockExamList = subjectExamService.getSubjectExamListByStudentIdAndType(studentId,
                    subjectType, startPosition, actualSize);
            log.info("get mockExam data list, list size is : " + mockExamList.size());

            Integer total = subjectExamService.countSubjectExamIdsByStudentIdAndType(studentId, subjectType);
            log.info("count mockExam total, total is : " + total);

            model.addAttribute("code", 0);
            model.addAttribute("size", actualSize);
            model.addAttribute("total", total);
            model.addAttribute("subjectExamList", mockExamList);
            return "/yi-nucleus-service/subjectExam/json/subjectExamListJson";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method getMockExamResult() failed, parameters: studentId: " + studentId + ", subjectType: "
                    + subjectType);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 保存模拟考试结果
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/mocks", method = RequestMethod.POST)
    public String recordMockExamResult(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long studentId, Long time, Integer rights, Integer wrong, Integer subjectType) throws Exception {

        log.info("Interface POST /a/u/mocks, Method recordMockExamResult() parameters: studentId: " + studentId
                + ", time: " + time + ", rights: " + rights + ", wrong: " + wrong + ", subjectType: " + subjectType);

        int validateResult = ParamsUtil.checkParamsOfRecordMockExamResult(studentId, time, rights, wrong, subjectType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            SubjectExam mockExam = new SubjectExam();
            mockExam.setStudentId(studentId);
            mockExam.setTime(time);
            mockExam.setRight(rights);
            mockExam.setWrong(wrong);
            mockExam.setType(subjectType);
            mockExam.setCreateBy(studentId);
            mockExam.setUpdateBy(studentId);
            Long mockExamId = subjectExamService.insert(mockExam);
            log.info("insert mock exam result success, id is : " + mockExamId);

            model.addAttribute("code", 0);
            model.addAttribute("id", mockExamId);
            return "/common/insert";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method recordMockExamResult() failed, parameters: studentId: " + studentId + ", time: " + time
                    + ", rights: " + rights + ", wrong: " + wrong + ", subjectType: " + subjectType);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }
}
