package com.ptteng.controller;

import com.ptteng.constant.AlipayConstantConfig;
import com.ptteng.constant.WxConstantConfig;
import com.ptteng.util.*;
import com.ptteng.util.Base64;
import com.ptteng.yi.nucleus.model.*;
import com.ptteng.yi.nucleus.service.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.weaver.ast.Or;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.qding.common.util.HttpClientUtil;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.*;

import static com.ptteng.constant.AlipayConstantConfig.private_key;
import static com.ptteng.util.WxUtil.exChange;
import static com.ptteng.yi.nucleus.model.Order.PAYMANNER_0;
import static com.ptteng.yi.nucleus.model.Order.PAYMANNER_1;

/**
 * Order  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class OrderController {
	private static final Log log = LogFactory.getLog(OrderController.class);

	@Autowired
	private OrderService orderService;
	@Autowired
	private HttpClientUtil httpClientUtil;

	@Autowired
	private DrivingClassService drivingClassService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private SchoolClassRelationService schoolClassRelationService;
	@Autowired
	private SchoolService schoolService;

	@Autowired
	private CardService cardService;

	@Autowired
	private CardTypeService cardTypeService;

	@Autowired
	private StudentsService studentsService;
	@Resource
	private EnrollmentDetailService enrollmentDetailService;
	@Resource
	private RecordService recordService;
	public static final String SIGN_ALGORITHMS = "SHA1WithRSA";

	@RequestMapping(value = "/a/u/order/", method = RequestMethod.GET)
	public String getOrderJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {
			Students student = (Students) request.getAttribute("user");
			if (DataUtils.isNullOrEmpty(student)){
				model.addAttribute("code", -5001);
				log.info("user has buy");
				return "/common/failure";
			}
			Map<String,Object> map = DynamicUtil.getOrderList(null,student.getId(),null,null,null,Order.COMPLETED);
			List<Long> orderIds = orderService.getIdsByDynamicCondition(Order.class,map,0,Integer.MAX_VALUE);
			if ((DataUtils.isNullOrEmpty(orderIds))){
				model.addAttribute("code", -22026);
				log.info("user has buy");
				return "/common/failure";
			}
			List<Order> orderList = orderService.getObjectsByIds(orderIds);

			model.addAttribute("code", 0);

			model.addAttribute("orderList", orderList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get order error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/order/json/orderListJson";
	}

	//新建订单

	@RequestMapping(value = "/a/u/order", method = RequestMethod.POST)
	public String createOrder(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long targetId,
			Integer type, Long schoolId, Long cid) throws Exception {
		log.info("tid " + targetId + "sid " + schoolId + "cid" + cid + "type " + type);
		try {
			Students student = (Students) request.getAttribute("user");
			Order order = new Order();
			Long uid = student.getId();
			//实际缴
			Double cost = null;
			//优惠金额
			Double value = null;
			//实际价格
			Double actualPay = null;
			School school = schoolService.getObjectById(schoolId);

			Map<String, Object> map1 = new HashMap<>();
			map1 = DynamicUtil.getOrderList(null, uid, null, null, null, 3);
			List<Long> uids = orderService.getIdsByDynamicCondition(Order.class, map1, 0, Integer.MAX_VALUE);
			log.info("uids :" + uids);
			if (uids.size() > 0) {
				model.addAttribute("code", -21007);
				log.info("parameter schools is null or empty");
				return "/common/failure";
			}
			log.info("school :" + school);
			if (DataUtils.isNullOrEmpty(school)) {
				model.addAttribute("code", -21000);
				log.info("user has buy");
				return "/common/failure";
			} else {
				order.setSchoolId(schoolId);
			}
			//班型
			log.info("targetId" + targetId);
			DrivingClass drivingClass = null;
			if (type.equals(Order.PAYTYPE_0)) {
				drivingClass = drivingClassService.getObjectById(targetId);
				log.info(drivingClass);
				if (DataUtils.isNullOrEmpty(drivingClass)) {
					model.addAttribute("code", -9024);
					log.info("parameter schools is null or empty");
					return "/common/failure";
				} else {
					order.setShopName(drivingClass.getName());
					order.setClassId(drivingClass.getId());
					//原价
					cost = Double.valueOf(drivingClass.getCost());
				}

			} else {
				model.addAttribute("code", -9024);
				log.info("parameter schools is null or empty");
				return "/common/failure";
			}

			//设置基本情况
			if (DataUtils.isNullOrEmpty(uid)) {
				model.addAttribute("code", -9024);
				log.info("parameter uid is null or empty");
				return "/common/failure";
			} else {
				order.setStuId(uid);
			}
			if (DataUtils.isNullOrEmpty(student.getIdentification())) {
				model.addAttribute("code", -21002);
				log.info("parameter mobile is null or empty");
				return "/common/failure";
			}
			if (DataUtils.isNullOrEmpty(student.getName())) {
				model.addAttribute("code", -21003);
				log.info("parameter mobile is null or empty");
				return "/common/failure";
			}
			log.info("优惠券");
			if (DataUtils.isNotNullOrEmpty(cid)) {
				Card card = cardService.getObjectById(cid);
				CardType cardType = cardTypeService.getObjectById(card.getTid());
				order.setCoupons(cid.toString());
				//检查优惠券是否可用
				List<Long> schoolList = OrderIdUtil.getarray(card.getSchools());
				log.info(schoolList + "schoolList");
				List<Long> classList = OrderIdUtil.getarray(card.getClasses());
				log.info(classList + "classList");
				if (!classList.contains(targetId)) {
					log.info("class不可用");
					model.addAttribute("code", -21006);
					return "/common/failure";
				}
				if (!schoolList.contains(schoolId)) {
					log.info("school不可用");
					model.addAttribute("code", -21008);
					return "/common/failure";
				}
				value = Double.valueOf(cardType.getValue());

				//改变优惠券状态
				if (card.getStatus().equals(Constants.ALLLOW)) {
					log.info("card可用");
					order.setCoupons(cid.toString());
				} else {
					log.info("card不可用");
					model.addAttribute("code", -21011);
					return "/common/failure";
				}
			} else {
				value = Double.valueOf(0);
				order.setCoupons("0");
			}

			//设置价格

			cost = Calculation.sub(cost, 0);
			log.info(cost + "cost=============");
			//实际价格
			order.setCost(cost.toString());
			order.setStatus(Order.WAITFORPAY);
			order.setPayType(Order.PAYTYPE_0);
			order.setCityId(school.getCityId());

			actualPay = Calculation.sub(cost, value);
			log.info(actualPay + "acpay");
			log.info(cost + "cos");
			log.info(value + "value");
			order.setConcessionaryAmount(value.toString());
			order.setActualPayment(actualPay.toString());
			log.info("order" + order);

			log.info("==========生成订单号==========");
			String order_Id = OrderIdUtil.generateOrderId();
			order.setOid(order_Id);
			order.setCreateBy(uid);
			order.setUpdateBy(uid);
			log.info(order_Id + "orderid");
			Map<String, Object> map = new HashMap<>();
			map = DynamicUtil.getOrderList(null, uid, schoolId, null, order_Id, null);
			List<Long> oids = orderService.getIdsByDynamicCondition(Order.class, map, 0, Integer.MAX_VALUE);
			while (oids.size() > 0) {
				order_Id = OrderIdUtil.generateOrderId();
				order.setOid(order_Id);
			}
			log.info(order);
			Long currentTime = System.currentTimeMillis();
			Long oid = orderService.insert(order);
			model.addAttribute("code", 0);
			model.addAttribute("oid", oid);
			model.addAttribute("orderNo", order_Id);
			model.addAttribute("school", school);
			model.addAttribute("drivingClass", drivingClass);
			model.addAttribute("order", order);
			model.addAttribute("currentTime", currentTime);

		} catch (Throwable t) {
			model.addAttribute("code", -1);
		}

		return "/yi-nucleus-service/order/json/orderDetailJson";
	}

	@RequestMapping(value = "/a/u/order/contract/{oid}", method = RequestMethod.PUT)
	public String updateContract(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long oid, String contract) throws Exception {

		log.info("save order : " + oid + " payment type : " + contract);

		Students user = (Students) request.getAttribute("user");
		Long uid = user.getId();
		log.info("get uid " + uid);

		try {

			log.info("==========检验是否拥有本订单==========");
			Order order = orderService.getObjectById(oid);
			Integer status = null;

			if (DataUtils.isNullOrEmpty(contract)) {
				model.addAttribute("code", -21006);
				log.info(" center roleid is null");
				return "/data/json";
			}

			if (DataUtils.isNotNullOrEmpty(order)) {
				status = order.getStatus();
				log.info(status + "status");
				if (status.equals(0)) {
					order.setContract(contract);
					log.info("set contract ");
				} else {
					log.info("not your order");
					model.addAttribute("code", -4016);
					return "/common/success";
				}
			} else {
				log.info("not your order");
				model.addAttribute("code", -4016);
				return "/common/success";
			}
			orderService.update(order);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update pay way error, oid is  " + oid);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	@RequestMapping(value = "/a/u/order/pay/{oid}", method = RequestMethod.PUT)
	public String updatePayWay(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long oid, Integer payWay) throws Exception {

		log.info("save order : " + oid + " payment type : " + payWay);

		Students user = (Students) request.getAttribute("user");
		Long uid = user.getId();
		log.info("get uid " + uid);

		try {
			if (Order.PAYMANNER_0 != payWay && Order.PAYMANNER_1 != payWay && Order.PAYMANNER_2 != payWay) {
				log.info("illegal payWay");
				model.addAttribute("code", -4017);
				return "/common/success";
			}

			log.info("==========检验是否拥有本订单==========");
			//			Map<String,Object> map = new HashMap<>();
			//			map = DynamicUtil.getOrderList(null,uid,null,null,oid,1);
			//			List<Long> oids = orderService.getIdsByDynamicCondition(Order.class,map,0,Integer.MAX_VALUE);
			//			List<Order> orderList = orderService.getObjectsByIds(oids);
			Order order = orderService.getObjectById(oid);
			Integer status = order.getStatus();
			if (order.getStuId().equals(uid) && status.equals(0)) {

				log.info("==========修改支付方式==========");
				order.setPayWay(payWay);
				orderService.update(order);
				log.info("update payment success");
			} else {
				log.info("order.getStuId().equals(uid)" + order.getStuId().equals(uid));
				log.info("status.equals(0)" + status.equals(0));
				log.info("not your order");
				model.addAttribute("code", -4016);
				return "/common/success";
			}

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update pay way error, oid is  " + oid);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	//保存支付结果
	@RequestMapping(value = "/a/u/order/result/{oid}", method = RequestMethod.PUT)
	public String updateResult(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long oid, Integer result) throws Exception {

		log.info("save order : " + oid + " pay result : " + result);

		Students user = (Students) request.getAttribute("user");
		Long uid = user.getId();
		log.info("get uid " + uid);

		try {
			if (null == result) {
				log.info("null result");
				model.addAttribute("code", -4045);
				return "/common/success";
			}

			if (Order.PAY_SUCCESS != result && Order.PAY_FAIL != result) {
				log.info("illegal result");
				model.addAttribute("code", -4018);
				return "/common/success";
			}

			log.info("==========检验是否拥有本订单==========");
			Order Order = orderService.getObjectById(oid);
			log.info(Order);
			if (null == Order) {
				log.info("no such order");
				model.addAttribute("code", -3007);
				return "/common/success";
			}

			if (!uid.equals(Order.getStuId())) {
				log.info("not your order");
				model.addAttribute("code", -4016);
				return "/common/success";
			}

			log.info("==========支付结果==========");
			if (DataUtils.isNullOrEmpty(Order.getPayWay())) {
				log.info("order payType is null");
				model.addAttribute("code", -3008);
				return "/common/success";
			}
			Integer status = Order.getStatus();
			if (!status.equals(0)) {
				log.info("order payType is null");
				model.addAttribute("code", -3008);
				return "/common/success";
			}

			if (DataUtils.isNullOrEmpty(Order.getContract())) {
				log.info("order payType is null");
				model.addAttribute("code", -3008);
				return "/common/success";
			}

			if (Order.WAITFORPAY != Order.getStatus()) {
				log.info("close or already pay order");
				model.addAttribute("code", -3009);
				return "/common/success";
			}

			log.info(" /pay/check indentCode =  " + Order.getOid());

			// 如果是待支付，查银行
			int payManner = Order.getPayWay();//支付方式
			log.info("  payManner = " + payManner);

			switch (payManner) {

			case PAYMANNER_0: {
				log.info("==========jia==========");
				break;
			}
			case PAYMANNER_1: {
				log.info("==========支付宝==========");
				break;
			}
			default:
				break;
			}
			if (result.equals(1)) {
				OrderIdUtil orderIdUtil = new OrderIdUtil();
				log.info("?!!!!!");
				saveStuClass(oid, uid);
				log.info("???????????");
			} else {
				Order.setStatus(2);
				orderService.update(Order);
			}

			model.addAttribute("code", 0);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update order result error, oid is  " + oid);
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	/**
	 *
	 * @param request
	 * @param response
	 * @param model
	 * @param oid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/order/alipay/key/{oid}", method = RequestMethod.GET)
	public String getPrivateKey(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long oid) throws Exception {

		log.info("/a/u/order/alipay/key/{oid}" + "oid:" + oid);

		String subject = "易教练订单";
		String body = "";
		String indentCode = null;
		String domain = "http://dev.yi.student.ptteng.com";

		try {

			log.info("==========检验是否拥有本订单==========");

			Order order = orderService.getObjectById(oid);
			if (DataUtils.isNullOrEmpty(order)) {
				log.info("illegal result");
				model.addAttribute("code", -4018);
				return "/common/success";
			}
			if (DataUtils.isNullOrEmpty(order.getContract())) {
				log.info("illegal result");
				model.addAttribute("code", -21012);
				return "/common/success";
			}

			body = order.getShopName();
			String payBack = domain + "/pay/aliBack/" + indentCode;
			log.info("get pay back url : " + payBack);
			log.info("==========生成sign==========");
			String perSign = "partner=\"" + AlipayConstantConfig.partner + "\"&seller_id=\""
					+ AlipayConstantConfig.seller_id + "\"&out_trade_no=\"" + order.getOid() + "\"&subject=\"" + subject
					+ "\"&body=\"" + body + "\"&total_fee=\"" + order.getActualPayment()
					+ "\"&notify_url=\"http://www.xxx.com\"&service=\"mobile.securitypay.pay\"&payment_type=\"1\"&_input_charset=\"utf-8\"&it_b_pay=\"30m\"&show_url=\"m.alipay.com\"";

			String sign = sign(perSign, AlipayConstantConfig.private_key, "UTF-8");

			log.info("perSign is " + perSign);
			log.info("sign : " + sign);
			sign = URLEncoder.encode(sign);
			log.info("encode sign : " + sign);

			model.addAttribute("code", 0);
			model.addAttribute("sign", sign);
			model.addAttribute("privateKey", AlipayConstantConfig.private_key);
			model.addAttribute("orderSpec", perSign);
			model.addAttribute("appid", AlipayConstantConfig.appid);
			model.addAttribute("body", body);
			model.addAttribute("out_trade_no", order.getOid());
			model.addAttribute("total_fee", order.getActualPayment());

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("update pay way error, oid is  " + oid);
			model.addAttribute("code", -1);
		}

		return "/alipay/tradeQuery";
	}

	//调用微信预下单接口
	@RequestMapping(value = "/a/u/order/wx/key/{oid}", method = RequestMethod.GET)
	public String getPayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long oid) {
		log.info("order : " + oid + " get pay info ");

		XmlUtil xmlUtil = new XmlUtil();

		String name = "";

		try {
			log.info("==========检验是否拥有本订单==========");
			Order order = orderService.getObjectById(oid);
			if (null == order) {
				log.info("already pay the order");
				model.addAttribute("code", -3007);
				return "/common/success";
			}

			name = order.getShopName();
			BigDecimal money = new BigDecimal(order.getActualPayment());
			money = money.setScale(2, BigDecimal.ROUND_HALF_UP);
			Integer total_fee = money.multiply(new BigDecimal(100)).intValue();
			log.info(total_fee);
			/* 校验订单状态 */
			Integer status = order.getStatus();
			//			if (status.equals(0)) {
			//
			//			} else {
			//				log.info("orders status is :" + status);
			//				model.addAttribute("code", -24014);
			//				return "/common/success";
			//			}

			String nonce_str = getRandomStringByLength(16);
			String timestamp = create_timestamp();

			//调用微信预下单接口
			String perSign = "appid=" + WxConstantConfig.appid + "&body=" + name + "&mch_id=" + WxConstantConfig.mch_id
					+ "&nonce_str=" + nonce_str + "&notify_url=" + WxConstantConfig.notify_url + "&out_trade_no="
					+ order.getOid() + "&spbill_create_ip=" + WxConstantConfig.spbill_create_ip + "&total_fee="
					+ total_fee + "&trade_type=APP" + "&key=" + WxConstantConfig.app_key;

			String sign = MD5.MD5Encode(perSign);
			sign = exChange(sign);
			log.info("sign is : " + sign);

			String url = "<xml>" + "<appid>" + WxConstantConfig.appid + "</appid>" + "<body>" + name + "</body>"
					+ "<mch_id>" + WxConstantConfig.mch_id + "</mch_id>" + "<nonce_str>" + nonce_str + "</nonce_str>"
					+ "<notify_url>" + WxConstantConfig.notify_url + "</notify_url>" + "<out_trade_no>" + order.getOid()
					+ "</out_trade_no>" + "<spbill_create_ip>" + WxConstantConfig.spbill_create_ip
					+ "</spbill_create_ip>" + "<total_fee>" + total_fee + "</total_fee>"
					+ "<trade_type>APP</trade_type>" + "<sign>" + sign + "</sign>" + "</xml>";
			log.info("url is : " + url);

			String httpsresponse = httpClientUtil.sendPostRequestByJava(WxConstantConfig.order_url, url);
			log.info("get order url result is " + httpsresponse);

			String prepay_id = xmlUtil.xml(httpsresponse);

			log.info("prepay_id is :" + prepay_id);

			String perPaySign = "appid=" + WxConstantConfig.appid + "&noncestr=" + nonce_str + "&package=Sign=WXPay"
					+ "&partnerid=" + WxConstantConfig.mch_id + "&prepayid=" + prepay_id + "&timestamp=" + timestamp
					+ "&key=" + WxConstantConfig.app_key;
			String paySign = MD5.MD5Encode(perPaySign);
			paySign = exChange(paySign);
			log.info("paySign is :" + paySign);

			model.addAttribute("code", 0);
			model.addAttribute("prepay_id", prepay_id);
			model.addAttribute("nonceStr", nonce_str);
			model.addAttribute("partnerid", WxConstantConfig.mch_id);
			model.addAttribute("appid", WxConstantConfig.appid);
			model.addAttribute("signType", "MD5");
			model.addAttribute("timeStamp", timestamp);
			model.addAttribute("paySign", paySign);

		} catch (Throwable t) {
			log.error("get signature info error");
			t.printStackTrace();
		}
		return "/weixin/order/show";

	}

	public static String getRandomStringByLength(int length) {
		String base = "abcdefghijklmnopqrstuvwxyz0123456789";
		Random random = new Random();
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < length; i++) {
			int number = random.nextInt(base.length());
			sb.append(base.charAt(number));
		}
		return sb.toString();
	}

	private static String create_timestamp() {
		return Long.toString(System.currentTimeMillis() / 1000);
	}

	//通过xml 发给微信消息
	public static String setXml(String return_code, String return_msg) {
		SortedMap<String, String> parameters = new TreeMap<String, String>();
		parameters.put("return_code", return_code);
		parameters.put("return_msg", return_msg);
		return "<xml><return_code><![CDATA[" + return_code + "]]>" + "</return_code><return_msg><![CDATA[" + return_msg
				+ "]]></return_msg></xml>";
	}

	/**
	 * RSA签名
	 *
	 * @param content 待签名数据
	 * @param privateKey 商户私钥
	 * @param input_charset 编码格式
	 * @return 签名值
	 */

	public static String sign(String content, String privateKey, String input_charset) {
		try {
			PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
			KeyFactory keyf = KeyFactory.getInstance("RSA");
			PrivateKey priKey = keyf.generatePrivate(priPKCS8);

			java.security.Signature signature = java.security.Signature.getInstance(SIGN_ALGORITHMS);

			signature.initSign(priKey);
			signature.update(content.getBytes(input_charset));

			byte[] signed = signature.sign();

			return Base64.encode(signed);

		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	public String saveStuClass(Long oid, Long uid) {
		try {
			log.info(uid);
			log.info(oid);
			Students students = studentsService.getObjectById(uid);
			Order order = orderService.getObjectById(oid);
			log.info(students);
			order.setStatus(Order.COMPLETED);
			log.info(order);
			Long c = Long.valueOf(order.getCoupons());
			log.info(c);

			students.setClassId(order.getClassId());
			DrivingClass drivingClass = drivingClassService.getObjectById(order.getClassId());
			students.setSectionTwoDenominator(drivingClass.getSubjectTwoHour());
			students.setSectionThreeDenominator(drivingClass.getSubjectThreeHour());
			students.setCost(order.getActualPayment());
			students.setContract(order.getContract());
			students.setCityId(drivingClass.getCityId());
			students.setClassName(drivingClass.getName());
			Long currentTimeMillis = System.currentTimeMillis();
			order.setPayTime(currentTimeMillis.toString());
			students.setRegistrationDate(currentTimeMillis);
			students.setSectionThreeCoach(null);
			students.setSectionTwoCoach(null);
			students.setSectionThreeCoachId(null);
			students.setSectionTwoCoachId(null);
			students.setReceive(Students.RECEIVE_NO);
			//改为认证
			students.setCertification(Students.STATUS_ON);
			students.setSchoolId(order.getSchoolId());
			School school = schoolService.getObjectById(order.getSchoolId());
			students.setCost(order.getActualPayment());
			students.setSectionThreeDenominator(String.valueOf(drivingClass.getSubjectThreeHour()));
			students.setSectionTwoDenominator(String.valueOf(drivingClass.getSubjectTwoHour()));
			EnrollmentDetail enrollmentDetail = new EnrollmentDetail();
			BigDecimal DiscountedAmount = null;

			//设置哟与会金额
			Double dis = null;
			if (!order.getCoupons().equals("0")) {
				log.info(c);
				Card card = cardService.getObjectById(Long.valueOf(order.getCoupons()));
				log.info(Long.valueOf(order.getCoupons()));
				card.setStatus(3);
				log.info(card);
				CardType cardType = cardTypeService.getObjectById(card.getTid());
				DiscountedAmount = new BigDecimal(cardType.getValue());
				cardService.update(card);
				log.info("card update");
				log.info("dis" + DiscountedAmount);
				dis = DiscountedAmount.doubleValue();
			} else {
				DiscountedAmount = new BigDecimal(0);
				dis = DiscountedAmount.doubleValue();
			}

			enrollmentDetail.setCityId(order.getCityId());
			enrollmentDetail.setClassName(drivingClass.getName());
			enrollmentDetail.setCreateBy(uid);
			enrollmentDetail.setUpdateBy(uid);
			enrollmentDetail.setWithdrawId(-1l);
			enrollmentDetail.setSettlementId(-1l);

			enrollmentDetail.setExpensesId(-1l);
			enrollmentDetail.setName(students.getName());
			enrollmentDetail.setWithdrawStatus(EnrollmentDetail.NOT_WITHDRAW);
			enrollmentDetail.setMobile(students.getMobile());
			enrollmentDetail.setIDNo(students.getIdentification());
			enrollmentDetail.setName(students.getName());
			enrollmentDetail.setSchoolId(students.getSchoolId());
			enrollmentDetail.setSchoolName(school.getName());
			enrollmentDetail.setReceiveTime(-1l);
			enrollmentDetail.setPaymentWay(order.getPayWay());
			enrollmentDetail.setStatus(EnrollmentDetail.NOT_WITHDRAW);
			students.setSchool(school.getName());
			//设置原价
			BigDecimal cost = new BigDecimal(order.getCost());
			Double price = cost.doubleValue();
			cost.setScale(2, BigDecimal.ROUND_HALF_UP);
			enrollmentDetail.setPrice(cost);
			//设置用户支付

			Double pay = Calculation.sub(price, dis);
			BigDecimal payment_amount = new BigDecimal(pay).setScale(2, BigDecimal.ROUND_HALF_UP);
			enrollmentDetail.setPaymentAmount(payment_amount);
			log.info("实际支付" + payment_amount);
			//计算抽成
			Double costT = Double.valueOf(order.getCost());
			Double rate = Double.valueOf(school.getRate());
			Double hun = 100.0000;
			Double payy = Calculation.div(pay, hun);
			Double service_fee = Calculation.mul(payy, rate);
			BigDecimal serviceFee = new BigDecimal(service_fee).setScale(2, BigDecimal.ROUND_HALF_UP);
			enrollmentDetail.setServiceFee(serviceFee);
			log.info(serviceFee + "服务费");
			//设置驾校到账
			Double actual_income = Calculation.sub(pay, service_fee);
			BigDecimal actualIncome = new BigDecimal(actual_income).setScale(4, BigDecimal.ROUND_HALF_UP);
			;
			log.info(actualIncome + "daozhang ");
			enrollmentDetail.setActualIncome(actualIncome);

			students.setCost(payment_amount.toString());

			enrollmentDetail.setDiscountedAmount(DiscountedAmount);
			log.info("accc   " + actual_income + "serfe " + service_fee + "payment" + payment_amount + "price " + cost);
			log.info(enrollmentDetail);
			Record record = new Record();
			record.setSchoolId(school.getId());
			record.setSchoolName(school.getName());
			record.setAmount(actualIncome);
			record.setStatus(Record.INCOME);
			record.setUpdateBy(uid);
			record.setCreateBy(uid);

			log.info("----------");

			log.info(record);
			Long rid = recordService.insert(record);
			log.info("insert record success");
			enrollmentDetail.setIncomeId(rid);
			log.info(enrollmentDetail);
			enrollmentDetailService.insert(enrollmentDetail);
			log.info("insert enrollmentDetail success");
			log.info(students);

			log.info("update card success");
			studentsService.update(students);
			log.info("update stu success");
			orderService.update(order);
			log.info("update order success");

		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

}
