package com.ptteng.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.yi.nucleus.model.Students;
import com.ptteng.yi.nucleus.model.SubjectPractice;
import com.ptteng.yi.nucleus.service.SubjectPracticeService;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.Feedback;
import com.ptteng.yi.nucleus.service.FeedbackService;

/**
 * Feedback  crud
 * 
 * @author wangmeng
 * @Date 2018-1-4 13:43
 * 
 */
@Controller
public class FeedbackController {
    private static final Log log = LogFactory.getLog(FeedbackController.class);

    @Autowired
    private FeedbackService feedbackService;

    @Autowired
    private SubjectPracticeService subjectPracticeService;

    /**
     * 提交反馈（题目纠错，意见）
     * @param request
     * @param response
     * @param model
     * @param feedback
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/u/feedback", method = RequestMethod.POST)
    public String addFeedbackJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Feedback feedback) throws Exception {

        log.info("POST request url: /a/u/feedback, get parameter feedback: " + feedback);

        if (DataUtils.isNullOrEmpty(feedback)) {
            log.info("no this feedback");
            model.addAttribute("code", -14000);
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(feedback.getSource())) {
            log.info("parameter source is null or empty");
            model.addAttribute("code", -14001);
            return "/common/failure";
        }

        if (feedback.getSource() > Feedback.SOURCE_CORRECTION || feedback.getSource() < Feedback.SOURCE_STUDENT) {
            log.info("parameter source is illegal");
            model.addAttribute("code", -14002);
            return "/common/failure";
        }

        if (StringUtils.isEmpty(feedback.getDescription())) {
            log.info("parameter description is null or empty");
            model.addAttribute("code", -14005);
            return "/common/failure";
        }

        Students student = (Students) request.getAttribute("user");

        try {
            if (feedback.getSource() == Feedback.SOURCE_CORRECTION) {
                if (DataUtils.isNullOrEmpty(feedback.getSpId())) {
                    log.info("parameter spId is null or empty");
                    model.addAttribute("code", -14008);
                    return "/common/failure";
                } else {
                    SubjectPractice subjectPractice = subjectPracticeService.getObjectById(feedback.getSpId());

                    if (subjectPractice == null) {
                        log.info("no this subjectPractice");
                        model.addAttribute("code", -14009);
                        return "/common/failure";
                    }
                }

                if (DataUtils.isNullOrEmpty(feedback.getScenes())) {
                    log.info("parameter scenes is null or empty");
                    model.addAttribute("code", -14003);
                    return "/common/failure";
                }

                if (!feedback.getScenes().matches("([0-9,])*")) {
                    log.info("parameter scenes is illegal");
                    model.addAttribute("code", -14010);
                    return "/common/failure";
                }

                String[] scenes = feedback.getScenes().split(",");

                if (scenes.length > 8) {
                    log.info("parameter scenes length is illegal");
                    model.addAttribute("code", -14004);
                    return "/common/failure";
                }

                for (int i = 0; i < 9; i++) {
                    int count = 0;
                    for (int j = 0; j < scenes.length; j++) {
                        if (Integer.parseInt(scenes[j]) == i) {
                            count += 1;
                        }
                    }
                    if (count > 1) {
                        log.info("the value in scenes is duplicate");
                        model.addAttribute("code", -14007);
                        return "/common/failure";
                    }
                }

            } else {
                feedback.setScenes(Feedback.STRING_NULL_VALUE);
                feedback.setSpId(Feedback.LONG_NULL_VALUE);
            }

            if (feedback.getImgs() == null) {
                feedback.setImgs(Feedback.STRING_NULL_VALUE);
            }

            feedback.setId(null);

            if (feedback.getMobile() == null) {
                feedback.setMobile(Feedback.STRING_NULL_VALUE);
            }

            feedback.setUserMobile(student.getMobile());
            feedback.setName(student.getNick());
            feedback.setCreateBy(student.getId());
            feedback.setUpdateBy(student.getId());
            feedback.setCityId(student.getCityId());

            Long result = feedbackService.insert(feedback);
            log.info("insert feedback result: " + result);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add feedback error ");
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

}
