package com.ptteng.controller;

import java.io.File;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.pub.service.CitiesService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.Content;
import com.ptteng.yi.pub.service.ContentService;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/**
 * Content  crud
 * 
 * @author wangmeng
 * @Date 2017-12-20 13:43
 * 
 */
@Controller
public class ContentController {
    private static final Log log = LogFactory.getLog(ContentController.class);

    @Autowired
    private ContentService contentService;

    @Autowired
    private CitiesService citiesService;

    @Autowired
    private ImgStorageUtil imgStorageUtil;

    /**
     * 查看内容详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/content/{id}", method = RequestMethod.GET)
    public String getContentJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("GET request url : /a/content/{id}, get path variable id : " + id);
        try {
            Content content = contentService.getObjectById(id);
            log.info("get content data is " + content);

            if (DataUtils.isNullOrEmpty(content)) {
                log.info("no this content");
                model.addAttribute("code", -12000);
                return "/common/failure";
            }

            content.setReading(content.getReading() + 1);
            contentService.update(content);

            model.addAttribute("code", 0);

            model.addAttribute("content", content);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get content error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/yi-pub-service/content/json/contentDetailJson";
    }

    /**
     * 获取banner列表
     * @param request
     * @param response
     * @param model
     * @param cityId 城市id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/banner/list", method = RequestMethod.GET)
    public String getMultiBannerJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long cityId) throws Exception {

        log.info("GET request url: /a/banner/list, get parameter cityId: " + cityId);

        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("the parameter cityId is null or empty");
            model.addAttribute("code", -12001);
            return "/common/failure";
        }

        if (cityId < 1L) {
            log.info("parameter cityId is illegal");
            model.addAttribute("code", -13006);
            return "/common/failure";
        }

        try {
            List<Long> cityIds = citiesService.getCitiesIdsByCityid(cityId, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(cityIds)) {
                log.info("there is no city in DB");
                model.addAttribute("code", -12003);
                return "/common/failure";
            }

            List<Long> bannerIds = contentService.getContentIdsByTypeAndStatusAndAppAndCityId(Content.TYPE_BANNER,
                    Content.STATUS_ONLINE, Content.APP_STUDENT, cityId, 0, Integer.MAX_VALUE);
            log.info("get banner id list : " + bannerIds);

            if (CollectionUtils.isEmpty(bannerIds)) {
                model.addAttribute("contentList", new ArrayList());
                model.addAttribute("total", 0);
            } else {
                List<Content> bannerList = contentService.getObjectsByIds(bannerIds);
                log.info("get banner list size : " + bannerList.size());
                model.addAttribute("total", bannerList.size());

                model.addAttribute("contentList", bannerList);
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get banner list error");
            model.addAttribute("code", -100000);
        }

        return "/yi-pub-service/content/json/contentListJson";
    }

    /**
     * 获取news列表
     * 查询的时候要查学员端和通用的资讯
     * @param request
     * @param response
     * @param model
     * @param cityId 城市id
     * @param page
     * @param size
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/news/list", method = RequestMethod.GET)
    public String getMultiNewsJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long cityId, Integer page, Integer size) throws Exception {

        log.info("GET request url: /a/u/news/list, get parameter page : " + page + ", size : " + size + ", cityId: "
                + cityId);

        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("the parameter cityId is null or empty");
            model.addAttribute("code", -12001);
            return "/common/failure";
        }

        if (cityId < 1L) {
            log.info("parameter cityId is illegal");
            model.addAttribute("code", -13006);
            return "/common/failure";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            List<Long> cityIds = citiesService.getCitiesIdsByCityid(cityId, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(cityIds)) {
                log.info("there is no city in DB");
                model.addAttribute("code", -12003);
                return "/common/failure";
            }

            List<Integer> apps = new ArrayList<>();
            apps.add(Content.APP_STUDENT);
            apps.add(Content.APP_GENERAL);

            Map<String, Object> map = DynamicUtil.getContentListParams(Content.TYPE_NEWS, Content.STATUS_ONLINE, apps,
                    cityId, false);
            log.info("get query news list map : " + map);

            List<Long> newsIds = contentService.getIdsByDynamicCondition(Content.class, map, start, size);
            log.info("get news id list : " + newsIds);

            Integer total = contentService.getIdsByDynamicCondition(Content.class, map, 0, Integer.MAX_VALUE).size();

            if (CollectionUtils.isEmpty(newsIds)) {
                model.addAttribute("contentList", new ArrayList());
            } else {
                List<Content> newsList = contentService.getObjectsByIds(newsIds);
                log.info("get newsList data size is " + newsList.size());

                model.addAttribute("contentList", newsList);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get news list error, start is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/yi-pub-service/content/json/contentListJson";
    }

    /**
     * 获取免费试学
     * @param request
     * @param response
     * @param model
     * @param cityId 城市id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/experience", method = RequestMethod.GET)
    public String getExperienceJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long cityId) throws Exception {

        log.info("GET request url : /a/experience, get parameter cityId: " + cityId);

        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("the parameter cityId is null or empty");
            model.addAttribute("code", -12001);
            return "/common/failure";
        }

        if (cityId < 1L) {
            log.info("parameter cityId is illegal");
            model.addAttribute("code", -13006);
            return "/common/failure";
        }

        try {
            List<Long> cityIds = citiesService.getCitiesIdsByCityid(cityId, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(cityIds)) {
                log.info("there is no city in DB");
                model.addAttribute("code", -12003);
                return "/common/failure";
            }

            List<Long> ids = contentService.getContentIdsByTypeAndStatusAndAppAndCityId(Content.TYPE_EXPERIENCE,
                    Content.STATUS_ONLINE, Content.APP_STUDENT, cityId, 0, Integer.MAX_VALUE);
            log.info("get experience id : " + ids);

            if (!CollectionUtils.isEmpty(ids)) {
                Content content = contentService.getObjectById(ids.get(0));
                log.info("get experience content data is " + content);
                model.addAttribute("content", content);

//                Long time = (System.currentTimeMillis() - content.getCountAt()) % (content.getCountdown() * 24 * 60 * 60 * 1000);
//                Integer remainingSec = time.intValue();

                Long time = content.getCountAt() + content.getCountdown()*(24*60*60*1000);
                Long currentTime =System.currentTimeMillis();
                Long zero = time - currentTime;
                Integer remainingSec = zero.intValue();
                if(remainingSec<0){
                    remainingSec = 0;
                }


//                Long time = content.getUpdateAt() + content.getCountdown()*(24*60*60*1000);
//                Long currentTime =System.currentTimeMillis();
//                Long zero = time - currentTime;
//                Integer remainingSec = zero.intValue();
//                if(remainingSec<0){
//                    remainingSec = 0;
//                }


                model.addAttribute("remainingSec", remainingSec);
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get experience content error");
            model.addAttribute("code", -100000);

        }

        return "yi-pub-service/content/json/experienceJson";
    }

    /**
     * 无需修改名字的文件尾缀，<b>必须有序存放</b> <br>
     * 例如："apk" < "jpeg" < "jpg"
     */
    // 图片上传
    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) throws Exception {
        log.info("hello upload " + module);

        if (org.apache.commons.lang3.StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        log.info(file.getOriginalFilename());

        //Long uid = cookieUtil.getID(request, response);
        try {
            String type = file.getContentType();
            long size = file.getSize();
            log.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file.getOriginalFilename());
            String fileName = "";

            if ("apk".equals(extend)) {
                fileName = file.getOriginalFilename();
            } else {
                fileName = UUID.randomUUID().toString() + "." + extend;

            }

            log.info("new name is " + fileName);
            //  /data/temp/
            log.info("--------------------------------------------");
            String filePath = "/data/webs/yi-admin-web/excel/" + fileName;
            log.info(filePath);
            File tempPic = new File(filePath);
            if (tempPic.exists()) {
                log.info("temp file has exists, do not need to touch");
            }
            else {
                log.info("temp file not exists");
                tempPic.createNewFile();
            }
            String tempFileStr = fileName;
            log.info("--------------------------------------------");
            file.transferTo(tempPic);
            log.info("--------------------------------------------");

            String url;
            boolean flag = false;
            /**
             * flag
             * true:存储在服务器
             * false：存储在金山云
             * */
            if (flag) {
                 url = request.getScheme()+"://"+request.getServerName();

                log.info("url is " + url);
                log.info("excel file need to parse, temporarily not to delete");
                url = request.getScheme()+"://"+request.getServerName()+"/exceldownload/" + tempFileStr;
            }else {
                url = this.imgStorageUtil.imgStorage(null, module + "/" + fileName, filePath);
                log.info(module + module + "/" + fileName + filePath);
                log.info("--------------------------------------------");
                log.info(url);
                log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
                        + " access url is " + url);
                tempPic.delete();
                log.info(file.getOriginalFilename() + " delete success !");
            }
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            return "/common/success";
        }

    }

}
