package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.util.ImChatUtil;
import com.ptteng.util.ParametersUtil;
import com.ptteng.yi.pub.model.ImAccount;
import com.ptteng.yi.pub.service.ImAccountService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.*;

/**
 * @author himly
 */

@Controller
public class ImAccountController {

    private static final Logger log = Logger.getLogger(ImAccountController.class);

    @Autowired
    ImAccountService imAccountService;

    @Autowired
    ImChatUtil imChatUtil;

    /**
     * 通过条件获取网易云IM即时通讯accid及token
     * @param type 0 学员 1 教练 2 售前 3 售后 4 考务
     * @param id type为0时:
                    学员id
                 type为1时:
                    教练id
              type为2和3时:
                运营中心id
                type为4时:
                    驾校id
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/u/im/account", method = RequestMethod.GET)
    public String getAccountAndTokenByCondition(Integer type, Long[] id, Model model) {

        int length = null != id ? id.length : 0;
        log.info("type is==" + type + (0 != length ? "id is==" + Arrays.asList(id) : "id is zero"));

        boolean allParamIsNotNull = ParametersUtil.allParametersIsNotNull(type, id);
        if (!allParamIsNotNull || 0 == length) {
            log.info("parameters is null or id size is zero");
            model.addAttribute("code", -1000);
            return "yi-pub-service/imAccount/json/imAccountListJson";
        }

        Map<String, Object> sqlInfo = null;

        List<Long> listValues = Arrays.asList(id);
        List<Long> imAccountIds = null;
        List<ImAccount> imAccounts = null;
        try {
            sqlInfo = DynamicUtil.getImAccountIdByCondition(type, listValues);
            imAccountIds = null != sqlInfo
                    ? imAccountService.getIdsByDynamicCondition(ImAccount.class, sqlInfo, 0, Integer.MAX_VALUE)
                    : null;

            imAccounts = null != imAccountIds ? imAccountService.getObjectsByIds(imAccountIds) : null;
            log.info("imAccounts is==" + imAccountIds);

            //TODO 后期完善
            //过滤当前学员无权限查看的imAccount

            model.addAttribute("code", 0);
            model.addAttribute("data", imAccounts);
        } catch (Exception e) {
            log.error("has an error,see==" + e);
            model.addAttribute("code", -100000);
        }

        return "yi-pub-service/imAccount/json/imAccountListJson";
    }


    /**
     * 更新accid的token(相当于accid的密码)
     * @param accid 网易云IM即时通讯账号(简称accid)
     * @param model
     * @return
     */
    @RequestMapping(value = "/a/u/im/token", method = RequestMethod.PUT)
    public String updateTokenOfAccid(String accid, Model model) {

        log.info("accid is==" + accid);

        model.addAttribute("accid", accid);
        model.addAttribute("newToken", "456456456465dfsf");
        model.addAttribute("code", 0);

        return "yi-pub-service/imAccount/json/resultOfUpdateAccid";
    }
}
