/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.etl.job;

import com.ptteng.xqlease.common.model.ShoppingCart;
import com.ptteng.xqlease.common.service.ShoppingCartService;
import com.ptteng.xqlease.etl.util.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShoppingCartQuartz {
    private ShoppingCartService shoppingCartService;
    private static final Logger log = LoggerFactory.getLogger(ShoppingCartQuartz.class);

    public ShoppingCartService getShoppingCartService() {
        return this.shoppingCartService;
    }

    public void setShoppingCartService(ShoppingCartService shoppingCartService) {
        this.shoppingCartService = shoppingCartService;
    }

    public void updateTime() {
        int total = 0;
        boolean flag = true;
        int start = 0;
        try {
            while (flag) {
                log.info("start is" + start);
                List ids = this.shoppingCartService.getShoppingCartIds(Integer.valueOf(start), Integer.valueOf(3));
                log.info("ids number is :" + ids.size());
                List shoppingCartList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    shoppingCartList = this.shoppingCartService.getObjectsByIds(ids);
                }
                if (ids.size() < 100) {
                    log.info(start + "shopping cart < 100 flag = false");
                    flag = false;
                }
                Long threeDayLast = DateUtils.getThreeDaysLaterTime();
                log.info("three day last is" + threeDayLast);
                for (ShoppingCart shoppingCart : shoppingCartList) {
                    Long startLease = shoppingCart.getStartLeaseDate();
                    if (startLease >= threeDayLast) continue;
                    shoppingCart.setStartLeaseDate(threeDayLast);
                    this.shoppingCartService.update(shoppingCart);
                    ++total;
                }
                start += 3;
            }
            log.info("today update shopping cart number is " + total);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("==================updateTime error================");
        }
    }
}

