/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.etl.job;

import com.ptteng.xqlease.common.model.Brand;
import com.ptteng.xqlease.common.model.Goods;
import com.ptteng.xqlease.common.model.GoodsSku;
import com.ptteng.xqlease.common.model.RentOrders;
import com.ptteng.xqlease.common.model.Stock;
import com.ptteng.xqlease.common.service.BrandService;
import com.ptteng.xqlease.common.service.GoodsService;
import com.ptteng.xqlease.common.service.GoodsSkuService;
import com.ptteng.xqlease.common.service.RentOrdersService;
import com.ptteng.xqlease.common.service.StockService;
import com.ptteng.xqlease.etl.job.ShoppingCartQuartz;
import com.ptteng.xqlease.etl.util.DynamicUtil;
import com.ptteng.xqlease.etl.util.NumberingUtil;
import com.qding.common.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RentOrdersQuartz {
    private RentOrdersService rentOrdersService;
    private GoodsSkuService goodsSkuService;
    private GoodsService goodsService;
    private BrandService brandService;
    private StockService stockService;
    private static final Logger log = LoggerFactory.getLogger(ShoppingCartQuartz.class);

    public void setRentOrdersService(RentOrdersService rentOrdersService) {
        this.rentOrdersService = rentOrdersService;
    }

    public void setGoodsSkuService(GoodsSkuService goodsSkuService) {
        this.goodsSkuService = goodsSkuService;
    }

    public void setGoodsService(GoodsService goodsService) {
        this.goodsService = goodsService;
    }

    public void setBrandService(BrandService brandService) {
        this.brandService = brandService;
    }

    public void setStockService(StockService stockService) {
        this.stockService = stockService;
    }

    public void updateRentOrders() {
        log.info("============================update status quartz start==========================");
        boolean flag = true;
        int start = 0;
        try {
            long expectedTime = System.currentTimeMillis() - 86400000L;
            log.info("expectedTime is " + expectedTime);
            while (flag) {
                Map<String, Object> map = DynamicUtil.getRentOrdersByStatus(expectedTime, 10, false);
                List ids = this.rentOrdersService.getIdsByDynamicCondition(RentOrders.class, map, Integer.valueOf(start), Integer.valueOf(100));
                log.info("ids number is :" + ids.size());
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    List rentOrdersList = this.rentOrdersService.getObjectsByIds(ids);
                    HashMap<Long, Integer> skuIdAndAmount = new HashMap<Long, Integer>();
                    for (RentOrders rentOrders : rentOrdersList) {
                        rentOrders.setOrdersStatus(Integer.valueOf(60));
                        if (0 == rentOrders.getOrdersType()) continue;
                        if (skuIdAndAmount.get(rentOrders.getSkuId()) != null) {
                            Integer newSkuAmount = (Integer)skuIdAndAmount.get(rentOrders.getSkuId()) + rentOrders.getSkuAmount();
                            skuIdAndAmount.put(rentOrders.getSkuId(), newSkuAmount);
                            log.info("sku amount is " + newSkuAmount);
                            continue;
                        }
                        skuIdAndAmount.put(rentOrders.getSkuId(), rentOrders.getSkuAmount());
                        log.info("sku amount is " + rentOrders.getSkuAmount());
                    }
                    ArrayList skuIds = new ArrayList(skuIdAndAmount.keySet());
                    log.info("skuIds is " + skuIds);
                    List goodsSkuList = new ArrayList();
                    ArrayList<Stock> stockList = new ArrayList<Stock>();
                    List goodsList = new ArrayList();
                    if (CollectionUtils.isNotEmpty((Collection)ids)) {
                        goodsSkuList = this.goodsSkuService.getObjectsByIds(skuIds);
                        HashSet<Long> goodsIdsSet = new HashSet<Long>();
                        for (GoodsSku goodsSku : goodsSkuList) {
                            goodsIdsSet.add(goodsSku.getGoodsId());
                        }
                        ArrayList goodsIds = new ArrayList(goodsIdsSet);
                        log.info("goodsIds is " + goodsIds);
                        HashMap<Long, Goods> goodsMap = new HashMap<Long, Goods>();
                        HashSet<Long> brandSet = new HashSet<Long>();
                        if (DataUtils.isNotNullOrEmpty(goodsIds)) {
                            goodsList = this.goodsService.getObjectsByIds(goodsIds);
                            for (Goods goods : goodsList) {
                                goodsMap.put(goods.getId(), goods);
                                brandSet.add(goods.getBrandId());
                            }
                        }
                        ArrayList brandIds = new ArrayList(brandSet);
                        log.info("brandIds is " + brandIds);
                        List brandList = new ArrayList();
                        HashMap<Long, String> brandMap = new HashMap<Long, String>();
                        if (DataUtils.isNotNullOrEmpty(brandIds)) {
                            brandList = this.brandService.getObjectsByIds(brandIds);
                            for (Brand brand : brandList) {
                                brandMap.put(brand.getId(), brand.getBrandName());
                            }
                        }
                        HashMap<Long, Integer> goodsIdAndSkuMap = new HashMap<Long, Integer>();
                        for (GoodsSku goodsSku : goodsSkuList) {
                            Integer total = goodsSku.getStock() + (Integer)skuIdAndAmount.get(goodsSku.getId());
                            log.info("total is" + total + "old total is" + goodsSku.getStock() + "add amount" + skuIdAndAmount.get(goodsSku.getId()));
                            goodsSku.setStock(total);
                            Stock stock = new Stock();
                            stock.setStockNum(NumberingUtil.getNumbering(4));
                            stock.setGoodsName(((Goods)goodsMap.get(goodsSku.getGoodsId())).getGoodsName());
                            stock.setGoodsNum(((Goods)goodsMap.get(goodsSku.getGoodsId())).getGoodsNumber());
                            stock.setOrdersNum("");
                            stock.setBrandName((String)brandMap.get(((Goods)goodsMap.get(goodsSku.getGoodsId())).getBrandId()));
                            stock.setSku(goodsSku.getSkuNumber());
                            stock.setOperateAccount("\u7cfb\u7edf\u5b9a\u65f6");
                            stock.setOperateType(Integer.valueOf(80));
                            stock.setOperateAmount((Integer)skuIdAndAmount.get(goodsSku.getId()));
                            stock.setOperateTime(Long.valueOf(System.currentTimeMillis()));
                            stock.setStockAmount(total);
                            stock.setStockType(Integer.valueOf(1));
                            stock.setCreateBy(Long.valueOf(0L));
                            stock.setUpdateBy(Long.valueOf(0L));
                            stockList.add(stock);
                            if (DataUtils.isNullOrEmpty(goodsIdAndSkuMap.get(goodsSku.getGoodsId()))) {
                                goodsIdAndSkuMap.put(goodsSku.getGoodsId(), total);
                                continue;
                            }
                            Integer result = (Integer)goodsIdAndSkuMap.get(goodsSku.getGoodsId()) + total;
                            goodsIdAndSkuMap.put(goodsSku.getGoodsId(), result);
                        }
                        for (Goods goods : goodsList) {
                            goods.setStock((Integer)goodsIdAndSkuMap.get(goods.getId()));
                        }
                    }
                    this.goodsSkuService.updateList(goodsSkuList);
                    this.rentOrdersService.updateList(rentOrdersList);
                    this.stockService.insertList(stockList);
                    this.goodsService.updateList(goodsList);
                }
                if (ids.size() >= 100) continue;
                log.info(start + "rnetOrders cart < 100 flag = false");
                flag = false;
            }
            log.info("========================update status quartz end======================");
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("==================update status quartz error================");
        }
    }
}

