/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.etl.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.Bill;
import com.ptteng.xqlease.common.model.BillLog;
import com.ptteng.xqlease.common.model.RentOrders;
import com.ptteng.xqlease.common.model.RentOrdersDeviceRelation;
import com.ptteng.xqlease.common.service.BillLogService;
import com.ptteng.xqlease.common.service.BillService;
import com.ptteng.xqlease.common.service.GoodsSkuRentFeePeriodService;
import com.ptteng.xqlease.common.service.RentOrdersDeviceRelationService;
import com.ptteng.xqlease.common.service.RentOrdersService;
import com.ptteng.xqlease.etl.util.NumberingUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RentBillEtl {
    Log log = LogFactory.getLog(RentBillEtl.class);
    private static final long ONE_DAY_TO_MILLISECONDS = 86400000L;
    private long interval = 86400000L;
    private RentOrdersService rentOrdersService;
    private RentOrdersDeviceRelationService rentOrdersDeviceRelationService;
    private BillService billService;
    private BillLogService billLogService;
    private GoodsSkuRentFeePeriodService goodsSkuRentFeePeriodService;

    public void setRentOrdersService(RentOrdersService rentOrdersService) {
        this.rentOrdersService = rentOrdersService;
    }

    public RentOrdersService getRentOrdersService() {
        return this.rentOrdersService;
    }

    public RentOrdersDeviceRelationService getRentOrdersDeviceRelationService() {
        return this.rentOrdersDeviceRelationService;
    }

    public void setRentOrdersDeviceRelationService(RentOrdersDeviceRelationService rentOrdersDeviceRelationService) {
        this.rentOrdersDeviceRelationService = rentOrdersDeviceRelationService;
    }

    public BillService getBillService() {
        return this.billService;
    }

    public void setBillService(BillService billService) {
        this.billService = billService;
    }

    public BillLogService getBillLogService() {
        return this.billLogService;
    }

    public void setBillLogService(BillLogService billLogService) {
        this.billLogService = billLogService;
    }

    public GoodsSkuRentFeePeriodService getGoodsSkuRentFeePeriodService() {
        return this.goodsSkuRentFeePeriodService;
    }

    public void setGoodsSkuRentFeePeriodService(GoodsSkuRentFeePeriodService goodsSkuRentFeePeriodService) {
        this.goodsSkuRentFeePeriodService = goodsSkuRentFeePeriodService;
    }

    public void process() {
        this.log.info((Object)"process===============");
        try {
            List<RentOrders> rentOrdersList = this.getToGettingRentOrdersList();
            if (CollectionUtils.isNotEmpty(rentOrdersList)) {
                this.log.info((Object)("rentOrdersList=========" + rentOrdersList.size()));
                ArrayList<RentOrders> canGenerateBillOrdersList = new ArrayList<RentOrders>();
                for (RentOrders rentOrders : rentOrdersList) {
                    if (!this.canGenerateBill(rentOrders)) continue;
                    canGenerateBillOrdersList.add(rentOrders);
                }
                this.log.info((Object)("canGenerateBillOrdersList==========" + canGenerateBillOrdersList));
                for (RentOrders rentOrders : canGenerateBillOrdersList) {
                    this.log.info((Object)("can generate=====rentOrders===" + rentOrders.getId()));
                    this.generateBill(rentOrders);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateBill(RentOrders rentOrders) throws ServiceException, ServiceDaoException {
        this.log.info((Object)"generateBill==============");
        if (this.isShortRent(rentOrders)) {
            this.generateShortRentBill(rentOrders);
        } else {
            this.generateLongRentBill(rentOrders);
        }
        rentOrders.setOrdersStatus(Integer.valueOf(40));
        rentOrders.setUpdateBy(Long.valueOf(1L));
        this.rentOrdersService.update(rentOrders);
    }

    private void generateLongRentBill(RentOrders rentOrders) throws ServiceException, ServiceDaoException {
        this.log.info((Object)"generateLongRentBill=============");
        int periodMonthes = 0;
        switch (rentOrders.getPayMode()) {
            case 10: {
                periodMonthes = 1;
                break;
            }
            case 20: {
                periodMonthes = 3;
                break;
            }
            case 30: {
                periodMonthes = 6;
                break;
            }
            case 40: {
                periodMonthes = 12;
                break;
            }
            case 50: {
                periodMonthes = 24;
                break;
            }
            case 60: {
                periodMonthes = 36;
            }
        }
        List<RentOrdersDeviceRelation> rentOrdersDeviceRelationList = this.getRentOrdersContainsDevices(rentOrders);
        if (CollectionUtils.isNotEmpty(rentOrdersDeviceRelationList)) {
            this.log.info((Object)"generateOtherPeriodsBill============");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sku_id ", rentOrders.getSkuId());
            params.put("@query", "id");
            params.put("@table", "goods_sku_rent_fee_period");
            String rentFeeStr = rentOrders.getRentFee();
            List<String> rentFeeListTemp = Arrays.asList(rentFeeStr.substring(1, rentFeeStr.length() - 1).split(","));
            this.log.info((Object)("rentFeeListTemp============" + rentFeeListTemp));
            ArrayList<BigDecimal> rentFeeList = new ArrayList<BigDecimal>();
            for (int i = 0; i < rentFeeListTemp.size(); ++i) {
                rentFeeList.add(new BigDecimal(rentFeeListTemp.get(i)));
            }
            this.log.info((Object)("rentFeeList===========" + rentFeeList));
            int payMode = rentOrders.getPayMode();
            int rentPeriod = rentOrders.getRentPeriod();
            Map<Integer, BigDecimal> periodRentFeeMap = this.calculatePeriodRentFee(rentPeriod, payMode, rentFeeList);
            this.log.info((Object)("periodRentFeeMap==========" + periodRentFeeMap));
            ArrayList<Bill> billList = new ArrayList<Bill>();
            for (RentOrdersDeviceRelation rentOrdersDeviceRelation : rentOrdersDeviceRelationList) {
                Calendar rentStartDate = Calendar.getInstance();
                rentStartDate.setTime(new Date(rentOrders.getRentStart()));
                this.log.info((Object)("rentStartDate=========" + rentStartDate));
                for (int i = 0; i < periodRentFeeMap.keySet().size(); ++i) {
                    this.log.info((Object)("i=============" + i));
                    Bill bill = new Bill();
                    bill.setParentBillId(Long.valueOf(0L));
                    bill.setUid(rentOrders.getUid());
                    bill.setBillNum(NumberingUtil.getNumbering(8));
                    bill.setRentOid(rentOrders.getId());
                    bill.setDeviceRelationId(rentOrdersDeviceRelation.getId());
                    bill.setDeviceNum(rentOrdersDeviceRelation.getDeviceNum());
                    bill.setDeviceSerialNum(rentOrdersDeviceRelation.getDeviceSerialNum());
                    bill.setUpdateBy(Long.valueOf(1L));
                    bill.setCreateBy(Long.valueOf(1L));
                    bill.setBillType(Integer.valueOf(10));
                    bill.setRentOrdersNum(rentOrders.getOrdersNumber());
                    bill.setSaledOrdersNum("");
                    bill.setPayAccount("");
                    bill.setRentFee(periodRentFeeMap.get(i + 1));
                    bill.setSaledFee(new BigDecimal(0.0));
                    bill.setSecurityFee(rentOrders.getSecurityFee().multiply(new BigDecimal(periodMonthes)));
                    bill.setDiscountFee(rentOrders.getDiscountFee().multiply(new BigDecimal(periodMonthes)));
                    bill.setTotalFee(bill.getRentFee().add(bill.getSecurityFee()).subtract(bill.getDiscountFee()));
                    bill.setSaledOid(Long.valueOf(0L));
                    if (i == 0) {
                        bill.setPayStatus(Integer.valueOf(2));
                        bill.setBillCreateStatus(Integer.valueOf(2));
                        bill.setPayMethod(rentOrders.getPayMethod());
                        bill.setApplyTicketStatus(Integer.valueOf(1));
                    } else {
                        bill.setPayStatus(Integer.valueOf(1));
                        bill.setBillCreateStatus(Integer.valueOf(1));
                        bill.setPayMethod(Integer.valueOf(0));
                        bill.setApplyTicketStatus(Integer.valueOf(0));
                    }
                    bill.setPeriodStart(Long.valueOf(rentStartDate.getTimeInMillis()));
                    rentStartDate.add(2, periodMonthes);
                    bill.setPeriodEnd(Long.valueOf(rentStartDate.getTimeInMillis()));
                    bill.setPeriodNum(Integer.valueOf(i + 1));
                    billList.add(bill);
                }
                rentOrdersDeviceRelation.setDeviceStatus(RentOrdersDeviceRelation.IN_LEASING);
                rentOrdersDeviceRelation.setUpdateBy(Long.valueOf(1L));
            }
            this.log.info((Object)("billList===========" + billList));
            List resultBillList = this.billService.insertList(billList);
            this.log.info((Object)("insert long bill result========" + resultBillList.size()));
            this.rentOrdersDeviceRelationService.updateList(rentOrdersDeviceRelationList);
            ArrayList<BillLog> billLogList = new ArrayList<BillLog>();
            if (CollectionUtils.isNotEmpty((Collection)resultBillList)) {
                this.generateBillLogs(resultBillList, billLogList);
                this.log.info((Object)("billLogList==========" + billLogList));
                this.billLogService.insertList(billLogList);
            }
        } else {
            this.log.info((Object)("rent orders has no device=====rent oid is======" + rentOrders.getId()));
        }
    }

    private Map<Integer, BigDecimal> calculatePeriodRentFee(int rentPeriod, int payMode, List<BigDecimal> rentFeeList) {
        HashMap<Integer, BigDecimal> periodRentFeeMap = new HashMap<Integer, BigDecimal>();
        switch (rentPeriod) {
            case 100: {
                int i;
                this.log.info((Object)"ONE_YEAR ========");
                if (payMode == 10) {
                    this.log.info((Object)"PAY_MODE_MONTH ========");
                    for (i = 0; i < 12; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(0));
                    }
                }
                if (payMode == 20) {
                    this.log.info((Object)"PAY_MODE_SEASON ========");
                    for (i = 0; i < 4; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(0).multiply(new BigDecimal(3)));
                    }
                }
                if (payMode == 30) {
                    this.log.info((Object)"PAY_MODE_HALF_YEAR ========");
                    for (i = 0; i < 2; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(0).multiply(new BigDecimal(6)));
                    }
                }
                if (payMode != 40) break;
                this.log.info((Object)"PAY_MODE_1_YEAR ========");
                for (i = 0; i < 1; ++i) {
                    periodRentFeeMap.put(i + 1, rentFeeList.get(0).multiply(new BigDecimal(12)));
                }
                break;
            }
            case 110: {
                int i;
                this.log.info((Object)"TWO_YEAR======");
                if (payMode == 10) {
                    this.log.info((Object)"PAY_MODE_MONTH=========");
                    for (i = 0; i < 24; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i / 12));
                    }
                }
                if (payMode == 20) {
                    this.log.info((Object)"PAY_MODE_SEASON=========");
                    for (i = 0; i < 8; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i / 4).multiply(new BigDecimal(3)));
                    }
                }
                if (payMode == 30) {
                    this.log.info((Object)"PAY_MODE_HALF_YEAR=========");
                    for (i = 0; i < 4; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i / 2).multiply(new BigDecimal(6)));
                    }
                }
                if (payMode == 40) {
                    this.log.info((Object)"PAY_MODE_1_YEAR=========");
                    for (i = 0; i < 2; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i).multiply(new BigDecimal(12)));
                    }
                }
                if (payMode != 50) break;
                this.log.info((Object)"PAY_MODE_2_YEAR=========");
                periodRentFeeMap.put(1, rentFeeList.get(0).multiply(new BigDecimal(24)));
                break;
            }
            case 120: {
                int i;
                this.log.info((Object)"THREE_YEAR=========");
                if (payMode == 10) {
                    this.log.info((Object)"PAY_MODE_MONTH=========");
                    for (i = 0; i < 36; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i / 12));
                    }
                }
                if (payMode == 20) {
                    this.log.info((Object)"PAY_MODE_SEASON=========");
                    for (i = 0; i < 12; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i / 4).multiply(new BigDecimal(3)));
                    }
                }
                if (payMode == 30) {
                    this.log.info((Object)"PAY_MODE_HALF_YEAR=========");
                    for (i = 0; i < 6; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i / 2).multiply(new BigDecimal(6)));
                    }
                }
                if (payMode == 40) {
                    this.log.info((Object)"PAY_MODE_1_YEAR=========");
                    for (i = 0; i < 3; ++i) {
                        periodRentFeeMap.put(i + 1, rentFeeList.get(i).multiply(new BigDecimal(12)));
                    }
                }
                if (payMode != 60) break;
                this.log.info((Object)"PAY_MODE_3_YEAR=========");
                periodRentFeeMap.put(1, rentFeeList.get(0).multiply(new BigDecimal(36)));
                break;
            }
        }
        return periodRentFeeMap;
    }

    private void generateShortRentBill(RentOrders rentOrders) throws ServiceException, ServiceDaoException {
        this.log.info((Object)"generateShortRentBill===========");
        List<RentOrdersDeviceRelation> rentOrdersDeviceRelationList = this.getRentOrdersContainsDevices(rentOrders);
        if (rentOrdersDeviceRelationList != null && rentOrdersDeviceRelationList.size() > 0) {
            ArrayList<Bill> billList = new ArrayList<Bill>();
            for (int i = 0; i < rentOrdersDeviceRelationList.size(); ++i) {
                Bill bill = new Bill();
                bill.setParentBillId(Long.valueOf(0L));
                bill.setUid(rentOrders.getUid());
                bill.setBillNum(NumberingUtil.getNumbering(8));
                bill.setRentOid(rentOrders.getId());
                bill.setDeviceRelationId(rentOrdersDeviceRelationList.get(i).getId());
                bill.setDeviceNum(rentOrdersDeviceRelationList.get(i).getDeviceNum());
                bill.setDeviceSerialNum(rentOrdersDeviceRelationList.get(i).getDeviceSerialNum());
                bill.setBillCreateStatus(Integer.valueOf(2));
                bill.setPayStatus(Integer.valueOf(2));
                bill.setPayMethod(rentOrders.getPayMethod());
                bill.setBillType(Integer.valueOf(10));
                bill.setUpdateBy(Long.valueOf(1L));
                bill.setCreateBy(Long.valueOf(1L));
                bill.setSaledOid(Long.valueOf(0L));
                bill.setApplyTicketStatus(Integer.valueOf(1));
                bill.setRentFee(rentOrders.getFirstRentFee());
                bill.setSecurityFee(rentOrders.getSecurityFee());
                bill.setDiscountFee(rentOrders.getDiscountFee());
                bill.setSaledFee(new BigDecimal(0.0));
                bill.setTotalFee(rentOrders.getFirstRentFee().add(rentOrders.getSecurityFee()).subtract(rentOrders.getDiscountFee()));
                bill.setRentOrdersNum(rentOrders.getOrdersNumber());
                bill.setSaledOrdersNum("");
                bill.setPayAccount("");
                bill.setPeriodStart(rentOrders.getRentStart());
                bill.setPeriodEnd(Long.valueOf(rentOrders.getRentStart() + (long)rentOrders.getRentPeriod().intValue() * 86400000L));
                bill.setPeriodNum(Integer.valueOf(1));
                billList.add(bill);
                rentOrdersDeviceRelationList.get(i).setDeviceStatus(RentOrdersDeviceRelation.IN_LEASING);
                rentOrdersDeviceRelationList.get(i).setUpdateBy(Long.valueOf(1L));
            }
            this.log.info((Object)("billList===========" + billList));
            List resultBillList = this.billService.insertList(billList);
            this.log.info((Object)("insert short bill result========" + resultBillList.size()));
            this.rentOrdersDeviceRelationService.updateList(rentOrdersDeviceRelationList);
            ArrayList<BillLog> billLogList = new ArrayList<BillLog>();
            if (CollectionUtils.isNotEmpty((Collection)resultBillList)) {
                this.generateBillLogs(resultBillList, billLogList);
                List billLogs = this.billLogService.insertList(billLogList);
                this.log.info((Object)("insert short bill log result========" + billLogs.size()));
            }
        }
    }

    private void generateBillLogs(List<Bill> resultBillList, List<BillLog> billLogList) {
        for (int i = 0; i < resultBillList.size(); ++i) {
            BillLog billLog = new BillLog();
            billLog.setBillLogType(Integer.valueOf(1));
            billLog.setBid(resultBillList.get(i).getId());
            billLog.setRemark("");
            billLog.setCreateBy(Long.valueOf(1L));
            billLog.setUpdateBy(Long.valueOf(1L));
            billLogList.add(billLog);
        }
    }

    private List<RentOrdersDeviceRelation> getRentOrdersContainsDevices(RentOrders rentOrders) throws ServiceException, ServiceDaoException {
        this.log.info((Object)"getRentOrdersContainsDevices===========");
        List rentOrdersDeviceRelationIdList = this.rentOrdersDeviceRelationService.getRentOrdersDeviceRelationIdsByOid(rentOrders.getId(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        System.out.println("rentOrdersDeviceRelationIdList============" + rentOrdersDeviceRelationIdList);
        if (CollectionUtils.isNotEmpty((Collection)rentOrdersDeviceRelationIdList)) {
            return this.rentOrdersDeviceRelationService.getObjectsByIds(rentOrdersDeviceRelationIdList);
        }
        return null;
    }

    private boolean isShortRent(RentOrders rentOrders) {
        this.log.info((Object)"isShortRent===========");
        return rentOrders.getRentPeriod() <= 30;
    }

    private boolean canGenerateBill(RentOrders rentOrders) {
        this.log.info((Object)"canGenerateBill===========");
        if (rentOrders.getRentStart() <= System.currentTimeMillis()) {
            return rentOrders.getOrdersStatus() == 30;
        }
        return false;
    }

    public List<RentOrders> getToGettingRentOrdersList() throws ServiceException, ServiceDaoException {
        this.log.info((Object)"getToGettingRentOrdersList===========");
        HashMap<String, Object> rentIdListParam = new HashMap<String, Object>();
        rentIdListParam.put("@table", "rent_orders");
        rentIdListParam.put("orders_type", 1);
        rentIdListParam.put("orders_status", 30);
        List rentOidList = this.rentOrdersService.getIdsByDynamicCondition(RentOrders.class, rentIdListParam, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        this.log.info((Object)("rentOidList===========" + rentOidList));
        if (CollectionUtils.isNotEmpty((Collection)rentOidList)) {
            List toGettingRentOrdersList = this.rentOrdersService.getObjectsByIds(rentOidList);
            System.out.println("toGettingRentOrdersList==========" + toGettingRentOrdersList.size());
            return toGettingRentOrdersList;
        }
        return null;
    }
}

