package com.ptteng.score.home.controller;

import com.ptteng.score.home.constant.ConstantItem;
import com.ptteng.score.home.model.DailyAttendance;
import com.ptteng.score.home.model.ScoreLog;
import com.ptteng.score.home.responseStructure.ResponseInfo;
import com.ptteng.score.home.service.DailyAttendanceService;
import com.ptteng.score.home.service.ScoreLogService;
import com.ptteng.score.home.util.DateUtil;
import com.ptteng.score.home.util.DynamicSQLUtil;
import com.ptteng.score.home.util.PageUtil;
import com.google.gson.Gson;

import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import com.ptteng.score.home.model.AttendanceLog;
import com.ptteng.score.home.model.Staff;
import com.ptteng.score.home.service.AttendanceLogService;
import com.ptteng.score.home.service.StaffService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

import static com.ptteng.score.home.constant.ConstantItem.*;

/**
 * AttendanceLog  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class AttendanceLogController {
    private static final Log log = LogFactory.getLog(AttendanceLogController.class);

    @Autowired
    private AttendanceLogService attendanceLogService;

    @Autowired
    private StaffService staffService;

    @Autowired
    private ScoreLogService scoreLogService;

    @Autowired
    private DailyAttendanceService dailyAttendanceService;

    @Autowired
    private CookieUtil cookieUtil;


    /**
     * 1.签到
     *
     * @param request
     * @param response
     * @param model
     * @param attendanceLog
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/clock", method = RequestMethod.POST)
    public String addAttendanceLogJson(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model,
                                       @RequestBody AttendanceLog attendanceLog) throws Exception {

        log.info("服务器时间：" + System.currentTimeMillis());
        log.info("打卡时间: " + attendanceLog.getTime());

        if (DataUtils.isNullOrEmpty(attendanceLog)) {
            log.info("get attendanceLog is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("add attendanceLog : attendanceLog= " + attendanceLog);



        ScoreLog scoreLog = new ScoreLog();
        Staff staff = null;
        Long time = 0L;
        time = DateUtil.timeUtil(ConstantItem.ONE);
        Map<String, Object> param = null;


        try {
            param = DynamicSQLUtil.getAttendanceLog(attendanceLog.getStaffId());
            List<Long> ids = attendanceLogService.getIdsByDynamicCondition(AttendanceLog.class, param,  ConstantItem.ZERO, Integer.MAX_VALUE);
            if (ids.size() >= ConstantItem.TWO) {
                model.addAttribute("code", 0);
                model.addAttribute("message", "今天已经打卡");
                return "data/log";
            }

            staff = staffService.getObjectById(attendanceLog.getStaffId());
            DailyAttendance dailyAttendance = dailyAttendanceService.getObjectById(ConstantItem.CLOCK);


            switch (attendanceLog.getAttendanceType()) {
                //内勤上班
                case 1:
                    //正常
                    if (ConstantItem.ZEROL <= dailyAttendance.getWorkTime()) {
                        dailyAttendance.setWorkTime(dailyAttendance.getWorkTime() + ConstantItem.TIME);
                    } else {
                        dailyAttendance.setWorkTime(ConstantItem.TIME - dailyAttendance.getWorkTime());
                    }

                    if (ConstantItem.ZEROL <= dailyAttendance.getClosingTime()) {
                        dailyAttendance.setClosingTime(dailyAttendance.getClosingTime() + ConstantItem.TIME);
                    } else {
                        dailyAttendance.setClosingTime(ConstantItem.TIME - dailyAttendance.getClosingTime());
                    }

                    if (attendanceLog.getTime() <= dailyAttendance.getWorkTime() && attendanceLog.getTime() > dailyAttendance.getWorkTime() - ConstantItem.MINUTES) {

                        //考勤状态见约定
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_RIGHT);

                        staff.setAddScore(staff.getAddScore() + dailyAttendance.getNormalScore());
                        staff.setTotalScore(staff.getTotalScore() + dailyAttendance.getNormalScore());


                        //积分记录添加
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OFFICE_WORK_ATTENDANCE);
                        scoreLog.setScoreChange("+" + dailyAttendance.getNormalScore());
                        //积分类型见约定
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);
                        model.addAttribute("message", "内勤上班打卡获得" + dailyAttendance.getNormalScore() + "分");


                        //早到  上班时间前40分钟打卡为早到
                    } else if (attendanceLog.getTime() <= dailyAttendance.getWorkTime() - ConstantItem.MINUTES) {
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_ARRIVE_EARLY);
                        staff.setTotalScore(staff.getTotalScore() + dailyAttendance.getMorningScore());
                        staff.setAddScore(staff.getAddScore() + dailyAttendance.getMorningScore());
                        //积分记录添加
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OFFICE_EARLY_TO_SIGN);
                        scoreLog.setScoreChange("+" + dailyAttendance.getMorningScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);
                        model.addAttribute("message", "上班早到奖励" + dailyAttendance.getMorningScore() + "分");

                        //迟到  大于上班时间小于下班时间 按迟到
                    } else if (attendanceLog.getTime() > dailyAttendance.getWorkTime() && attendanceLog.getTime() < dailyAttendance.getClosingTime()) {

                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_LATE);

                        staff.setSubScore(staff.getSubScore() + dailyAttendance.getLateScore());
                        staff.setTotalScore(staff.getTotalScore() - dailyAttendance.getLateScore());

                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OFFICE_WORK_LATE);
                        scoreLog.setScoreChange("-" + dailyAttendance.getLateScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);
                        model.addAttribute("message", "上班迟到减去" + dailyAttendance.getLateScore() + "分");
                    } else if (attendanceLog.getTime() > dailyAttendance.getClosingTime()) {
                        //缺勤 大于上班时间
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_ABSENCE);

                        staff.setTotalScore(staff.getTotalScore() - dailyAttendance.getAbsenceScore());
                        staff.setSubScore(staff.getSubScore() + dailyAttendance.getAbsenceScore());

//                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OFFICE_WORK_ABSENTEEISM);
                        scoreLog.setScoreChange("-" + dailyAttendance.getAbsenceScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);
                        model.addAttribute("message", "上班缺勤减去" + dailyAttendance.getAbsenceScore() + "分");
                    }
                    break;
                //内勤下班
                case 2:
                    //正常 大于下班时间，小于开始加班时间
                    if (ConstantItem.ZEROL <= dailyAttendance.getClosingTime()) {
                        dailyAttendance.setClosingTime(dailyAttendance.getClosingTime() + ConstantItem.TIME);
                    } else {
                        dailyAttendance.setClosingTime(ConstantItem.TIME - dailyAttendance.getClosingTime());
                    }


                    if (attendanceLog.getTime() >= dailyAttendance.getClosingTime() && attendanceLog.getTime() < dailyAttendance.getClosingTime() + ConstantItem.HOUR) {
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_RIGHT);

                        staff.setAddScore(staff.getAddScore() + dailyAttendance.getNormalScore());
                        staff.setTotalScore(staff.getTotalScore() + dailyAttendance.getNormalScore());

                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(CLOCK_OUT);
                        scoreLog.setScoreChange("+" + dailyAttendance.getNormalScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);

                        model.addAttribute("message", "内勤下班打卡获得" + dailyAttendance.getNormalScore() + "分");
                        //早退
                    } else if (attendanceLog.getTime() < dailyAttendance.getClosingTime()) {
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_LEAVE_EARLY);

                        staff.setSubScore(staff.getSubScore() + dailyAttendance.getLeftEarlyScore());
                        staff.setTotalScore(staff.getTotalScore() - dailyAttendance.getLeftEarlyScore());

                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(EARLY);
                        scoreLog.setScoreChange("-" + dailyAttendance.getLeftEarlyScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);
                        model.addAttribute("message", "早退减去" + dailyAttendance.getLeftEarlyScore() + "分");

                        //加班
                    } else if (attendanceLog.getTime() >= dailyAttendance.getClosingTime() + ConstantItem.HOUR && attendanceLog.getTime() < time - ConstantItem.ONE_MINUTES) {
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_OVERTIME);

                        staff.setAddScore(staff.getAddScore() + dailyAttendance.getOvertimeScore());
                        staff.setTotalScore(staff.getTotalScore() + dailyAttendance.getOvertimeScore());

                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OVERTIME);
                        scoreLog.setScoreChange("+" + dailyAttendance.getOvertimeScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);

                        model.addAttribute("message", "内勤加班打卡获得" + dailyAttendance.getOvertimeScore() + "分");
                    }


                    break;
                //外勤上班
                case 3:
                    //外勤没有迟到、早到、早退、加班限制
                    if (ConstantItem.ZEROL <= dailyAttendance.getOutsideWorkTime()) {
                        dailyAttendance.setOutsideWorkTime(dailyAttendance.getOutsideWorkTime() + ConstantItem.TIME);
                    } else {
                        dailyAttendance.setOutsideWorkTime(ConstantItem.TIME - dailyAttendance.getOutsideWorkTime());
                    }
                    if (ConstantItem.ZEROL <= dailyAttendance.getOutsideClosingTime()) {
                        dailyAttendance.setOutsideClosingTime(dailyAttendance.getOutsideClosingTime() + ConstantItem.TIME);
                    } else {
                        dailyAttendance.setOutsideClosingTime(ConstantItem.TIME - dailyAttendance.getOutsideClosingTime());
                    }

                    if (attendanceLog.getTime() > dailyAttendance.getOutsideClosingTime()) {
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_ABSENCE);

                        staff.setTotalScore(staff.getTotalScore() - dailyAttendance.getAbsenceScore());
                        staff.setSubScore(staff.getSubScore() + dailyAttendance.getAbsenceScore());

                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OUTSIDE_OFFICE_WORK_ABSENTEEISM);
                        scoreLog.setScoreChange("-" + dailyAttendance.getAbsenceScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);
                        model.addAttribute("message", "上班缺勤减去" + dailyAttendance.getAbsenceScore() + "分");


                    } else if (attendanceLog.getTime() <= dailyAttendance.getOutsideWorkTime() || attendanceLog.getTime() > dailyAttendance.getOutsideWorkTime()) {
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_RIGHT);

                        staff.setAddScore(staff.getAddScore() + dailyAttendance.getOutsideWorkTimeScore());
                        staff.setTotalScore(staff.getTotalScore() + dailyAttendance.getOutsideWorkTimeScore());

                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OUTSIDE_OFFICE_WORK_ATTENDANCE);
                        scoreLog.setScoreChange("+" + dailyAttendance.getOutsideWorkTimeScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);
                        model.addAttribute("message", "外勤上班打卡获得" + dailyAttendance.getOutsideWorkTimeScore() + "分");
                    }

                    break;
                //外勤下班
                case 4:
                    //正常
                    if (ConstantItem.ZEROL <= dailyAttendance.getOutsideClosingTime()) {
                        dailyAttendance.setOutsideClosingTime(dailyAttendance.getOutsideClosingTime() + ConstantItem.TIME);
                    } else {
                        dailyAttendance.setOutsideClosingTime(ConstantItem.TIME - dailyAttendance.getOutsideClosingTime());
                    }

                    if (attendanceLog.getTime() <= dailyAttendance.getOutsideClosingTime() || attendanceLog.getTime() > dailyAttendance.getOutsideClosingTime()) {
                        attendanceLog.setAttendanceStatus(ConstantItem.STATUS_RIGHT);

                        staff.setAddScore(staff.getAddScore() + dailyAttendance.getOutsideClosingTimeScore());
                        staff.setTotalScore(staff.getTotalScore() + dailyAttendance.getOutsideClosingTimeScore());

                        //积分添加记录
                        scoreLog.setStaffId(staff.getId());
                        scoreLog.setCreateBy(staff.getId());
                        scoreLog.setUpdateBy(staff.getId());
                        scoreLog.setScoreReason(OUTSIDE_CLOCK_OUT);
                        scoreLog.setScoreChange("+" + dailyAttendance.getOutsideClosingTimeScore());
                        scoreLog.setScoreType(ConstantItem.ATTENDANCE);

                        model.addAttribute("message", "外勤下班打卡获得" + dailyAttendance.getOutsideClosingTimeScore() + "分");
                    }

                    break;
                default:

            }


            attendanceLog.setCreateBy(attendanceLog.getStaffId());
            attendanceLog.setUpdateBy(attendanceLog.getStaffId());
            Long id = attendanceLogService.insert(attendanceLog);
            log.info("add attendanceLog id is: " + id);
            boolean result = staffService.update(staff);
            log.info("update id: " + staff.getId() + " result is: " + result);
            scoreLog.setSpecialId(id);
            Long scoreLogId = scoreLogService.insert(scoreLog);
            log.info("add scoreLogId is: " + scoreLogId);


            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add attendanceLog error ");
            model.addAttribute("code", -6002);
        }

        return "/data/log";
    }


    /**
     * 2.获取考勤参数
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/clockset/{id}", method = RequestMethod.GET)
    public String getDailyAttendanceJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {
        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get data : id= " + id);
        try {
            DailyAttendance dailyAttendance = dailyAttendanceService.getObjectById(id);
            log.info("get dailyAttendance data is " + dailyAttendance);

            model.addAttribute("code", 0);

            model.addAttribute("dailyAttendance", dailyAttendance);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get dailyAttendance error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/json/dailyAttendance/json/dailyAttendanceDetailJson";
    }


    /**
     * 3.获取考勤记录
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/clock", method = RequestMethod.GET)
    public String getMultiAttendanceLogJson(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model/*, Integer attendanceType*/)
            throws Exception {

//        log.info("get attendanceType is:" + attendanceType);

        Map<String, Object> param = null;
        List<Long> ids = null;
        List<AttendanceLog> list = null;
        Long adminId = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));

        try {
//            if (null == attendanceType) {
//                log.error("get attendanceType is null ");
//                model.addAttribute("code", -1000);
//            }
            param = DynamicSQLUtil.getAttendanceLogList(adminId/*, attendanceType*/);

            ids = attendanceLogService.getIdsByDynamicCondition(AttendanceLog.class, param, 0, Integer.MAX_VALUE);
            log.info("get ids is: " + ids.size());

            list = attendanceLogService.getObjectsByIds(ids);
            log.info("get list.size is: " + list.size());

            model.addAttribute("code", 0);

            model.addAttribute("list", list);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get attendanceLog error,id is  ");
            t.printStackTrace();
            model.addAttribute("code", -100000);
        }

        return "/json/attendanceLog/json/attendanceLogListJson";
    }


    /**
     * 4.考勤记录详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param scoreType
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/clock/{id}", method = RequestMethod.GET)
    public String getClockJson(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id, Integer scoreType) throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            log.info("get id is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }

        log.info("param scoreLogId is: " + id);
        if (DataUtils.isNullOrEmpty(scoreType)) {
            log.info("get scoreType is null！");
            model.addAttribute("code", -1000);
            return "common/fail";
        }
        log.info("get scoreType is: " + scoreType);


        Map<String, Object> param = null;
        try {


            AttendanceLog attendanceLog = attendanceLogService.getObjectById(id);
            if (attendanceLog == null) {

                model.addAttribute("code", -9004);
                return "common/fail";
            }

            Staff staff = staffService.getObjectById(attendanceLog.getStaffId());
            log.info("get staffId is: " + staff.getId());


            param = DynamicSQLUtil.getScoreList(id, scoreType);

            List<Long> ids = scoreLogService.getIdsByDynamicCondition(ScoreLog.class, param, 0, Integer.MAX_VALUE);
            log.info("get ids is: " + ids.size());
            ScoreLog scoreLog = scoreLogService.getObjectById(ids.get(0));
            log.info("get scoreLog is: " + scoreLog);


            model.addAttribute("staff", staff);
            model.addAttribute("attendanceLog", attendanceLog);
            model.addAttribute("scoreLog", scoreLog);
            model.addAttribute("code", 0);

            return "json/attendanceLog/json/attendanceLogDetailJson";


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get attendanceLog error,id is  " + id);
            t.printStackTrace();
            model.addAttribute("code", -100000);
            return "common/fail";

        }

    }
}

