package com.ptteng.score.home.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.home.model.Tenant;
import com.ptteng.score.home.service.TenantService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class TenantServiceImpl extends BaseDaoServiceImpl implements TenantService {

 

	private static final Log log = LogFactory.getLog(TenantServiceImpl.class);



		   
		@Override
		public Long insert(Tenant tenant)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + tenant);

		if (tenant == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		tenant.setCreateAt(currentTimeMillis);
		tenant.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(tenant);
		} catch (DaoException e) {
			log.error(" insert wrong : " + tenant);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Tenant> insertList(List<Tenant> tenantList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (tenantList == null ? "null" : tenantList.size()));
      
		List<Tenant> resultList = null;

		if (CollectionUtils.isEmpty(tenantList)) {
			return new ArrayList<Tenant>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Tenant tenant : tenantList) {
			tenant.setCreateAt(currentTimeMillis);
			tenant.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Tenant>) dao.batchSave(tenantList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + tenantList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Tenant.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Tenant tenant)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (tenant == null ? "null" : tenant.getId()));

		boolean result = false;

		if (tenant == null) {
			return true;
		}

		tenant.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(tenant);
		} catch (DaoException e) {
			log.error(" update wrong : " + tenant);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + tenant);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Tenant> tenantList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (tenantList == null ? "null" : tenantList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(tenantList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Tenant tenant : tenantList) {
			tenant.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(tenantList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + tenantList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + tenantList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Tenant getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Tenant tenant = null;

		if (id == null) {
			return tenant;
		}

		try {
			tenant = (Tenant) dao.get(Tenant.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return tenant;		
		}	
		  
    	   
		@Override
		public List<Tenant> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Tenant> tenant = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Tenant>();
		}

		try {
			tenant = (List<Tenant>) dao.getList(Tenant.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (tenant == null ? "null" : tenant.size()));
    
		return tenant;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getTenantIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getTenantIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countTenantIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getTenantIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getTenantIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

