/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.score.admin.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.score.admin.model.ScoreLog;
import com.ptteng.score.admin.service.ScoreLogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScoreLogServiceImpl
extends BaseDaoServiceImpl
implements ScoreLogService {
    private static final Log log = LogFactory.getLog(ScoreLogServiceImpl.class);

    public Long insert(ScoreLog scoreLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + scoreLog));
        if (scoreLog == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        scoreLog.setCreateAt(Long.valueOf(currentTimeMillis));
        scoreLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)scoreLog);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + scoreLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ScoreLog> insertList(List<ScoreLog> scoreLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (scoreLogList == null ? "null" : Integer.valueOf(scoreLogList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(scoreLogList)) {
            return new ArrayList<ScoreLog>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreLog scoreLog : scoreLogList) {
            scoreLog.setCreateAt(Long.valueOf(currentTimeMillis));
            scoreLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(scoreLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + scoreLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ScoreLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ScoreLog scoreLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (scoreLog == null ? "null" : scoreLog.getId())));
        boolean result = false;
        if (scoreLog == null) {
            return true;
        }
        scoreLog.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)scoreLog);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + scoreLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + scoreLog));
        }
        return result;
    }

    public boolean updateList(List<ScoreLog> scoreLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (scoreLogList == null ? "null" : Integer.valueOf(scoreLogList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(scoreLogList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ScoreLog scoreLog : scoreLogList) {
            scoreLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(scoreLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + scoreLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + scoreLogList.size()));
        return result;
    }

    public ScoreLog getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ScoreLog scoreLog = null;
        if (id == null) {
            return scoreLog;
        }
        try {
            scoreLog = (ScoreLog)this.dao.get(ScoreLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return scoreLog;
    }

    public List<ScoreLog> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List scoreLog = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ScoreLog>();
        }
        try {
            scoreLog = this.dao.getList(ScoreLog.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (scoreLog == null ? "null" : Integer.valueOf(scoreLog.size()))));
        return scoreLog;
    }

    public List<Long> getScoreLogIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getScoreLogIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countScoreLogIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getScoreLogIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getScoreLogIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

