-- ----------------------------
-- Table structure for `orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `lessee_id` bigint NOT NULL   COMMENT '承租人ID',  
    `lessor_id` bigint NOT NULL   COMMENT '出租人ID',  
    `lease_start_at` bigint NOT NULL   COMMENT '租赁开始时间',  
    `lease_end_at` bigint NOT NULL   COMMENT '租赁结束时间',  
    `price` varchar(10) NOT NULL   COMMENT '订单价格',  
    `total_price` varchar(10) NOT NULL   COMMENT '总支付金额（订单价格+服务费）',  
    `lessee_message` varchar(100)    COMMENT '承租人留言',  
    `lessor_message` varchar(100)    COMMENT '出租人留言',  
    `pay_at` bigint NOT NULL   COMMENT '支付时间',  
    `pay_status` tinyint NOT NULL   COMMENT '支付状态：1=支付成功，2=支付失败',  
    `status` tinyint NOT NULL   COMMENT '订单状态：见model注释或者接口文档约定',  
    `refund_at` bigint    COMMENT '退款时间',  
    `order_no` varchar(30) NOT NULL   COMMENT '订单号',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





