package com.ptteng.rent.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.WxFormIdWarehouse;
import com.ptteng.rent.user.service.WxFormIdWarehouseService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class WxFormIdWarehouseServiceImpl extends BaseDaoServiceImpl implements WxFormIdWarehouseService {

 

	private static final Log log = LogFactory.getLog(WxFormIdWarehouseServiceImpl.class);



		   
		@Override
		public Long insert(WxFormIdWarehouse wxFormIdWarehouse)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + wxFormIdWarehouse);

		if (wxFormIdWarehouse == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		wxFormIdWarehouse.setCreateAt(currentTimeMillis);
		wxFormIdWarehouse.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(wxFormIdWarehouse);
		} catch (DaoException e) {
			log.error(" insert wrong : " + wxFormIdWarehouse);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<WxFormIdWarehouse> insertList(List<WxFormIdWarehouse> wxFormIdWarehouseList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (wxFormIdWarehouseList == null ? "null" : wxFormIdWarehouseList.size()));
      
		List<WxFormIdWarehouse> resultList = null;

		if (CollectionUtils.isEmpty(wxFormIdWarehouseList)) {
			return new ArrayList<WxFormIdWarehouse>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (WxFormIdWarehouse wxFormIdWarehouse : wxFormIdWarehouseList) {
			wxFormIdWarehouse.setCreateAt(currentTimeMillis);
			wxFormIdWarehouse.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<WxFormIdWarehouse>) dao.batchSave(wxFormIdWarehouseList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + wxFormIdWarehouseList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(WxFormIdWarehouse.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(WxFormIdWarehouse wxFormIdWarehouse)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (wxFormIdWarehouse == null ? "null" : wxFormIdWarehouse.getId()));

		boolean result = false;

		if (wxFormIdWarehouse == null) {
			return true;
		}

		wxFormIdWarehouse.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(wxFormIdWarehouse);
		} catch (DaoException e) {
			log.error(" update wrong : " + wxFormIdWarehouse);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + wxFormIdWarehouse);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<WxFormIdWarehouse> wxFormIdWarehouseList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (wxFormIdWarehouseList == null ? "null" : wxFormIdWarehouseList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(wxFormIdWarehouseList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (WxFormIdWarehouse wxFormIdWarehouse : wxFormIdWarehouseList) {
			wxFormIdWarehouse.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(wxFormIdWarehouseList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + wxFormIdWarehouseList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + wxFormIdWarehouseList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public WxFormIdWarehouse getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		WxFormIdWarehouse wxFormIdWarehouse = null;

		if (id == null) {
			return wxFormIdWarehouse;
		}

		try {
			wxFormIdWarehouse = (WxFormIdWarehouse) dao.get(WxFormIdWarehouse.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return wxFormIdWarehouse;		
		}	
		  
    	   
		@Override
		public List<WxFormIdWarehouse> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<WxFormIdWarehouse> wxFormIdWarehouse = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<WxFormIdWarehouse>();
		}

		try {
			wxFormIdWarehouse = (List<WxFormIdWarehouse>) dao.getList(WxFormIdWarehouse.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (wxFormIdWarehouse == null ? "null" : wxFormIdWarehouse.size()));
    
		return wxFormIdWarehouse;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getWxFormIdWarehouseIdsByType(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,start,limit  : " + type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getWxFormIdWarehouseIdsByType", new Object[] { type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,start,limit)  : " + type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countWxFormIdWarehouseIdsByType(Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type  : " + type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getWxFormIdWarehouseIdsByType", new Object[] { type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type)  : " + type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getWxFormIdWarehouseIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getWxFormIdWarehouseIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countWxFormIdWarehouseIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getWxFormIdWarehouseIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getWxFormIdWarehouseIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

