package com.ptteng.rent.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.rent.user.model.Verified;
import com.ptteng.rent.user.service.VerifiedService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class VerifiedServiceImpl extends BaseDaoServiceImpl implements VerifiedService {

 

	private static final Log log = LogFactory.getLog(VerifiedServiceImpl.class);



		   
		@Override
		public Long insert(Verified verified)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + verified);

		if (verified == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		verified.setCreateAt(currentTimeMillis);
		verified.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(verified);
		} catch (DaoException e) {
			log.error(" insert wrong : " + verified);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Verified> insertList(List<Verified> verifiedList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (verifiedList == null ? "null" : verifiedList.size()));
      
		List<Verified> resultList = null;

		if (CollectionUtils.isEmpty(verifiedList)) {
			return new ArrayList<Verified>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Verified verified : verifiedList) {
			verified.setCreateAt(currentTimeMillis);
			verified.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Verified>) dao.batchSave(verifiedList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + verifiedList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Verified.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Verified verified)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (verified == null ? "null" : verified.getId()));

		boolean result = false;

		if (verified == null) {
			return true;
		}

		verified.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(verified);
		} catch (DaoException e) {
			log.error(" update wrong : " + verified);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + verified);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Verified> verifiedList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (verifiedList == null ? "null" : verifiedList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(verifiedList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Verified verified : verifiedList) {
			verified.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(verifiedList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + verifiedList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + verifiedList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Verified getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Verified verified = null;

		if (id == null) {
			return verified;
		}

		try {
			verified = (Verified) dao.get(Verified.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return verified;		
		}	
		  
    	   
		@Override
		public List<Verified> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Verified> verified = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Verified>();
		}

		try {
			verified = (List<Verified>) dao.getList(Verified.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (verified == null ? "null" : verified.size()));
    
		return verified;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getVerifiedIdByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by uid  : " + uid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getVerifiedIdByUid", new Object[] {uid });
   } catch (DaoException e) {
			log.error(" get id wrong by uid  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getVerifiedIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getVerifiedIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countVerifiedIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getVerifiedIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getVerifiedIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

