package com.ptteng.rent.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.google.common.base.Splitter;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.model.UserCommentRelation;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserCommentCountService;
import com.ptteng.rent.user.service.UserCommentRelationService;
import com.ptteng.rent.user.utils.CommentCountUtils;
import com.ptteng.rent.user.utils.RandomCommentUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;


public class OrdersServiceImpl extends BaseDaoServiceImpl implements OrdersService {


    private static final Log log = LogFactory.getLog(OrdersServiceImpl.class);

    @Autowired
    private UserCommentRelationService userCommentRelationService;

    @Autowired
    private UserCommentCountService userCommentCountService;


    @Override
    public Long insert(Orders orders) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + orders);

        if (orders == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        orders.setCreateAt(currentTimeMillis);
        orders.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(orders);
        } catch (DaoException e) {
            log.error(" insert wrong : " + orders);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Orders> insertList(List<Orders> ordersList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (ordersList == null ? "null" : ordersList.size()));

        List<Orders> resultList = null;

        if (CollectionUtils.isEmpty(ordersList)) {
            return new ArrayList<Orders>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Orders orders : ordersList) {
            orders.setCreateAt(currentTimeMillis);
            orders.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Orders>) dao.batchSave(ordersList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + ordersList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Orders.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Orders orders) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (orders == null ? "null" : orders.getId()));

        boolean result = false;

        if (orders == null) {
            return true;
        }

        orders.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(orders);
        } catch (DaoException e) {
            log.error(" update wrong : " + orders);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + orders);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Orders> ordersList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (ordersList == null ? "null" : ordersList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(ordersList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Orders orders : ordersList) {
            orders.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(ordersList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + ordersList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + ordersList.size());

        return result;
    }


    @Override
    public Orders getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Orders orders = null;

        if (id == null) {
            return orders;
        }

        try {
            orders = (Orders) dao.get(Orders.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return orders;
    }


    @Override
    public List<Orders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Orders> orders = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Orders>();
        }

        try {
            orders = (List<Orders>) dao.getList(Orders.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (orders == null ? "null" : orders.size()));

        return orders;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getOrdersIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by orderNo  : " + orderNo);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getOrdersIdByOrderNo", new Object[]{orderNo});
        } catch (DaoException e) {
            log.error(" get id wrong by orderNo  : " + orderNo);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getOrdersIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by status,start,limit  : " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrdersIdsByStatus", new Object[]{status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by status,start,limit)  : " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getOrdersIdsByLesseeId(Long lesseeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by lesseeId,start,limit  : " + lesseeId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrdersIdsByLesseeId", new Object[]{lesseeId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by lesseeId,start,limit)  : " + lesseeId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getOrdersIdsByLessorId(Long lessorId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by lessorId,start,limit  : " + lessorId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrdersIdsByLessorId", new Object[]{lessorId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by lessorId,start,limit)  : " + lessorId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getOrdersIdByLesseeIdAndLessorIdAndStatus(Long lesseeId, Long lessorId, Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by lesseeId,lessorId,status  : " + lesseeId + " , " + lessorId + " , " + status);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getOrdersIdByLesseeIdAndLessorIdAndStatus", new Object[]{lesseeId, lessorId, status});
        } catch (DaoException e) {
            log.error(" get id wrong by lesseeId,lessorId,status  : " + lesseeId + " , " + lessorId + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countOrdersIdsByStatus(Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by status  : " + status);
        }
        Integer count = null;


        try {

            count = dao.count("getOrdersIdsByStatus", new Object[]{status});


        } catch (DaoException e) {
            log.error(" count ids  wrong by status)  : " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countOrdersIdsByLesseeId(Long lesseeId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by lesseeId  : " + lesseeId);
        }
        Integer count = null;


        try {

            count = dao.count("getOrdersIdsByLesseeId", new Object[]{lesseeId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by lesseeId)  : " + lesseeId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countOrdersIdsByLessorId(Long lessorId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by lessorId  : " + lessorId);
        }
        Integer count = null;


        try {

            count = dao.count("getOrdersIdsByLessorId", new Object[]{lessorId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by lessorId)  : " + lessorId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getOrdersIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrdersIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countOrdersIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getOrdersIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getOrdersIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }


    @Override
    public boolean randomSetUserCommentCount(List<Orders> notEvaluationNormalEndOrderList) throws Exception {

        if (CollectionUtils.isNotEmpty(notEvaluationNormalEndOrderList)) {

            List<UserCommentRelation> userCommentRelationList = new ArrayList<>();

            for (Orders orders : notEvaluationNormalEndOrderList) {

                String randomComment = RandomCommentUtil.getRandomComment();

                log.info("random comment is :" + randomComment);

                if (Orders.NOT_EVALUATION.equals(orders.getLesseeEvaluationStatus())) {

                    UserCommentRelation userCommentRelation = new UserCommentRelation();

                    userCommentRelation.setComment(randomComment);

                    userCommentRelation.setOid(orders.getId());

                    userCommentRelation.setLesseeId(orders.getLesseeId());

                    userCommentRelation.setLessorId(orders.getLessorId());

                    userCommentRelation.setType(UserCommentRelation.LESSOR_TO_LESSEE);

                    userCommentRelationList.add(userCommentRelation);

                    log.info("------------------------------------------");

                    List<String> commentToList = Splitter.on(",").trimResults().splitToList(randomComment);

                    log.info("common to list size is :" + commentToList.size());

                    getCommentCount(commentToList, orders.getLesseeId());

                    orders.setLesseeEvaluationStatus(Orders.IS_EVALUATION);

                } else if (Orders.NOT_EVALUATION.equals(orders.getLessorEvaluationStatus())) {

                    UserCommentRelation userCommentRelation = new UserCommentRelation();

                    userCommentRelation.setOid(orders.getId());

                    userCommentRelation.setComment(randomComment);

                    userCommentRelation.setLesseeId(orders.getLesseeId());

                    userCommentRelation.setLessorId(orders.getLessorId());

                    userCommentRelation.setType(UserCommentRelation.LESSEE_TO_LESSOR);

                    userCommentRelationList.add(userCommentRelation);

                    log.info("------------------------------------------");

                    List<String> commentToList = Splitter.on(",").trimResults().splitToList(randomComment);

                    log.info("common to list size is :" + commentToList.size());

                    getCommentCount(commentToList, orders.getLessorId());

                    orders.setLessorEvaluationStatus(Orders.IS_EVALUATION);

                } else {

                    log.info("**********************");

                    log.info("-------- :p -----------");

                }

            }

            this.updateList(notEvaluationNormalEndOrderList);

            List<UserCommentRelation> userCommentRelations = userCommentRelationService.insertList(userCommentRelationList);

            if (CollectionUtils.isEmpty(userCommentRelations)) {

                log.info("not comment normal order insert comment error");

            }


        }

        return false;
    }

    private void getCommentCount(List<String> commentList, Long uid) throws Exception {

        List<Long> userCommentCountIds = userCommentCountService.getUserCommentCountIdsByUid(uid, 0, 10);

        if (CollectionUtils.isEmpty(userCommentCountIds)) {

            UserCommentCount userCount = new UserCommentCount();

            log.info("-------------------" + userCount);

            CommentCountUtils.countComment(commentList, userCount);

            userCount.setUid(uid);

            Long userCommentCountId = userCommentCountService.insert(userCount);

            log.info("user comment count id is :" + userCommentCountId);

        } else {

            Long userCommentCountId = userCommentCountIds.get(0);

            UserCommentCount userCommentCount = userCommentCountService.getObjectById(userCommentCountId);

            CommentCountUtils.countComment(commentList, userCommentCount);

            boolean b = userCommentCountService.update(userCommentCount);

            if (b) {

                log.info("userCommentCount update success");

            } else {

                log.info("userCommentCount update fail");

                throw new Exception("update UserCommentCount Exception");
            }

        }

    }

}

