package com.ptteng.rent.user.utils;



import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ptteng.rent.user.utils.show.api.util.ShowApiUtils;
import com.ptteng.rent.user.utils.show.api.util.WebUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;


/**
 * 基于REST的客户端。
 */
public class ShowApiRequest extends NormalRequest  {
	private String appSecret;

	public ShowApiRequest(String url,String appid,String appSecret    ) {
		super(url);
		this.appSecret = appSecret;
		this.addTextPara("showapi_appid",appid);
		this.addHeadPara("User-Agent", "showapi-sdk-java");//设置默认头
	}


	public String getAppSecret() {
		return appSecret;
	}
	public void setAppSecret(String appSecret) {
		this.appSecret = appSecret;
	}

	private String addSign() throws IOException{
		boolean ismd5=true;
		if(textMap.get(Constants.SHOWAPI_APPID)==null)return errorMsg(Constants.SHOWAPI_APPID+"不得为空!");
		String signmethod=textMap.get(Constants.SHOWAPI_SIGN_METHOD);
		if(signmethod!=null&&!signmethod.equals("md5"))ismd5=false;
		if(signmethod!=null&&!signmethod.equals("md5")&&!signmethod.equals("hmac"))return errorMsg("showapi_sign_method参数只能是md5或hmac");

		if (ismd5) {
			textMap.put(Constants.SHOWAPI_SIGN, ShowApiUtils.signRequest(textMap, appSecret, false));
		} else {
			textMap.put(Constants.SHOWAPI_SIGN, ShowApiUtils.signRequest(textMap, appSecret, true));
		}
		return null;
	}

	public String post()   {
		String res=null;
		try {
			byte b[]=postAsByte() ;
			res= new String(b,"utf-8");
		} catch (Exception e) {
			if(printException)e.printStackTrace();
		}
		return res;
	}

	public byte[] postAsByte()   {
		byte res[]=null;
		try {
			String signResult=addSign();
			if(signResult!=null)return signResult.getBytes("utf-8");
			res= WebUtils.doPostAsByte(this);
		} catch (Exception e) {
			e.printStackTrace();
			try {
				res=("{showapi_res_code:-1,showapi_res_error:\""+e.toString()+"\"}").getBytes("utf-8");
			} catch (UnsupportedEncodingException e1) {
				e1.printStackTrace();
			}
		}
		return res;
	}


	public String get()   {
		String res=null;
		try {
			byte b[]=getAsByte();
			res=new String(b,"utf-8");
		} catch (Exception e) {
			e.printStackTrace();
			res="{showapi_res_code:-1,showapi_res_error:\""+e.toString()+"\"}";
		}
		return res;
	}

	public byte[] getAsByte()   {
		byte[]  res=null;
		try {
			String signResult=addSign();
			if(signResult!=null)return signResult.getBytes("utf-8");
			res=WebUtils.doGetAsByte(this);
		} catch (Exception e) {
			e.printStackTrace();
			try {
				res=("{showapi_res_code:-1,showapi_res_error:\""+e.toString()+"\"}").getBytes("utf-8");
			} catch (UnsupportedEncodingException e1) {
				e1.printStackTrace();
			}
		}
		return res;
	}

	private   String errorMsg(String msg){
		String str="{"+Constants.SHOWAPI_RES_CODE+":-1,"+Constants.SHOWAPI_RES_ERROR+":\""+msg+"\","+Constants.SHOWAPI_RES_BODY+":{}}";
		return str;
	}


    public static void main(String[] args) throws Exception {

//        String res=new ShowApiRequest("http://route.showapi.com/1072-1","67299","e4b9725f0dbf4efcaca1336591a58a39")
//                .addTextPara("idcard","650121199411151719")
//                .addTextPara("name","马伟")
//                .post();
//        System.out.println(res);

		String test = "{\"showapi_res_error\":\"\",\"showapi_res_code\":0,\"showapi_res_body\":{\"birthday\":\"1994-11-15\",\"ret_code\":0,\"sex\":\"M\",\"address\":\"新疆维吾尔族自治区乌鲁木齐市乌鲁木齐县\",\"code\":0,\"msg\":\"匹配\"}}";
		System.out.println(test);

		Gson gson = new Gson();
		//创建一个JsonParser
		JsonParser parser = new JsonParser();
		//通过JsonParser对象可以把json格式的字符串解析成一个JsonElement对象
		JsonElement el = parser.parse(test);

		JsonObject jsonObj = null;
		if(el.isJsonObject()){
			jsonObj = el.getAsJsonObject();
		}

		System.out.println(jsonObj.getAsJsonObject("showapi_res_body").get("code"));

		String hh = String.valueOf(jsonObj.getAsJsonObject("showapi_res_body").get("code"));

		System.out.println(hh);

		String SUCCESS = "0";

		UserVerifiedModel person = gson.fromJson(test, UserVerifiedModel.class);//对于javabean直接给出class实例
		System.out.println(person.toString());
		System.out.println(person.getShowapi_res_body().getCode());


		String hello = "";

		hello = "hahah";

		System.out.println(hello);
    }




}

