package com.ptteng.rent.user.controller;

import com.gemantic.common.util.MyListUtil;
import com.google.common.base.Splitter;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.model.User;
import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.model.UserCommentRelation;
import com.ptteng.rent.user.service.OrdersService;
import com.ptteng.rent.user.service.UserCommentCountService;
import com.ptteng.rent.user.service.UserCommentRelationService;
import com.ptteng.rent.user.service.UserService;
import com.ptteng.rent.user.utils.CommentCountUtils;
import com.ptteng.rent.user.utils.CommentParamsCheckUtils;
import com.ptteng.rent.user.utils.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * UserCommentRelation  crud
 *
 * @author ss127
 * @date 2018/6/7
 */
@Controller
public class UserCommentRelationController {
    private static final Log log = LogFactory.getLog(UserCommentRelationController.class);

    @Autowired
    private UserCommentRelationService userCommentRelationService;
    @Autowired
    private OrdersService ordersService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserCommentCountService userCommentCountService;


    /**
     * 评价
     *
     * @param request
     * @param response
     * @param model
     * @param lesseeId 承租人ID
     * @param lessorId 出租人ID
     * @param type     评价类型
     * @param oid      订单ID
     * @param comment  评论
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/evaluation", method = RequestMethod.POST)
    public String addUserCommentRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Long lesseeId, Long lessorId, Integer type, Long oid, String comment) throws Exception {

        log.info("url is : /a/u/evaluation?lesseeId=" + lesseeId + "&lessorId=" + lessorId + "&type=" + type + "&oid=" + oid + "&comment=" + comment);

        Integer code = CommentParamsCheckUtils.checkInsertUserCommentParams(lesseeId, lessorId, type, oid, comment);

        if (!CommentParamsCheckUtils.SUCCESS.equals(code)) {

            model.addAttribute("code", code);

            return "/common/success";

        }

        try {

            User lessor = userService.getObjectById(lessorId);

            if (DataUtils.isNullOrEmpty(lessor)) {

                log.info("lessor is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            Integer lessorUserType = lessor.getUserType();

            log.info("lessor id user type is :" + lessorUserType);
            //TODO 这里限制了用户身份，现在是否已经取消了身份限制
//            if (User.LESSEE.equals(lessorUserType)) {
//
//                log.info("lessor user type error.");
//
//                model.addAttribute("code", -4025);
//
//                return "/common/success";
//
//            }

            User lessee = userService.getObjectById(lesseeId);

            if (DataUtils.isNullOrEmpty(lessee)) {

                log.info("lessor is null");

                model.addAttribute("code", -2011);

                return "/common/success";

            }

            Integer lesseeUserType = lessee.getUserType();

            log.info("lessee id user type is :" + lesseeUserType);

//            if (User.LESSOR.equals(lesseeUserType)) {
//
//                log.info("lessee user type error");
//
//                model.addAttribute("code", -4025);
//
//                return "/common/success";
//            }

            List<String> commentToList = Splitter.on(",").trimResults().splitToList(comment);

            log.info("common to list size is :" + commentToList.size());

            if (commentToList.size() > UserCommentCount.UP_TO_FIVE) {

                log.info("comment up to five !!!");

                model.addAttribute("code", -4005);

                return "/common/success";

            }

            if (UserCommentRelation.LESSEE_TO_LESSOR.equals(type)) {

                // 承租人对出租人进行评价，对出租人评价标签进行计数
                log.info("lessee evaluation lessor");

                getCommentCount(commentToList, lessorId);


            } else if (UserCommentRelation.LESSOR_TO_LESSEE.equals(type)) {

                // 出租人对承租人进行评价，对承租人评价标签进行计数
                log.info("lessor evaluation lessee");

                getCommentCount(commentToList, lesseeId);

            } else {

                log.info("Illegal parameters ！");

                model.addAttribute("code", -996);

                return "/common/success";

            }

            UserCommentRelation userCommentRelation = new UserCommentRelation();

            userCommentRelation.setComment(comment);

            userCommentRelation.setLesseeId(lesseeId);

            userCommentRelation.setLessorId(lessorId);

            userCommentRelation.setType(type);

            Orders orders = ordersService.getObjectById(oid);

            if (DataUtils.isNullOrEmpty(orders)) {

                log.info("comment order is :" + orders);

                model.addAttribute("code", -3000);

                return "/common/success";

            }

            if (UserCommentRelation.LESSEE_TO_LESSOR.equals(type)) {

                Integer lesseeEvaluationStatus = orders.getLesseeEvaluationStatus();

                log.info("lesseeEvaluationStatus is :" + lesseeEvaluationStatus);

                if (Orders.IS_EVALUATION.equals(lesseeEvaluationStatus)) {

                    log.info("this order lessee already evaluation");

                    model.addAttribute("code", -4026);

                    return "/common/success";

                }

                // 承租人已评价
                orders.setLesseeEvaluationStatus(Orders.IS_EVALUATION);

            } else if (UserCommentRelation.LESSOR_TO_LESSEE.equals(type)) {

                Integer lessorEvaluationStatus = orders.getLessorEvaluationStatus();

                log.info("lessorEvaluationStatus is :" + lessorEvaluationStatus);

                if (Orders.IS_EVALUATION.equals(lessorEvaluationStatus)) {

                    log.info("this order lessor already evaluation");

                    model.addAttribute("code", -4027);

                    return "/common/success";

                }

                // 出租人已评价
                orders.setLessorEvaluationStatus(Orders.IS_EVALUATION);

            }

            Integer orderStatus = orders.getStatus();

            log.info("order status is :" + orderStatus);

            if (!Orders.COMPLETE_THE_ORDER_NORMALLY.equals(orderStatus)) {

                log.info("order status is Illegal");

                model.addAttribute("code", -3001);

                return "/common/success";

            }

            userCommentRelation.setOid(oid);

            Long userCommentRelationId = userCommentRelationService.insert(userCommentRelation);

            log.info("userCommentRelation id is :" + userCommentRelationId);

            if (DataUtils.isNullOrEmpty(userCommentRelationId)) {

                log.info("insert userCommentRelation is error");

                model.addAttribute("code", -4006);

                return "/common/success";

            }

            boolean b = ordersService.update(orders);

            if (b) {

                log.info("order update pay status success");

            } else {

                log.info("order update pay status fail");

                model.addAttribute("code", -6003);

                return "/common/success";

            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add userCommentRelation error ");
            model.addAttribute("code", -6003);
        }

        return "/common/success";
    }


    /**
     * 评论列表
     *
     * @param request
     * @param response
     * @param model
     * @param lessorId 出租人ID
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/evaluation/list", method = RequestMethod.GET)
    public String getuserCommentRelationList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, Long lessorId, Long lesseeId, Integer page,
                                             Integer size) throws Exception {

        log.info("url is : /a/u/evaluation/list?lessorId=" + lessorId + "&page=" + page + "&size=" + size);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        if (DataUtils.isNullOrEmpty(lessorId)) {

            log.info("lessor id is null");

            model.addAttribute("code", -4001);

            return "/common/success";

        }

        boolean next = false;

        Integer total = 0;

        try {


            Map<String, Object> commentParams = DynamicUtil.getLessorCommentList(lessorId,lesseeId, false);

            log.info("comment params is :" + commentParams);

            List<Long> commentIds = userCommentRelationService.getIdsByDynamicCondition(UserCommentRelation.class, commentParams, start, size);

            log.info("comment ids size :" + commentIds.size());

            List<UserCommentRelation> userCommentRelationList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(commentIds)) {

                userCommentRelationList = userCommentRelationService.getObjectsByIds(commentIds);

                if (userCommentRelationList.size() >= size) {

                    next = true;

                }

            }

            List<Long> lesseeIds = MyListUtil.getDistinctList(UserCommentRelation.class.getDeclaredField("lesseeId"), userCommentRelationList);

            log.info("lesseeIds size is :" + lesseeIds.size());

            List<User> userList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(lesseeIds)) {

                userList = userService.getObjectsByIds(lesseeIds);

            }

            Map<String, Object> commentCountParams = DynamicUtil.getLessorCommentList(lessorId,lesseeId, true);

            log.info("commentCountParams is :" + commentCountParams);

            List<Long> commentCountIds = userCommentRelationService.getIdsByDynamicCondition(UserCommentRelation.class,
                    commentCountParams, 0, Integer.MAX_VALUE);

            log.info("commentCountIds size :" + commentCountIds.size());

            if (CollectionUtils.isNotEmpty(commentCountIds)) {

                total = commentCountIds.size();

                log.info("total is :" + total);

            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("userList", userList);
            model.addAttribute("userCommentRelationList", userCommentRelationList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userCommentRelation list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/userCommentRelation/json/userCommentRelationListJson";

    }


    private void getCommentCount(List<String> commentList, Long uid) throws Exception {


        List<Long> userCommentCountIds = userCommentCountService.getUserCommentCountIdsByUid(uid, 0, 10);

        if (CollectionUtils.isEmpty(userCommentCountIds)) {

            UserCommentCount userCount = new UserCommentCount();

            log.info("-------------------" + userCount);

            CommentCountUtils.countComment(commentList, userCount);

            userCount.setUid(uid);

            Long userCommentCountId = userCommentCountService.insert(userCount);

            log.info("user comment count id is :" + userCommentCountId);

        } else {

            Long userCommentCountId = userCommentCountIds.get(0);

            UserCommentCount userCommentCount = userCommentCountService.getObjectById(userCommentCountId);

            CommentCountUtils.countComment(commentList, userCommentCount);

            boolean b = userCommentCountService.update(userCommentCount);

            if (b) {

                log.info("userCommentCount update success");

            } else {

                log.info("userCommentCount update fail");

                throw new Exception("update UserCommentCount Exception");
            }

        }

    }

}

