package com.ptteng.rent.user.controller;

import com.ptteng.rent.user.model.UserCommentCount;
import com.ptteng.rent.user.service.UserCommentCountService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * UserCommentCount  crud
 *
 * @author ss127
 * @date 2018/6/7
 */
@Controller
public class UserCommentCountController {
    private static final Log log = LogFactory.getLog(UserCommentCountController.class);

    @Autowired
    private UserCommentCountService userCommentCountService;

    /**
     * 我收到的评价
     *
     * @param request
     * @param response
     * @param model
     * @param uid      用户ID
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/evaluation/{uid}", method = RequestMethod.GET)
    public String getuserCommentCountList(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, @PathVariable Long uid) throws Exception {

        log.info("url is : /a/u/evaluation/" + uid);

        if (DataUtils.isNullOrEmpty(uid)) {

            log.info("uid is null");

            model.addAttribute("code", -2033);

            return "/common/success";

        }

        try {

            List<Long> userCommentCountIds = userCommentCountService.getUserCommentCountIdsByUid(uid, 0, 10);

            UserCommentCount userCommentCount = new UserCommentCount();

            if (CollectionUtils.isNotEmpty(userCommentCountIds)) {

                log.info("userCommentCountIds is  :" + userCommentCountIds.get(0));

                userCommentCount = userCommentCountService.getObjectById(userCommentCountIds.get(0));

            }

            model.addAttribute("code", 0);
            model.addAttribute("userCommentCount", userCommentCount);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get userCommentCount error,uid is  " + uid);
            model.addAttribute("code", -100000);
        }

        return "/rent-user-service/userCommentCount/json/userCommentCountDetailJson";

    }

}

