/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.base.Joiner;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.service.OrdersService;
import com.qding.community.common.weixin.service.WeiXinService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class OrdersFindLessorIsNotConfirmedEtl {
    private static final Log log = LogFactory.getLog(OrdersFindLessorIsNotConfirmedEtl.class);
    private OrdersService ordersService;
    @Autowired
    private WeiXinService weixinService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 15000L;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    log.info((Object)"--------------ETL 1-----------------");
                    log.info((Object)"find lessor is not confirmed etl is start!");
                    List<Orders> endAutoOrderList = this.getEndAutoList();
                    log.info((Object)("end auto order list size :" + endAutoOrderList.size()));
                    if (CollectionUtils.isEmpty(endAutoOrderList)) {
                        log.info((Object)"orders push etl not get any id ,sleep 15000 ms ");
                    } else {
                        this.processOrder(endAutoOrderList);
                    }
                    Thread.sleep(15000L);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(15000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<Orders> getEndAutoList() {
        log.info((Object)"end auto order search start!!!");
        List endAutoOrders = new ArrayList();
        ArrayList<Orders> resultEndAutoOrder = new ArrayList<Orders>();
        Map<String, Object> conditions = DynamicUtil.getAbnormalOrders();
        log.info((Object)("get end auto order params \uff1b" + conditions));
        try {
            List endAutoOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            log.info((Object)("end auto orders is :" + endAutoOrderIds));
            if (CollectionUtils.isNotEmpty((Collection)endAutoOrderIds)) {
                endAutoOrders = this.ordersService.getObjectsByIds(endAutoOrderIds);
            }
            for (Orders orders : endAutoOrders) {
                if (orders.getLeaseStartAt() >= System.currentTimeMillis()) continue;
                resultEndAutoOrder.add(orders);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return resultEndAutoOrder;
    }

    private void processOrder(List<Orders> endAutoOrder) throws ServiceException, ServiceDaoException, InterruptedException, IOException {
        log.info((Object)"Cancel overtime order");
        ArrayList<Long> uids = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(endAutoOrder)) {
            for (Orders orders : endAutoOrder) {
                log.info((Object)"hello,world");
                log.info((Object)"=================================");
                orders.setStatus(Orders.ORDER_TIME_OUT_CANCEL);
                log.info((Object)"==============(((((((()))))))))");
                log.info((Object)orders.getLesseeId());
                log.info((Object)orders.getLessorId());
                uids.add(orders.getLessorId());
                uids.add(orders.getLesseeId());
            }
            String uidListToString = Joiner.on((String)",").join(uids);
            int lesseeUpdate = this.jdbcTemplate.update("UPDATE user SET orders_status=1 where id in (" + uidListToString + ")");
            log.info((Object)("----------------" + lesseeUpdate));
            this.ordersService.updateList(endAutoOrder);
        }
    }

    public OrdersService getOrdersService() {
        return this.ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }
}

