/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.etl.util.wx.transfer.CollectionUtil;
import com.ptteng.rent.etl.util.wx.transfer.ConfigUtil;
import com.ptteng.rent.etl.util.wx.transfer.HttpUtils;
import com.ptteng.rent.etl.util.wx.transfer.PayUtil;
import com.ptteng.rent.etl.util.wx.transfer.XmlUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.service.OrdersService;
import com.qding.community.common.weixin.service.WeiXinService;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xmlpull.v1.XmlPullParserException;

public class LesseeRefundOrdersEtl {
    private static final Log log = LogFactory.getLog(LesseeRefundOrdersEtl.class);
    private OrdersService ordersService;
    @Autowired
    private WeiXinService weixinService;
    private static final int TASK_LEN = 1;
    private static final String REFUND = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private static final String APP_ID = ConfigUtil.getProperty("wx.appid");
    private static final String MCH_ID = ConfigUtil.getProperty("wx.mchid");
    private static final String API_SECRET = ConfigUtil.getProperty("wx.api.secret");
    private static final long SLEEP_MILLISECOND = 10000L;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    log.info((Object)"--------------ETL 6-----------------");
                    log.info((Object)"find lessee refund orders etl is start!");
                    List<Orders> normalEndOrderList = this.findNormalEndOrders();
                    log.info((Object)("normal end order list size :" + normalEndOrderList.size()));
                    if (CollectionUtils.isEmpty(normalEndOrderList)) {
                        log.info((Object)"orders push etl not get any id ,sleep 10000 ms ");
                    } else {
                        this.processOrder(normalEndOrderList);
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(10000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<Orders> findNormalEndOrders() {
        log.info((Object)"============------------===============");
        log.info((Object)"find normal end order method start!!!");
        List<Object> normalEndOrderList = new ArrayList<Orders>();
        Map<String, Object> conditions = DynamicUtil.getLesseeRefundOrderList();
        log.info((Object)("get normal end order params \uff1b" + conditions));
        try {
            List normalEndOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions, Integer.valueOf(0), Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)normalEndOrderIds)) {
                normalEndOrderList = this.ordersService.getObjectsByIds(normalEndOrderIds);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return normalEndOrderList;
    }

    private void processOrder(List<Orders> normaoEndOrderList) throws ServiceException, ServiceDaoException, InterruptedException, IOException, XmlPullParserException {
        log.info((Object)"***********************************");
        log.info((Object)"Transfer to lessor");
        if (CollectionUtils.isNotEmpty(normaoEndOrderList)) {
            Map<String, String> restmap = null;
            for (Orders orders : normaoEndOrderList) {
                String refundOrderNo = LesseeRefundOrdersEtl.generateCode();
                Integer orderStatus = orders.getStatus();
                log.info((Object)("order status is :" + orderStatus));
                String refund = "";
                if (LesseeRefundOrdersEtl.isRetirement(orderStatus).booleanValue()) {
                    refund = orders.getTotalPrice().multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString().toString();
                    log.info((Object)("refund is :" + refund));
                } else if (LesseeRefundOrdersEtl.isOrderFee(orderStatus).booleanValue()) {
                    refund = orders.getPrice().multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString().toString();
                    log.info((Object)("order fee refund is :" + refund));
                }
                try {
                    log.info((Object)("refund order number is :" + refundOrderNo));
                    HashMap<String, String> parm = new HashMap<String, String>();
                    parm.put("appid", APP_ID);
                    parm.put("mch_id", MCH_ID);
                    parm.put("nonce_str", PayUtil.getNonceStr());
                    parm.put("out_trade_no", orders.getOrderNo());
                    parm.put("out_refund_no", refundOrderNo);
                    parm.put("total_fee", orders.getTotalPrice().multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString().toString());
                    parm.put("refund_fee", refund);
                    log.info((Object)("------------------" + PayUtil.getSign(parm, API_SECRET)));
                    parm.put("sign", PayUtil.getSign(parm, API_SECRET));
                    log.info((Object)("parm is :" + parm));
                    String restxml = HttpUtils.posts(REFUND, XmlUtil.xmlFormat(parm, false));
                    restmap = XmlUtil.xmlParse(restxml);
                    log.info((Object)("rest map is :" + restmap));
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (CollectionUtil.isNotEmpty(restmap) && "SUCCESS".equals(restmap.get("result_code"))) {
                    log.info((Object)("\u8f6c\u8d26\u6210\u529f\uff1a" + (String)restmap.get("err_code") + ":" + (String)restmap.get("err_code_des")));
                    orders.setStatus(Orders.REFUNDED);
                    orders.setRefundOrderNo(refundOrderNo);
                    continue;
                }
                if (!CollectionUtil.isNotEmpty(restmap)) continue;
                log.info((Object)("\u8f6c\u8d26\u5931\u8d25\uff1a" + (String)restmap.get("err_code") + ":" + (String)restmap.get("err_code_des")));
            }
            boolean boo = this.ordersService.updateList(normaoEndOrderList);
            if (boo) {
                log.info((Object)"order update status success");
            } else {
                log.info((Object)"order update status fail");
                log.info((Object)"-------------------------");
            }
        }
    }

    private static String generateCode() {
        Long now = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        int num = (int)(Math.random() * 900.0) + 100;
        return now.toString() + Integer.toString(num);
    }

    public OrdersService getOrdersService() {
        return this.ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    private static Boolean isRetirement(Integer orderStatus) {
        if (Orders.LESSOR_IS_CONFIRMED_LESSEE_REFUND.equals(orderStatus) || Orders.ORDER_TIME_OUT_CANCEL.equals(orderStatus) || Orders.REFUSE_TO_TAKE_ORDERS.equals(orderStatus)) {
            return true;
        }
        return false;
    }

    private static Boolean isOrderFee(Integer orderStatus) {
        if (Orders.PROCESSING_LESSEE_REFUND_LESSOR_IS_CONFIRMED.equals(orderStatus) || Orders.PROCESSING_LESSEE_REFUND_SYSTEM_REFUND.equals(orderStatus) || Orders.PROCESSING_LESSOR_TERMINATION_ORDER.equals(orderStatus)) {
            return true;
        }
        return false;
    }
}

