package com.ptteng.rent.etl.util;

import com.alibaba.fastjson.JSON;

import com.ptteng.rent.etl.util.wx.model.JsonResult;
import com.ptteng.rent.etl.util.wx.model.ResponseData;
import com.ptteng.rent.etl.util.wx.transfer.*;
import org.apache.log4j.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;

public class TransferUtils {
    private static final Logger log = Logger.getLogger(TransferUtils.class);

    private static final String TRANSFERS_PAY = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers"; // 企业付款

    private static final String test = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";

    private static final String TRANSFERS_PAY_QUERY = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo"; // 企业付款查询

    private static final String APP_ID = ConfigUtil.getProperty("wx.appid");

    private static final String MCH_ID = ConfigUtil.getProperty("wx.mchid");

    private static final String API_SECRET = ConfigUtil.getProperty("wx.api.secret");


    public static int transferPay(String openid,String amount,String orderNumber) {
        log.info("[/transfer/pay]");
        //业务判断 openid是否有收款资格

        Map<String, String> restmap = null;
        try {

            Map<String, String> parm = new HashMap<String, String>();

            String nonce_str = PayUtil.getNonceStr();

            //公众账号appid
            parm.put("mch_appid", APP_ID);

            //商户号
            parm.put("mchid", MCH_ID);

            //随机字符串
            parm.put("nonce_str", nonce_str);

            //商户订单号
            parm.put("partner_trade_no", orderNumber);

            //用户openid
            parm.put("openid", openid);

            //校验用户姓名选项 OPTION_CHECK
            parm.put("check_name", "NO_CHECK");

            //parm.put("re_user_name", "安迪"); //check_name设置为FORCE_CHECK或OPTION_CHECK，则必填

            //转账金额
            parm.put("amount", amount);

            //企业付款描述信息
            parm.put("desc", "转账到个人");

            //Ip地址
            parm.put("spbill_create_ip", "127.0.0.1");

            parm.put("sign", PayUtil.getSign(parm, API_SECRET));

            log.info("parm is :" + parm);

            String restxml = HttpUtils.posts(TRANSFERS_PAY, XmlUtil.xmlFormat(parm, false));

            restmap = XmlUtil.xmlParse(restxml);

            log.info("rest map is :" + restmap);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        if (CollectionUtil.isNotEmpty(restmap) && "SUCCESS".equals(restmap.get("result_code"))) {
            log.info("转账成功：" + restmap.get("err_code") + ":" + restmap.get("err_code_des"));
            return 0;
        }else {
            if (CollectionUtil.isNotEmpty(restmap)) {
                log.info("转账失败：" + restmap.get("err_code") + ":" + restmap.get("err_code_des"));
            }
            return -4005;
        }
    }

    private static String exChange(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length(); i++) {
                char ch = str.charAt(i);
                if ('a' <= ch && ch <= 'z') {
                    sb.append(Character.toUpperCase(ch));
                } else {
                    sb.append(ch);
                }
            }
        }

        return sb.toString();
    }

}
