/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl.util;

import com.ptteng.rent.etl.util.wx.transfer.CollectionUtil;
import com.ptteng.rent.etl.util.wx.transfer.ConfigUtil;
import com.ptteng.rent.etl.util.wx.transfer.HttpUtils;
import com.ptteng.rent.etl.util.wx.transfer.PayUtil;
import com.ptteng.rent.etl.util.wx.transfer.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransferUtils {
    private static final Logger log = Logger.getLogger(TransferUtils.class);
    private static final String TRANSFERS_PAY = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
    private static final String test = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
    private static final String TRANSFERS_PAY_QUERY = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo";
    private static final String APP_ID = ConfigUtil.getProperty("wx.appid");
    private static final String MCH_ID = ConfigUtil.getProperty("wx.mchid");
    private static final String API_SECRET = ConfigUtil.getProperty("wx.api.secret");

    public static int transferPay(String openid, String amount, String orderNumber) {
        log.info((Object)"[/transfer/pay]");
        Map<String, String> restmap = null;
        try {
            HashMap<String, String> parm = new HashMap<String, String>();
            String nonce_str = PayUtil.getNonceStr();
            parm.put("mch_appid", APP_ID);
            parm.put("mchid", MCH_ID);
            parm.put("nonce_str", nonce_str);
            parm.put("partner_trade_no", orderNumber);
            parm.put("openid", openid);
            parm.put("check_name", "NO_CHECK");
            parm.put("amount", amount);
            parm.put("desc", "\u8f6c\u8d26\u5230\u4e2a\u4eba");
            parm.put("spbill_create_ip", "127.0.0.1");
            parm.put("sign", PayUtil.getSign(parm, API_SECRET));
            log.info((Object)("parm is :" + parm));
            String restxml = HttpUtils.posts("https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers", XmlUtil.xmlFormat(parm, false));
            restmap = XmlUtil.xmlParse(restxml);
            log.info((Object)("rest map is :" + restmap));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (CollectionUtil.isNotEmpty(restmap) && "SUCCESS".equals(restmap.get("result_code"))) {
            log.info((Object)("\u8f6c\u8d26\u6210\u529f\uff1a" + (String)restmap.get("err_code") + ":" + (String)restmap.get("err_code_des")));
            return 0;
        }
        if (CollectionUtil.isNotEmpty(restmap)) {
            log.info((Object)("\u8f6c\u8d26\u5931\u8d25\uff1a" + (String)restmap.get("err_code") + ":" + (String)restmap.get("err_code_des")));
        }
        return -4005;
    }

    private static String exChange(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if ('a' <= ch && ch <= 'z') {
                    sb.append(Character.toUpperCase(ch));
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }
}

