/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.rent.etl.util.DynamicUtil;
import com.ptteng.rent.user.model.Orders;
import com.ptteng.rent.user.service.OrdersService;
import com.qding.community.common.weixin.service.WeiXinService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrdersRunOutOfTimeEtl {
    private static final Log log = LogFactory.getLog(OrdersRunOutOfTimeEtl.class);
    private OrdersService ordersService;
    @Autowired
    private WeiXinService weixinService;
    private static final int TASK_LEN = 100;
    private static final long SLEEP_MILLISECOND = 15000L;
    private Long interval = 2000L;

    public void process() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    log.info((Object)"--------------ETL 3-----------------");
                    log.info((Object)"find run out of time etl is start!");
                    List<Orders> normalEndOrderList = this.findNormalEndOrders();
                    log.info((Object)("normal end order list size :" + normalEndOrderList.size()));
                    if (CollectionUtils.isEmpty(normalEndOrderList)) {
                        log.info((Object)"orders push etl not get any id ,sleep 15000 ms ");
                    } else {
                        this.processOrder(normalEndOrderList);
                    }
                    Thread.sleep(15000L);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(15000L);
                log.error((Object)("process goods bytime status error ,sleep " + t.getMessage()));
                continue;
            }
            break;
        }
    }

    private List<Orders> findNormalEndOrders() {
        log.info((Object)"============------------===============");
        log.info((Object)"find normal end order method start!!!");
        List normalEndOrderList = new ArrayList();
        ArrayList<Orders> runOutOfTimeOrders = new ArrayList<Orders>();
        Map<String, Object> conditions = DynamicUtil.getRunOutOfTimeOrders();
        log.info((Object)("get normal end order params \uff1b" + conditions));
        try {
            List normalEndOrderIds = this.ordersService.getIdsByDynamicCondition(Orders.class, conditions, Integer.valueOf(0), Integer.valueOf(100));
            if (CollectionUtils.isNotEmpty((Collection)normalEndOrderIds)) {
                normalEndOrderList = this.ordersService.getObjectsByIds(normalEndOrderIds);
            }
            for (Orders orders : normalEndOrderList) {
                if (orders.getLeaseEndAt() >= System.currentTimeMillis()) continue;
                runOutOfTimeOrders.add(orders);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t);
        }
        return runOutOfTimeOrders;
    }

    private void processOrder(List<Orders> normaoEndOrderList) throws ServiceException, ServiceDaoException, InterruptedException, IOException {
        log.info((Object)"***********************************");
        log.info((Object)"Transfer to lessor");
        if (CollectionUtils.isNotEmpty(normaoEndOrderList)) {
            for (Orders orders : normaoEndOrderList) {
                orders.setStatus(Orders.COMPLETE_THE_ORDER_NORMALLY);
                orders.setLessorEvaluationStatus(Orders.NOT_EVALUATION);
                orders.setLesseeEvaluationStatus(Orders.NOT_EVALUATION);
                orders.setEndOfOrderAt(Long.valueOf(System.currentTimeMillis()));
            }
            boolean boo = this.ordersService.updateList(normaoEndOrderList);
            if (boo) {
                log.info((Object)"order update status success");
            } else {
                log.info((Object)"order update status fail");
                log.info((Object)"-------------------------");
            }
        }
    }

    public OrdersService getOrdersService() {
        return this.ordersService;
    }

    public void setOrdersService(OrdersService ordersService) {
        this.ordersService = ordersService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }
}

