/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl.util.wx.transfer;

import com.ptteng.rent.etl.util.wx.transfer.CollectionUtil;
import com.ptteng.rent.etl.util.wx.transfer.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlUtil {
    private static final String PREFIX_XML = "<xml>";
    private static final String SUFFIX_XML = "</xml>";
    private static final String PREFIX_CDATA = "<![CDATA[";
    private static final String SUFFIX_CDATA = "]]>";

    public static String xmlFormat(Map<String, String> parm, boolean isAddCDATA) {
        StringBuffer strbuff = new StringBuffer(PREFIX_XML);
        if (CollectionUtil.isNotEmpty(parm)) {
            for (Map.Entry<String, String> entry : parm.entrySet()) {
                strbuff.append("<").append(entry.getKey()).append(">");
                if (isAddCDATA) {
                    strbuff.append(PREFIX_CDATA);
                    if (StringUtil.isNotEmpty(entry.getValue())) {
                        strbuff.append(entry.getValue());
                    }
                    strbuff.append(SUFFIX_CDATA);
                } else if (StringUtil.isNotEmpty(entry.getValue())) {
                    strbuff.append(entry.getValue());
                }
                strbuff.append("</").append(entry.getKey()).append(">");
            }
        }
        String str = strbuff.append(SUFFIX_XML).toString();
        System.out.println("str=" + str);
        return str;
    }

    public static Map<String, String> xmlParse(String xml) throws XmlPullParserException, IOException {
        HashMap<String, String> map = null;
        if (StringUtil.isNotEmpty(xml)) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
            XmlPullParser pullParser = XmlPullParserFactory.newInstance().newPullParser();
            pullParser.setInput((InputStream)inputStream, "UTF-8");
            int eventType = pullParser.getEventType();
            System.out.println("eventType=" + eventType);
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        map = new HashMap<String, String>();
                        break;
                    }
                    case 2: {
                        String key = pullParser.getName();
                        if (key.equals("xml")) break;
                        String value = pullParser.nextText().trim();
                        map.put(key, value);
                        break;
                    }
                }
                eventType = pullParser.next();
            }
        }
        return map;
    }
}

