/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl.util.wx.transfer;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static char[] DigitLower = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static char[] DigitUpper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getMD5Lower(String srcStr) throws NoSuchAlgorithmException {
        String sign = "lower";
        return MD5Utils.processStr(srcStr, sign);
    }

    public static String getMD5Upper(String srcStr) throws NoSuchAlgorithmException {
        String sign = "upper";
        return MD5Utils.processStr(srcStr, sign);
    }

    private static String processStr(String srcStr, String sign) throws NoSuchAlgorithmException, NullPointerException {
        String algorithm = "MD5";
        String result = "";
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(srcStr.getBytes());
        byte[] byteRes = digest.digest();
        int length = byteRes.length;
        for (int i = 0; i < length; ++i) {
            result = result + MD5Utils.byteHEX(byteRes[i], sign);
        }
        return result;
    }

    private static String byteHEX(byte bt, String sign) {
        char[] temp = null;
        if (sign.equalsIgnoreCase("lower")) {
            temp = DigitLower;
        } else if (sign.equalsIgnoreCase("upper")) {
            temp = DigitUpper;
        } else {
            throw new RuntimeException("\u52a0\u5bc6\u7f3a\u5c11\u5fc5\u8981\u7684\u6761\u4ef6");
        }
        char[] ob = new char[]{temp[bt >>> 4 & 0xF], temp[bt & 0xF]};
        return new String(ob);
    }

    public static String getMD5(String content) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(content.getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                continue;
            }
            md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return md5StrBuff.toString();
    }

    public static void main(String[] args) {
        String content = MD5Utils.getMD5("24358");
        System.out.println(content);
    }
}

