/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.rent.etl.util.wx.transfer;

import com.ptteng.rent.etl.util.wx.transfer.ConfigUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.springframework.core.io.ClassPathResource;

public class HttpUtils {
    private static final Log log = LogFactory.getLog(HttpUtils.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int CONNECT_TIME_OUT = 5000;
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(5000).build();
    private static SSLContext wx_ssl_context = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> params, Map<String, String> headers) {
        CloseableHttpClient httpClient = null;
        if (params != null && !params.isEmpty()) {
            StringBuffer param = new StringBuffer();
            boolean flag = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (flag) {
                    param.append("?");
                    flag = false;
                } else {
                    param.append("&");
                }
                param.append(entry.getKey()).append("=");
                try {
                    param.append(URLEncoder.encode(entry.getValue(), DEFAULT_CHARSET));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            url = url + param.toString();
        }
        String body = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.custom().setDefaultRequestConfig(REQUEST_CONFIG).build();
            HttpGet httpGet = new HttpGet(url);
            response = httpClient.execute((HttpUriRequest)httpGet);
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return body;
    }

    public static String get(String url) {
        return HttpUtils.get(url, null);
    }

    public static String get(String url, Map<String, String> params) {
        return HttpUtils.get(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> params) {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                nameValuePairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        String body = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.custom().setDefaultRequestConfig(REQUEST_CONFIG).build();
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, DEFAULT_CHARSET));
            response = httpClient.execute((HttpUriRequest)httpPost);
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String s) {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = new HttpPost(url);
        String body = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.custom().setDefaultRequestConfig(REQUEST_CONFIG).build();
            httpPost.setEntity((HttpEntity)new StringEntity(s, DEFAULT_CHARSET));
            response = httpClient.execute((HttpUriRequest)httpPost);
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String posts(String url, Map<String, String> params) {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                nameValuePairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        String body = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.custom().setDefaultRequestConfig(REQUEST_CONFIG).setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtils.getSSLConnectionSocket()).build();
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, DEFAULT_CHARSET));
            response = httpClient.execute((HttpUriRequest)httpPost);
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String posts(String url, String s) {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = new HttpPost(url);
        String body = null;
        CloseableHttpResponse response = null;
        try {
            httpClient = HttpClients.custom().setDefaultRequestConfig(REQUEST_CONFIG).setSSLSocketFactory((LayeredConnectionSocketFactory)HttpUtils.getSSLConnectionSocket()).build();
            httpPost.setEntity((HttpEntity)new StringEntity(s, DEFAULT_CHARSET));
            response = httpClient.execute((HttpUriRequest)httpPost);
            log.info((Object)("response=" + response));
            body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DEFAULT_CHARSET);
            log.info((Object)("response=" + body));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return body;
    }

    private static SSLConnectionSocketFactory getSSLConnectionSocket() {
        return new SSLConnectionSocketFactory(wx_ssl_context, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    static {
        ClassPathResource resource = new ClassPathResource("apiclient_cert.p12");
        try {
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            log.info((Object)("keystore=" + keystore));
            char[] keyPassword = ConfigUtil.getProperty("wx.mchid").toCharArray();
            keystore.load(resource.getInputStream(), keyPassword);
            wx_ssl_context = SSLContexts.custom().loadKeyMaterial(keystore, keyPassword).build();
            log.info((Object)("wx_ssl_context=" + wx_ssl_context));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

